/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.publish.wizards;

import com.ibm.etools.ftp.core.internal.PublishException;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.FileTransferWizardsPlugin;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.publish.api.IPublishManager;
import com.ibm.iwt.publish.api.PublishBaseOperation;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class PublishOperation
extends PublishBaseOperation {
    public PublishOperation(IResource resource, IStructuredSelection selection, PublishServerInfo publishServerInfo, String publishMethod, IOverwriteQuery overwriteImplementor) {
        super(resource, selection, publishServerInfo, publishMethod, overwriteImplementor);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        this.fMonitor = monitor;
        this.fMonitor.beginTask(ResourceHandler.Exporting_____UI_, -1);
        Vector elements = new Vector();
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            elements.addElement(iter.next());
        }
        Vector<IResource> processedElements = new Vector<IResource>();
        int elementsSize = elements.size();
        int i = 0;
        while (i < elementsSize) {
            IResource resource = (IResource)elements.elementAt(i);
            if (!this.hasParentResource(resource)) {
                processedElements.addElement(resource);
            }
            ++i;
        }
        this.fMonitor.done();
        this.fMonitor.beginTask(ResourceHandler.Publishing_____UI_, this.getPublishCount(processedElements));
        try {
            IPublishManager pm = FileTransferWizardsPlugin.getDefault().getPublishManager();
            try {
                pm.publish(processedElements, this.fPublishServerInfo, this.fPublishMethod, this.fOverwriteCallback, this);
            }
            catch (PublishException pe) {
                throw new CoreException(J2EEPlugin.newErrorStatus((String)pe.getMessage(), (Throwable)pe));
            }
        }
        finally {
            this.fMonitor.done();
            this.fMonitor = null;
        }
    }

    private int getPublishCount(Vector elements) {
        int count = 0;
        int elementsSize = elements.size();
        int i = 0;
        while (i < elementsSize) {
            IResource resource = (IResource)elements.elementAt(i);
            if (resource.getType() == 1) {
                ++count;
            } else if (resource.getType() == 2) {
                ++count;
            } else if (resource.getType() == 4) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean hasParentResource(IResource resource) {
        Vector elementsVector = new Vector();
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            elementsVector.addElement(iter.next());
        }
        int elementsSize = elementsVector.size();
        IContainer parent = resource.getParent();
        while (parent != null) {
            int i = 0;
            while (i < elementsSize) {
                IResource r = (IResource)elementsVector.elementAt(i);
                if (r.equals((Object)parent)) {
                    return true;
                }
                ++i;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void updateMonitor(String text) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(text);
            this.fMonitor.worked(1);
        }
    }
}

