/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.publish.api;

import com.ibm.iwt.publish.api.IPublishEngine;
import com.ibm.iwt.publish.api.IPublishEnginePlugin;

public class PublishEnginePlugin
implements IPublishEnginePlugin {
    private String fClassName;
    private String fId;
    private String fName;
    private String fDescription;
    private String fVersion;
    private String fVendorName;
    private IPublishEngine fPublishEngine = null;

    public PublishEnginePlugin() {
    }

    public PublishEnginePlugin(String id) {
        this.fId = id;
    }

    @Override
    public String getClassName() {
        return this.fClassName;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IPublishEngine getPublishEngine() {
        if (this.fPublishEngine == null) {
            this.loadPublishEngine();
        }
        return this.fPublishEngine;
    }

    @Override
    public String getVendorName() {
        return this.fVendorName;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public void loadPublishEngine() {
        try {
            Class<?> cls = Class.forName(this.fClassName);
            Object obj = cls.newInstance();
            if (obj instanceof IPublishEngine) {
                this.fPublishEngine = (IPublishEngine)obj;
                this.fPublishEngine.initialize(this);
            }
        }
        catch (Exception exception) {
            this.fPublishEngine = null;
        }
    }

    @Override
    public void setClassName(String className) {
        this.fClassName = className;
    }

    @Override
    public void setDescription(String description) {
        this.fDescription = description;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setVendorName(String vendorName) {
        this.fVendorName = vendorName;
    }

    @Override
    public void setVersion(String version) {
        this.fVersion = version;
    }
}

