/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.publish;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class PublishUtil {
    public static boolean canPublish(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            Path path = new Path(file.getName());
            String fileExt = path.getFileExtension();
            boolean extPublishable = true;
            return fileExt == null || extPublishable;
        }
        if (element instanceof IProject) {
            return J2EEProjectUtilities.isDynamicWebProject((IProject)((IProject)element)) || J2EEProjectUtilities.isStaticWebProject((IProject)((IProject)element));
        }
        if (element instanceof IFolder) {
            return J2EEProjectUtilities.isDynamicWebProject((IProject)((IFolder)element).getProject()) || J2EEProjectUtilities.isStaticWebProject((IProject)((IFolder)element).getProject());
        }
        return false;
    }

    public static boolean canPublish(ISelection selection) {
        boolean canPublish = false;
        if (selection instanceof IStructuredSelection) {
            IProject project = null;
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof IResource)) {
                    canPublish = false;
                    break;
                }
                IResource resource = (IResource)element;
                if (project == null) {
                    project = resource.getProject();
                    if (project == null) {
                        canPublish = false;
                        break;
                    }
                } else if (!project.equals((Object)resource.getProject())) {
                    canPublish = false;
                    break;
                }
                if (element instanceof IFile) {
                    if (canPublish) continue;
                    canPublish = PublishUtil.canPublish(element);
                    continue;
                }
                if (element instanceof IProject) {
                    if (canPublish) continue;
                    canPublish = PublishUtil.canPublish(element);
                    continue;
                }
                if (!(element instanceof IFolder) || canPublish) continue;
                canPublish = PublishUtil.canPublish(element);
            }
        }
        return canPublish;
    }
}

