/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.publish;

import com.ibm.etools.ftp.core.internal.PublishException;
import com.ibm.etools.ftp.core.internal.PublishInfo;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.publish.ManifestParser;
import com.ibm.iwt.publish.PublishUtil;
import com.ibm.iwt.publish.api.IPublishEngine;
import com.ibm.iwt.publish.api.IPublishEnginePlugin;
import com.ibm.iwt.publish.api.IPublishManager;
import com.ibm.iwt.publish.api.PublishBaseOperation;
import com.ibm.iwt.publish.api.PublishEnginePlugin;
import com.ibm.iwt.publish.wizards.PublishOperation;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PublishManager
implements IPublishManager {
    private String fHomeFolder = "";
    private Hashtable fPluginIdMap = new Hashtable();
    private Hashtable fPluginTypeMap = new Hashtable();
    private IPublishEngine fPublishEngine = null;
    private PublishOperation fPublishOperation = null;
    private int fSuccessfulCount = 0;
    private int fFailedCount = 0;
    private String fSuccessfulFiles = "";
    private String fFailedFiles = "";
    static final String PUBLISH_ENGINE_FOLDER_NAME = "PublishEngines";
    static final String PUBLISH_ENGINE_MANIFEST_FILE_NAME = "plugin.xml";
    static final String PUBLISH_ENGINE_MANIFEST_ELEMENT_PLUGIN = "plugin";

    private IPublishEnginePlugin addPlugin(String id) {
        PublishEnginePlugin publishEnginePlugin = null;
        if (this.hasPluginById(id) == null) {
            publishEnginePlugin = new PublishEnginePlugin(id);
            this.fPluginIdMap.put(id, publishEnginePlugin);
        }
        return publishEnginePlugin;
    }

    private void addPublishType(String publishType, IPublishEnginePlugin publishEnginePlugin) {
        this.fPluginTypeMap.put(publishType, publishEnginePlugin);
    }

    public int getFailedCount() {
        return this.fFailedCount;
    }

    public String getFailedFiles() {
        return this.fFailedFiles;
    }

    public String getPublishEnginePath() {
        File file = new File(this.fHomeFolder, PUBLISH_ENGINE_FOLDER_NAME);
        return file.getPath();
    }

    @Override
    public Vector getPublishMethods() {
        Vector<String> publishMethodsVector = new Vector<String>();
        Enumeration plugins = this.fPluginIdMap.elements();
        while (plugins.hasMoreElements()) {
            IPublishEnginePlugin plugin = (IPublishEnginePlugin)plugins.nextElement();
            publishMethodsVector.addElement(plugin.getName());
        }
        return publishMethodsVector;
    }

    public int getSuccessfulCount() {
        return this.fSuccessfulCount;
    }

    public String getSuccessfulFiles() {
        return this.fSuccessfulFiles;
    }

    public IPublishEnginePlugin hasPluginById(String id) {
        return (IPublishEnginePlugin)this.fPluginIdMap.get(id);
    }

    public IPublishEnginePlugin hasPluginByType(String type) {
        return (IPublishEnginePlugin)this.fPluginTypeMap.get(type);
    }

    @Override
    public void initialize(String homeFolder) throws PublishException {
        this.fHomeFolder = homeFolder;
        this.loadPlugins();
    }

    private void loadPlugin(String configFilePath) {
        try {
            File manifestFile = new File(configFilePath);
            ManifestParser mnfst = new ManifestParser();
            Document doc = mnfst.parse(manifestFile.getPath());
            Element root = doc.getDocumentElement();
            this.processManifest(configFilePath, root);
        }
        catch (Exception exception) {}
    }

    private void loadPlugins() {
        File basePublishEngineFolder = new File(this.getPublishEnginePath());
        String[] fls = basePublishEngineFolder.list();
        int i = 0;
        while (i < fls.length) {
            File configFile;
            File engineFolder = new File(basePublishEngineFolder, fls[i]);
            if (engineFolder.isDirectory() && (configFile = new File(engineFolder, PUBLISH_ENGINE_MANIFEST_FILE_NAME)).exists()) {
                this.loadPlugin(configFile.getPath());
            }
            ++i;
        }
    }

    private void processFailedPublish(PublishInfo publishInfo) {
        ++this.fFailedCount;
        this.fFailedFiles = String.valueOf(this.fFailedFiles) + "\n  " + publishInfo.getPublishPath();
    }

    private void processManifest(String configFilePath, Node node) {
        NamedNodeMap attrs;
        String id;
        IPublishEnginePlugin publishEnginePlugin;
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1 && node.getNodeName().equals(PUBLISH_ENGINE_MANIFEST_ELEMENT_PLUGIN) && (publishEnginePlugin = this.addPlugin(id = (attrs = node.getAttributes()).getNamedItem("id").getNodeValue())) != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                if (attrs.item(i).getNodeName().equals("name")) {
                    publishEnginePlugin.setName(attrs.item(i).getNodeValue());
                } else if (attrs.item(i).getNodeName().equals("version")) {
                    publishEnginePlugin.setVersion(attrs.item(i).getNodeValue());
                } else if (attrs.item(i).getNodeName().equals("description")) {
                    publishEnginePlugin.setDescription(attrs.item(i).getNodeValue());
                } else if (attrs.item(i).getNodeName().equals("class")) {
                    publishEnginePlugin.setClassName(attrs.item(i).getNodeValue());
                } else if (attrs.item(i).getNodeName().equals("vendor-name")) {
                    publishEnginePlugin.setVendorName(attrs.item(i).getNodeValue());
                }
                ++i;
            }
            if (publishEnginePlugin.getPublishEngine() == null) {
                return;
            }
            this.addPublishType(publishEnginePlugin.getName(), publishEnginePlugin);
        }
    }

    private void processSuccessfulPublish(PublishInfo publishInfo) {
        ++this.fSuccessfulCount;
        this.fSuccessfulFiles = String.valueOf(this.fSuccessfulFiles) + "\n  " + publishInfo.getPublishPath();
    }

    @Override
    public void publish(PublishInfo publishInfo) throws PublishException {
        this.fPublishEngine.publish(publishInfo);
    }

    @Override
    public void publish(Vector elements, PublishServerInfo si, String publishType, IOverwriteQuery overwriteImplementor, PublishBaseOperation publishOperation) throws PublishException {
        IPublishEnginePlugin plugin = this.hasPluginByType(publishType);
        this.fPublishOperation = (PublishOperation)publishOperation;
        if (plugin == null) {
            throw new PublishException(ResourceHandler.Publish_engine_plugin_not__EXC_, 1);
        }
        this.fPublishEngine = plugin.getPublishEngine();
        if (this.fPublishEngine == null) {
            throw new PublishException(ResourceHandler.Publish_engine_plugin_not_1_EXC_, 1);
        }
        this.fSuccessfulCount = 0;
        this.fFailedCount = 0;
        this.fSuccessfulFiles = "";
        this.fFailedFiles = "";
        try {
            this.fPublishEngine.setProgressMonitor(this.fPublishOperation.getProgressMonitor());
            this.fPublishEngine.setup(si);
            this.fPublishEngine.setOverwriteQuery(overwriteImplementor);
        }
        catch (PublishException e) {
            try {
                this.fPublishEngine.shutdown();
                this.fPublishEngine = null;
            }
            catch (Exception exception) {}
            throw e;
        }
        try {
            int elementsSize = elements.size();
            int i = 0;
            while (i < elementsSize) {
                Object element = elements.elementAt(i);
                if (element instanceof IProject) {
                    this.publishProject((IProject)element);
                } else if (element instanceof IFolder) {
                    this.publishFolder((IFolder)element);
                } else if (element instanceof IFile) {
                    this.publishFile((IFile)element);
                }
                ++i;
            }
        }
        finally {
            this.fPublishOperation = null;
            this.fPublishEngine.shutdown();
            this.fPublishEngine = null;
        }
    }

    private void publishFile(IFile file) throws PublishException {
        block6: {
            PublishInfo publishInfo = new PublishInfo();
            publishInfo.setLocalFile(file);
            publishInfo.setPublishMethod(this.fPublishEngine.getName());
            publishInfo.setPublishPath(file.getProjectRelativePath().toString());
            if (!PublishUtil.canPublish(file)) {
                this.processFailedPublish(publishInfo);
                return;
            }
            if (this.fPublishOperation != null) {
                if (!this.fPublishOperation.reportDetailedProgress(null)) {
                    throw new PublishException(NLS.bind((String)ResourceHandler._8concat_EXC_, (Object[])new Object[]{new Integer(this.getSuccessfulCount()), new Integer(this.getFailedCount())}), 8);
                }
                this.fPublishOperation.updateMonitor(file.getFullPath().toString());
            }
            try {
                this.publish(publishInfo);
                this.processSuccessfulPublish(publishInfo);
            }
            catch (PublishException pe) {
                this.processFailedPublish(publishInfo);
                if (pe.getExceptionType() == 8) {
                    throw new PublishException(NLS.bind((String)ResourceHandler._8concat_EXC_, (Object[])new Object[]{new Integer(this.getSuccessfulCount()), new Integer(this.getFailedCount())}), 8);
                }
                if (pe.getExceptionType() != 7) break block6;
                MessageDialog.openWarning(null, (String)ResourceHandler.Warning_UI_, (String)NLS.bind((String)ResourceHandler._4concat_EXC_, (Object[])new Object[]{publishInfo.getPublishPath()}));
            }
        }
    }

    private void publishFolder(IFolder folder) throws PublishException {
        if (this.fPublishOperation != null) {
            this.fPublishOperation.updateMonitor(folder.getFullPath().toString());
        }
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getType() == 2) {
                    this.publishFolder((IFolder)member);
                } else if (member.getType() == 1) {
                    this.publishFile((IFile)member);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            throw new PublishException();
        }
    }

    private void publishProject(IProject project) throws PublishException {
        if (this.fPublishOperation != null) {
            this.fPublishOperation.updateMonitor(project.getFullPath().toString());
        }
        try {
            IResource[] members = project.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getType() == 2) {
                    this.publishFolder((IFolder)member);
                } else if (member.getType() == 1) {
                    this.publishFile((IFile)member);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            throw new PublishException();
        }
    }
}

