/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport.wizards;

import com.ibm.etools.ftp.core.internal.PublishException;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.FileTransferWizardsPlugin;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.ftpexport.IContinueQuery;
import com.ibm.iwt.publish.api.IPublishManager;
import com.ibm.iwt.publish.api.PublishBaseOperation;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

public class FtpExportOperation
extends PublishBaseOperation {
    String fErrorString = null;
    String fStatsString = null;
    protected IContinueQuery fContinueCallback = null;

    public FtpExportOperation(IResource resource, IStructuredSelection selection, PublishServerInfo publishServerInfo, String publishMethod, IContinueQuery continueImplementor) {
        super(resource, selection, publishServerInfo, publishMethod, continueImplementor);
        this.fContinueCallback = continueImplementor;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(ResourceHandler.Export_to_FTP_1, 3);
        this.fMonitor = new SubProgressMonitor(monitor, 1);
        this.fMonitor.beginTask(ResourceHandler.Exporting_____UI_, 1);
        Vector elements = new Vector();
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            elements.addElement(iter.next());
        }
        Vector<IResource> processedElements = new Vector<IResource>();
        int elementsSize = elements.size();
        int i = 0;
        while (i < elementsSize) {
            IResource resource = (IResource)elements.elementAt(i);
            if (!this.hasParentResource(resource)) {
                processedElements.addElement(resource);
            }
            ++i;
        }
        this.fMonitor.worked(1);
        this.fMonitor.done();
        this.fMonitor = new SubProgressMonitor(monitor, 2);
        this.fMonitor.beginTask(ResourceHandler.Exporting_____UI_, this.getPublishCount(processedElements));
        try {
            IPublishManager pm = FileTransferWizardsPlugin.getDefault().getExportManager();
            try {
                pm.publish(processedElements, this.fPublishServerInfo, this.fPublishMethod, this.fOverwriteCallback, this);
            }
            catch (PublishException pe) {
                this.fErrorString = pe.getMessage();
            }
        }
        finally {
            this.fMonitor.worked(2);
            this.fMonitor.done();
            this.fMonitor = null;
            monitor.worked(3);
            monitor.done();
        }
    }

    public String getErrorString() {
        return this.fErrorString;
    }

    private int getPublishCount(Vector elements) {
        int count = 0;
        int elementsSize = elements.size();
        int i = 0;
        while (i < elementsSize) {
            IResource resource = (IResource)elements.elementAt(i);
            if (resource.getType() == 1) {
                ++count;
            } else if (resource.getType() == 2) {
                ++count;
            } else if (resource.getType() == 4) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getStatsString() {
        return this.fStatsString;
    }

    private boolean hasParentResource(IResource resource) {
        Vector elementsVector = new Vector();
        Iterator elements = this.fSelection.iterator();
        while (elements.hasNext()) {
            elementsVector.addElement(elements.next());
        }
        int elementsSize = elementsVector.size();
        IContainer parent = resource.getParent();
        while (parent != null) {
            int i = 0;
            while (i < elementsSize) {
                IResource r = (IResource)elementsVector.elementAt(i);
                if (r.equals((Object)parent)) {
                    return true;
                }
                ++i;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public String setStatsString(String stats) {
        this.fStatsString = stats;
        return this.fStatsString;
    }

    public void updateMonitor(IProgressMonitor monitor, String text) {
        if (monitor != null) {
            monitor.subTask(text);
            monitor.worked(1);
        }
    }
}

