/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport;

import com.ibm.etools.ftp.core.internal.PublishException;
import com.ibm.etools.ftp.core.internal.PublishInfo;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.ftpexport.IContinueQuery;
import com.ibm.iwt.ftpexport.wizards.FtpExportOperation;
import com.ibm.iwt.publish.api.IPublishEngine;
import com.ibm.iwt.publish.api.IPublishEnginePlugin;
import com.ibm.iwt.publish.api.IPublishManager;
import com.ibm.iwt.publish.api.PublishBaseOperation;
import com.ibm.iwt.publish.api.PublishEnginePlugin;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class FtpExportManager
implements IPublishManager {
    private String fHomeFolder = "";
    private Hashtable fPluginIdMap = new Hashtable();
    private Hashtable fPluginTypeMap = new Hashtable();
    private IPublishEngine fPublishEngine = null;
    private FtpExportOperation fFtpExportOperation = null;
    private int fSuccessfulCount = 0;
    private int fFailedCount = 0;
    private String fSuccessfulFiles = "";
    private String fFailedFiles = "";
    private boolean fPromptErrorIgnore = true;
    private IContinueQuery continueImplementor = null;
    static final String EXPORT_ENGINE_FOLDER_NAME = "ExportEngines";
    static final String EXPORT_ENGINE_MANIFEST_FILE_NAME = "plugin.xml";
    static final String EXPORT_ENGINE_MANIFEST_ELEMENT_PLUGIN = "plugin";
    static final String FTP_EXPORT_PUBLISHER_ID = "com.ibm.iwt.ftpexport.FtpExportEngine";
    static final String FTP_EXPORT_PUBLISHER_NAME = ResourceHandler.FTP_Export_UI_;

    public void addFTPExportPublisher() {
        IPublishEnginePlugin publishEnginePlugin = this.addPlugin(FTP_EXPORT_PUBLISHER_ID);
        publishEnginePlugin.setClassName(FTP_EXPORT_PUBLISHER_ID);
        publishEnginePlugin.setName(FTP_EXPORT_PUBLISHER_NAME);
        publishEnginePlugin.setVendorName("IBM");
        publishEnginePlugin.setVersion("1.0");
        this.addPublishType(publishEnginePlugin.getName(), publishEnginePlugin);
    }

    private IPublishEnginePlugin addPlugin(String id) {
        PublishEnginePlugin publishEnginePlugin = null;
        if (this.hasPluginById(id) == null) {
            publishEnginePlugin = new PublishEnginePlugin(id);
            this.fPluginIdMap.put(id, publishEnginePlugin);
        }
        return publishEnginePlugin;
    }

    private void addPublishType(String publishType, IPublishEnginePlugin publishEnginePlugin) {
        this.fPluginTypeMap.put(publishType, publishEnginePlugin);
    }

    public String getExportEnginePath() {
        File file = new File(this.fHomeFolder, EXPORT_ENGINE_FOLDER_NAME);
        return file.getPath();
    }

    public int getFailedCount() {
        return this.fFailedCount;
    }

    public String getFailedFiles() {
        return this.fFailedFiles;
    }

    @Override
    public Vector getPublishMethods() {
        Vector<String> publishMethodsVector = new Vector<String>();
        Enumeration plugins = this.fPluginIdMap.elements();
        while (plugins.hasMoreElements()) {
            IPublishEnginePlugin plugin = (IPublishEnginePlugin)plugins.nextElement();
            publishMethodsVector.addElement(plugin.getName());
        }
        return publishMethodsVector;
    }

    public IProgressMonitor getProgressMonitor() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (this.fFtpExportOperation != null) {
            monitor = this.fFtpExportOperation.getProgressMonitor();
        }
        return monitor;
    }

    public int getSuccessfulCount() {
        return this.fSuccessfulCount;
    }

    public String getSuccessfulFiles() {
        return this.fSuccessfulFiles;
    }

    public IPublishEnginePlugin hasPluginById(String id) {
        return (IPublishEnginePlugin)this.fPluginIdMap.get(id);
    }

    public IPublishEnginePlugin hasPluginByType(String type) {
        return (IPublishEnginePlugin)this.fPluginTypeMap.get(type);
    }

    @Override
    public void initialize(String homeFolder) throws PublishException {
        this.fHomeFolder = homeFolder;
        this.loadPlugins();
    }

    private void loadPlugins() {
        this.addFTPExportPublisher();
    }

    private void processFailedPublish(PublishInfo publishInfo) {
        ++this.fFailedCount;
        this.fFailedFiles = String.valueOf(this.fFailedFiles) + "\n\t" + publishInfo.getPublishPath();
    }

    private void processSuccessfulPublish(PublishInfo publishInfo) {
        ++this.fSuccessfulCount;
        this.fSuccessfulFiles = String.valueOf(this.fSuccessfulFiles) + "\n\t" + publishInfo.getPublishPath();
    }

    @Override
    public void publish(PublishInfo publishInfo) throws PublishException {
        this.fPublishEngine.publish(publishInfo);
    }

    @Override
    public void publish(Vector elements, PublishServerInfo si, String publishType, IOverwriteQuery overwriteImplementor, PublishBaseOperation publishOperation) throws PublishException {
        IPublishEnginePlugin plugin = this.hasPluginByType(publishType);
        this.fFtpExportOperation = (FtpExportOperation)publishOperation;
        if (plugin == null) {
            throw new PublishException(ResourceHandler.Publish_engine_plugin_not__UI_, 1);
        }
        this.fPublishEngine = plugin.getPublishEngine();
        if (this.fPublishEngine == null) {
            throw new PublishException(ResourceHandler.Publish_engine_plugin_not_1_UI_, 1);
        }
        this.fSuccessfulCount = 0;
        this.fFailedCount = 0;
        this.fSuccessfulFiles = "";
        this.fFailedFiles = "";
        this.fPromptErrorIgnore = true;
        this.continueImplementor = (IContinueQuery)overwriteImplementor;
        try {
            this.fPublishEngine.setProgressMonitor(this.fFtpExportOperation.getProgressMonitor());
            this.fPublishEngine.setup(si);
            this.fPublishEngine.setOverwriteQuery(overwriteImplementor);
        }
        catch (PublishException e) {
            try {
                this.fPublishEngine.shutdown();
                this.fPublishEngine = null;
            }
            catch (Exception exception) {}
            this.updateOperationStats();
            throw e;
        }
        try {
            int elementsSize = elements.size();
            int i = 0;
            while (i < elementsSize) {
                Object element = elements.elementAt(i);
                if (element instanceof IProject) {
                    this.publishProject((IProject)element, this.getProgressMonitor());
                } else if (element instanceof IFolder) {
                    this.publishFolder((IFolder)element, this.getProgressMonitor());
                } else if (element instanceof IFile) {
                    this.publishFile((IFile)element, this.getProgressMonitor());
                }
                ++i;
            }
        }
        finally {
            this.updateOperationStats();
            this.fFtpExportOperation = null;
            this.fPublishEngine.shutdown();
            this.fPublishEngine = null;
        }
    }

    private void publishFile(IFile file, IProgressMonitor monitor) throws PublishException {
        block6: {
            PublishInfo publishInfo = new PublishInfo();
            publishInfo.setLocalFile(file);
            publishInfo.setPublishMethod(this.fPublishEngine.getName());
            publishInfo.setPublishPath(file.getProjectRelativePath().toString());
            if (this.fFtpExportOperation != null) {
                if (this.fFtpExportOperation.reportDetailedProgress(null)) {
                    throw new PublishException(NLS.bind((String)ResourceHandler.publish_excep_EXC_, (Object[])new Object[]{Integer.toString(this.getSuccessfulCount()), Integer.toString(this.getFailedCount())}));
                }
                this.fFtpExportOperation.updateMonitor(monitor, file.getFullPath().toString());
            }
            try {
                this.publish(publishInfo);
                this.processSuccessfulPublish(publishInfo);
            }
            catch (PublishException pe) {
                this.processFailedPublish(publishInfo);
                if (pe.getExceptionType() == 8) {
                    throw new PublishException(NLS.bind((String)ResourceHandler.publish_excep_EXC_, (Object[])new Object[]{Integer.toString(this.getSuccessfulCount()), Integer.toString(this.getFailedCount())}));
                }
                if (!this.fPromptErrorIgnore || pe.getExceptionType() == 9) break block6;
                String infoString = null;
                infoString = pe.getExceptionType() == 7 ? NLS.bind((String)ResourceHandler.fileString_UI_, (Object[])new Object[]{publishInfo.getPublishPath()}) : NLS.bind((String)ResourceHandler.folder_for_file_UI_, (Object[])new Object[]{publishInfo.getPublishPath()});
                String Answer = this.continueImplementor.queryFileError(infoString);
                if (Answer.equals("NO")) {
                    throw new PublishException(NLS.bind((String)ResourceHandler.publish_excep_EXC_, (Object[])new Object[]{Integer.toString(this.getSuccessfulCount()), Integer.toString(this.getFailedCount())}));
                }
                if (!Answer.equals(IContinueQuery.IGNOREALL)) break block6;
                this.fPromptErrorIgnore = false;
            }
        }
    }

    private void publishFolder(IFolder folder, IProgressMonitor monitor) throws PublishException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            try {
                IResource[] members = folder.members();
                subMonitor.beginTask(ResourceHandler.Exporting_____UI_, members.length);
                subMonitor.subTask(folder.getFullPath().toString());
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member.getType() == 2) {
                        this.publishFolder((IFolder)member, (IProgressMonitor)subMonitor);
                    } else if (member.getType() == 1) {
                        this.publishFile((IFile)member, (IProgressMonitor)subMonitor);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                throw new PublishException();
            }
        }
        finally {
            subMonitor.worked(1);
            subMonitor.done();
        }
    }

    private void publishProject(IProject project, IProgressMonitor monitor) throws PublishException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            try {
                IResource[] members = project.members();
                subMonitor.beginTask(ResourceHandler.Exporting_____UI_, members.length);
                subMonitor.subTask(project.getFullPath().toString());
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member.getType() == 2) {
                        this.publishFolder((IFolder)member, (IProgressMonitor)subMonitor);
                    } else if (member.getType() == 1) {
                        this.publishFile((IFile)member, (IProgressMonitor)subMonitor);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                throw new PublishException();
            }
        }
        finally {
            subMonitor.worked(1);
            subMonitor.done();
        }
    }

    public void updateOperationStats() {
        int Ratio = 0;
        int Total = this.fSuccessfulCount + this.fFailedCount;
        if (Total > 0) {
            Ratio = 100 * this.fSuccessfulCount / Total;
        }
        this.fFtpExportOperation.setStatsString(NLS.bind((String)ResourceHandler.ExportStat_UI_, (Object[])new Object[]{Integer.toString(this.fSuccessfulCount), Integer.toString(Total), Integer.toString(Ratio)}));
    }
}

