/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.ftpexport;

import com.ibm.etools.ftp.core.FTPCoreActivator;
import com.ibm.etools.ftp.core.IDirectoryItem;
import com.ibm.etools.ftp.core.internal.FtpFirewall;
import com.ibm.etools.ftp.core.internal.FtpSupport;
import com.ibm.etools.ftp.core.internal.PublishException;
import com.ibm.etools.ftp.core.internal.PublishInfo;
import com.ibm.etools.ftp.core.internal.PublishServerInfo;
import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.publish.api.IPublishEngine;
import com.ibm.iwt.publish.api.IPublishEnginePlugin;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class FtpExportEngine
extends FtpSupport
implements IPublishEngine {
    private PublishServerInfo fServerInfo = null;
    private String fName = null;
    private String fRootFolder = null;
    private int fServerSocketTimeout = 30000;
    private boolean fPromptOverwrite = false;
    private boolean fToOverwrite = false;
    private PublishInfo currentPublishInfo = null;
    private IOverwriteQuery fOverwriteCallback = null;

    public void createFolders(String folderPath) throws PublishException {
        try {
            this.cd(folderPath);
        }
        catch (Exception exception) {
            try {
                this.createFolders(folderPath, this.fRootFolder);
            }
            catch (Exception e2) {
                throw new PublishException(e2.getMessage(), 0);
            }
        }
    }

    private void createFolders(String folderPath, String rootPath) throws PublishException {
        try {
            folderPath = folderPath.replace('\\', '/');
            rootPath = rootPath.replace('\\', '/');
            String createFolder = folderPath;
            if (folderPath.substring(0, rootPath.length()).equals(rootPath)) {
                createFolder = folderPath.substring(rootPath.length());
            }
            this.cd(rootPath);
            StringTokenizer tokenizer = new StringTokenizer(createFolder, "/");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                while (entry.endsWith(File.separator)) {
                    entry = entry.substring(0, entry.length() - 1);
                }
                try {
                    this.cd(entry);
                }
                catch (Exception exception) {
                    try {
                        this.mkdir(entry);
                        this.cd(entry);
                    }
                    catch (IOException b) {
                        b.printStackTrace();
                        throw new PublishException(b.getMessage(), 6);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PublishException(e.getMessage(), 6);
        }
    }

    public void createRootFolder() throws PublishException {
        try {
            this.cd(this.fRootFolder);
        }
        catch (Exception exception) {
            try {
                this.createFolders(this.fRootFolder, this.pwd());
            }
            catch (Exception e2) {
                throw new PublishException(e2.getMessage(), 6);
            }
        }
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public PublishServerInfo getServerInfo() {
        return this.fServerInfo;
    }

    @Override
    public void initialize(IPublishEnginePlugin plugin) throws PublishException {
        this.fName = plugin.getName();
    }

    @Override
    public void publish(PublishInfo publishInfo) throws PublishException {
        this.currentPublishInfo = publishInfo;
        IPath localPath = publishInfo.getLocalFile().getLocation();
        String filePath = localPath.removeLastSegments(1).addTrailingSeparator().toString().replace('\\', '/');
        String fileName = localPath.lastSegment().replace('\\', '/');
        String pubPath = new Path(publishInfo.getPublishPath()).removeLastSegments(1).addTrailingSeparator().toString().replace('\\', '/');
        String pubName = new Path(publishInfo.getPublishPath()).lastSegment().replace('\\', '/');
        if (pubPath.equals("/")) {
            pubPath = "";
        }
        String targetFolder = String.valueOf(this.fRootFolder) + pubPath;
        try {
            this.createFolders(targetFolder);
            this.cd(targetFolder);
        }
        catch (Exception e) {
            throw new PublishException(e.getMessage(), 6);
        }
        try {
            Path path;
            String fileExt;
            Vector directoryList = this.list();
            boolean fileExists = false;
            Enumeration enm = directoryList.elements();
            while (enm.hasMoreElements() && !fileExists) {
                IDirectoryItem item = (IDirectoryItem)enm.nextElement();
                if (!pubName.equals(item.getName())) continue;
                fileExists = true;
            }
            if (fileExists) {
                if (this.fPromptOverwrite) {
                    String overwriteAnswer = this.fOverwriteCallback.queryOverwrite(publishInfo.getPublishPath());
                    if (overwriteAnswer.equals("YES")) {
                        this.fToOverwrite = true;
                    }
                    if (overwriteAnswer.equals("NO")) {
                        this.fToOverwrite = false;
                    }
                    if (overwriteAnswer.equals("ALL")) {
                        this.fPromptOverwrite = false;
                        this.fToOverwrite = true;
                    }
                    if (overwriteAnswer.equals("CANCEL")) {
                        this.fPromptOverwrite = false;
                        this.fToOverwrite = false;
                        throw new PublishException(ResourceHandler.cancel_export_EXC_, 8);
                    }
                }
                if (!this.fToOverwrite) {
                    throw new PublishException(ResourceHandler.overwrite_existing_files_EXC_, 9);
                }
            }
            if ((fileExt = (path = new Path(fileName)).getFileExtension()) == null) {
                fileExt = "";
            }
            if (FTPCoreActivator.getDefault().getFileExtensionRegistry().getFtpAsciiMode(fileExt)) {
                this.ascii();
            } else {
                this.binary();
            }
            this.put(filePath, fileName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (UserCancelledException uce) {
            throw new PublishException(uce.getMessage(), 8);
        }
        catch (PublishException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PublishException(e.getMessage(), 7);
        }
    }

    @Override
    public void setup(PublishServerInfo si) throws PublishException {
        Integer i;
        this.fPromptOverwrite = true;
        this.fToOverwrite = false;
        this.fServerInfo = si;
        this.setPassiveTransferMode(this.fServerInfo.getPassiveMode());
        this.setConnectionTimeout(this.fServerInfo.getConnectionTimeout());
        if (!si.getUseFirewall()) {
            i = new Integer(this.fServerInfo.getFtpPort());
            String serverName = this.fServerInfo.getServerName();
            try {
                this.fUseSocks = false;
                this.openServer(serverName, i);
            }
            catch (Exception exception) {
                throw new PublishException(ResourceHandler.Failed_to_connect_to_the_s_ERROR_, 2);
            }
            try {
                this.serverSocket.setSoTimeout(this.fServerSocketTimeout);
                this.login(this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            }
            catch (Exception exception) {
                throw new PublishException(ResourceHandler.Invalid_user_name_password_EXC_, 2);
            }
        }
        i = new Integer(this.fServerInfo.getFtpPort());
        if (this.fServerInfo.getFirewallData().getUseSocks()) {
            try {
                this.fUseSocks = true;
                this.fSocksHostName = this.fServerInfo.getFirewallData().getSocksHostName();
                this.fSocksPort = this.fServerInfo.getFirewallData().getSocksPort();
                this.setPassiveTransferMode(true);
                this.openServer(this.fServerInfo.getServerName(), i);
            }
            catch (Exception exception) {
                throw new PublishException(ResourceHandler.connection_to_socks_failed_EXC_, 2);
            }
            try {
                this.login(this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            }
            catch (Exception exception) {
                throw new PublishException(ResourceHandler.Invalid_user_name_password_EXC_, 2);
            }
        }
        try {
            FtpFirewall firewallData = this.fServerInfo.getFirewallData();
            String hostname = firewallData.getHostname();
            int port = firewallData.getPort();
            this.openServer(hostname, port);
            this.serverSocket.setSoTimeout(this.fServerSocketTimeout);
            int type = firewallData.getType();
            if (type == 1) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall(this.fServerInfo.getServerName(), this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            } else if (type == 3) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall2(this.fServerInfo.getServerName(), this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            } else if (type == 2) {
                this.loginPastFirewall2(this.fServerInfo.getServerName(), this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            } else if (type == 4) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall3(this.fServerInfo.getServerName(), this.fServerInfo.getUserLogin(), this.fServerInfo.getPassword());
            }
        }
        catch (Exception exception) {
            throw new PublishException(ResourceHandler.connection_to_proxy_failed_EXC_, 2);
        }
        try {
            String ftpFolder = this.fServerInfo.getFtpFolder().replace('\\', '/');
            boolean absoluteFtpFolder = ftpFolder.startsWith("/");
            while (ftpFolder.startsWith("/")) {
                ftpFolder = ftpFolder.length() > 1 ? ftpFolder.substring(1) : "";
            }
            if (!ftpFolder.equals("") && !ftpFolder.endsWith("/")) {
                ftpFolder = String.valueOf(ftpFolder) + "/";
            }
            this.fRootFolder = absoluteFtpFolder ? "/" : this.pwd();
            this.fRootFolder = this.fRootFolder.endsWith("\\") || this.fRootFolder.endsWith("/") ? String.valueOf(this.fRootFolder) + ftpFolder : String.valueOf(this.fRootFolder) + "/" + ftpFolder;
        }
        catch (Exception exception) {
            throw new PublishException(ResourceHandler.Invalid_user_name_password_EXC_, 4);
        }
        try {
            this.createRootFolder();
        }
        catch (Exception exception) {
            throw new PublishException(ResourceHandler.Failed_to_create_or_naviga_EXC_, 5);
        }
    }

    @Override
    public void shutdown() throws PublishException {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            throw new PublishException(e.getMessage(), 3);
        }
    }

    protected String getProgressReport(long totalWorked) {
        long percentage = 100L;
        IFile localFile = this.currentPublishInfo.getLocalFile();
        File file = localFile.getLocation().toFile();
        if (file.length() > 0L) {
            percentage = totalWorked * 100L / file.length();
        }
        if (percentage < 0L) {
            percentage = 0L;
        } else if (percentage > 100L) {
            percentage = 100L;
        }
        return "(" + new Long(percentage).toString() + "%) " + localFile.getProjectRelativePath().toString();
    }

    @Override
    public void setOverwriteQuery(IOverwriteQuery overwriteCallback) {
        this.fOverwriteCallback = overwriteCallback;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

