/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.http;

import com.ibm.etools.ftp.ui.internal.ViewerItemList;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.util.FileSystemUtil;
import com.ibm.iwt.crawler.common.CommonUtil;
import com.ibm.iwt.crawler.common.URI;
import com.ibm.iwt.crawler.wizards.http.AddHostDialog;
import com.ibm.iwt.crawler.wizards.http.AdvancedSettingsDialog;
import com.ibm.iwt.crawler.wizards.http.HTTPCrawlerSession;
import com.ibm.iwt.crawler.wizards.http.HTTPImportOperation;
import com.ibm.iwt.crawler.wizards.http.HTTPImportPage2;
import com.ibm.iwt.crawler.wizards.http.HttpHost;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

class HTTPImportPage1
extends WizardPage
implements ISelectionChangedListener,
Listener,
IOverwriteQuery {
    private IResource fCurrentResourceSelection = null;
    private static final int SIZING_TEXT_FIELD_WIDTH = 225;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTP_PROTOCOL = "http";
    private static final String DEFAULT_PAGE = "index.html";
    private static final String idStartingUrl = "HTTPImportPage1.StartingUrl";
    private static final String idUseFireWall = "HTTPImportPage1Advance.UseProxy";
    private static final String idProxyPort = "HTTPImportPage1Advance.ProxyPort";
    private static final String idProxyServer = "HTTPImportPage1Advance.ProxyServer";
    private static final String idProxyType = "HTTPImportPage1Advance.ProxyType";
    private static final String idNoDepthLimitRadio = "HTTPImportPage2.NoDepthLimitRadio";
    private static final String idDepthValue = "HTTPImportPage2.DepthValue";
    protected TableViewer fHostsTable;
    private Combo fStartUrlField;
    private Button fContainerBrowseButton;
    private Text fContainerNameField;
    private Button fAddButton;
    private Button fDeleteButton;
    private Button fNoDepthLimitRadio;
    private Button fLimitToRadio;
    private Text fDepthField;
    private Button fAdvancedButton;
    private String fProxyServer = null;
    private int fProxyPort = 0;
    private boolean fUseFirewall = false;
    private int fProxyType = HTTPCrawlerSession.HTTP_PROXY;
    private HTTPImportPage2 fImportPage2 = null;
    private HTTPCrawlerSession fCrawlerSession = null;
    protected Text fHostNameField = null;
    public Text fDefaultPageField = null;

    public HTTPImportPage1(IStructuredSelection selection) {
        super("httpImportPage1");
        this.setTitle(ResourceHandler.HTTP_Import_1);
        this.setDescription(ResourceHandler.Specify_the_destination_folder_and_the_resources_to_import__2);
        this.fCurrentResourceSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            this.fCurrentResourceSelection = FileSystemUtil.initResource((IResource)((IResource)iter.next()), (boolean)false);
        }
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    public void createControl(Composite parent) {
        Composite shell = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 1;
        gl.numColumns = 3;
        shell.setLayout((Layout)gl);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        shell.setLayoutData((Object)data);
        Label containerLabel = new Label(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        containerLabel.setText(ResourceHandler.Container__UI_);
        containerLabel.setLayoutData((Object)data);
        this.fContainerNameField = new Text(shell, 2052);
        this.fContainerNameField.addListener(24, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 225;
        this.fContainerNameField.setLayoutData((Object)data);
        this.fContainerBrowseButton = new Button(shell, 8);
        this.fContainerBrowseButton.setText(ResourceHandler.Browse____UI_);
        this.fContainerBrowseButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.fContainerBrowseButton.setLayoutData((Object)data);
        Label startUrlLabel = new Label(shell, 0);
        startUrlLabel.setText(ResourceHandler.HTTP_URL_UI_);
        data = new GridData();
        data.horizontalAlignment = 4;
        startUrlLabel.setLayoutData((Object)data);
        this.fStartUrlField = new Combo(shell, 2048);
        this.fStartUrlField.addListener(24, (Listener)this);
        this.fStartUrlField.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 5;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 337;
        this.fStartUrlField.setLayoutData((Object)data);
        this.fAdvancedButton = new Button(shell, 8);
        this.fAdvancedButton.setText(ResourceHandler.Advanced____UI_);
        this.fAdvancedButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.fAdvancedButton.setLayoutData((Object)data);
        Label separator = new Label(shell, 258);
        data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        this.createIncludedDomainGroup(shell);
        Label depthCaptionLabel = new Label(shell, 0);
        depthCaptionLabel.setText(ResourceHandler.Depth_limit_when_following_UI_);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 3;
        depthCaptionLabel.setLayoutData((Object)data);
        new Label(shell, 0);
        Composite depthGroup = new Composite(shell, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        depthGroup.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        depthGroup.setLayoutData((Object)data);
        this.fNoDepthLimitRadio = new Button(depthGroup, 16);
        this.fNoDepthLimitRadio.setText(ResourceHandler.No_limit_UI_);
        this.fNoDepthLimitRadio.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.fNoDepthLimitRadio.setLayoutData((Object)data);
        this.fLimitToRadio = new Button(depthGroup, 16);
        this.fLimitToRadio.setText(ResourceHandler.Limit_to__UI_);
        this.fLimitToRadio.addListener(13, (Listener)this);
        this.fDepthField = new Text(depthGroup, 2052);
        this.fDepthField.addListener(24, (Listener)this);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 30;
        this.fDepthField.setLayoutData((Object)data);
        this.fStartUrlField.setFocus();
        this.restoreWidgetValues();
        if (this.fCurrentResourceSelection != null) {
            this.fContainerNameField.setText(this.fCurrentResourceSelection.getFullPath().makeRelative().toString());
        }
        this.setPageComplete(this.determinePageCompletion(false));
        this.setErrorMessage(null);
        this.setControl((Control)shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.etools.webtools.filetransfer.wizards.impw0004");
    }

    private void createIncludedDomainGroup(Composite hostDomainListGroup) {
        Label hostsLabel = new Label(hostDomainListGroup, 0);
        hostsLabel.setText(ResourceHandler.Hosts___UI_);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        hostsLabel.setLayoutData((Object)data);
        this.fHostsTable = new TableViewer(new Table(hostDomainListGroup, 100864));
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.fHostsTable.getTable().setLayout((Layout)tlayout);
        data = new GridData(1808);
        data.heightHint = 75;
        data.grabExcessHorizontalSpace = true;
        this.fHostsTable.getTable().setLayoutData((Object)data);
        this.fHostsTable.getTable().setHeaderVisible(true);
        this.fHostsTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof ViewerItemList) {
                    return ((ViewerItemList)element).getArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fHostsTable.setLabelProvider((IBaseLabelProvider)new HostTableLabelProvider());
        this.fHostsTable.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fHostsTable.setColumnProperties(new String[]{"host", "defaultPage"});
        this.fHostsTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.fHostsTable.getTable()), new TextCellEditor((Composite)this.fHostsTable.getTable())});
        this.fHostsTable.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if ("host".equals(property)) {
                    return ((HttpHost)element).getHostName();
                }
                if ("defaultPage".equals(property)) {
                    return ((HttpHost)element).getDefaultPage();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                HttpHost httpHost = (HttpHost)tableItem.getData();
                if ("host".equals(property)) {
                    httpHost.setHostName((String)value);
                } else if ("defaultPage".equals(property)) {
                    httpHost.setDefaultPage((String)value);
                }
                ViewerItemList hostList = (ViewerItemList)HTTPImportPage1.this.fHostsTable.getInput();
                hostList.fireItemUpdated((Object)httpHost);
            }
        });
        TableColumn tc1 = new TableColumn(this.fHostsTable.getTable(), 0);
        tc1.setText(ResourceHandler.Host_UI_);
        TableColumn tc2 = new TableColumn(this.fHostsTable.getTable(), 0);
        tc2.setText(ResourceHandler.Default_page_UI_);
        this.fHostsTable.setInput((Object)new ViewerItemList(this.fHostsTable));
        Composite buttons = new Composite(hostDomainListGroup, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        data = new GridData(128);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)data);
        this.fAddButton = new Button(buttons, 0x1000008);
        this.fAddButton.setText(ResourceHandler.Add_2);
        this.fAddButton.addListener(13, (Listener)this);
        data = new GridData(768);
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        this.fAddButton.setLayoutData((Object)data);
        this.fDeleteButton = new Button(buttons, 0x1000008);
        this.fDeleteButton.setText(ResourceHandler.Delete_UI_);
        this.fDeleteButton.addListener(13, (Listener)this);
        data = new GridData(768);
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        this.fDeleteButton.setLayoutData((Object)data);
    }

    protected boolean determinePageCompletion(boolean changeFocus) {
        this.setErrorMessage(null);
        if (this.getSeedUrl() == null) {
            if (this.fStartUrlField.getText().length() == 0) {
                this.setErrorMessage(ResourceHandler.Specify_Web_Server_URL__UI_);
            } else {
                this.setErrorMessage(ResourceHandler.Invalid_Web_Server_URL__UI_);
            }
            if (changeFocus) {
                this.fStartUrlField.setFocus();
            }
            return false;
        }
        try {
            CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(ResourceHandler.Invalid_Depth_Value__EXC_);
            return false;
        }
        IResource resource = this.getSpecifiedContainer();
        if (resource != null) {
            IProject targetProject = resource.getProject();
            if (targetProject == null) {
                this.setErrorMessage(ResourceHandler.Specify_a_valid_container__UI_);
                if (changeFocus) {
                    this.fContainerNameField.setFocus();
                }
                return false;
            }
        } else {
            this.setErrorMessage(ResourceHandler.Invalid_container_UI_);
            return false;
        }
        return true;
    }

    protected boolean ensureParamsAreValid() {
        if (this.getSeedUrl() == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Starting_url_specified_is__UI_);
            this.fStartUrlField.setFocus();
            return false;
        }
        try {
            CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Error_UI_, (String)ResourceHandler.Specify_a_valid_depth_valu_UI_);
            this.fDepthField.setFocus();
            return false;
        }
        return true;
    }

    protected boolean executeImportOperation(HTTPImportOperation op, IResource container) {
        String errorMessage;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            if (this.fCrawlerSession.isBuildProject() && this.fCrawlerSession.getNoOfFilesImported() > 0) {
                IProject project = container.getProject();
                project.build(10, null);
            }
        }
        catch (CoreException ce) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Import_Problems_UI_, (String)ce.toString());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (Exception ee) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Import_Problems_UI_, (String)ee.toString());
            return false;
        }
        if (this.fCrawlerSession.getFailedURLs() != null) {
            FailedURLsTableDialog dialog = new FailedURLsTableDialog(this.getShell(), this.fCrawlerSession.getFailedURLs());
            dialog.open();
        } else if (this.fCrawlerSession.getNoOfFilesImported() == 0 && (errorMessage = op.getErrorString()) != null && errorMessage.length() > 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ResourceHandler.Import_Error_UI_, (String)errorMessage);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureParamsAreValid()) {
            return false;
        }
        if (!this.fImportPage2.populateValues()) {
            return false;
        }
        this.saveWidgetValues();
        this.fImportPage2.saveWidgetValues();
        IResource container = this.getSpecifiedContainer();
        this.fCrawlerSession = new HTTPCrawlerSession(container.getProject());
        this.fCrawlerSession.setLocalFolder((IContainer)container);
        URL url = this.getSeedUrl();
        this.fCrawlerSession.setSeedUrl(url.toExternalForm());
        ViewerItemList hosts = (ViewerItemList)this.fHostsTable.getInput();
        if (hosts != null) {
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                this.fCrawlerSession.addIncludedHost((HttpHost)iter.next());
            }
        }
        int depth = -1;
        try {
            depth = CommonUtil.validateDepth(this.fDepthField.getText(), this.fNoDepthLimitRadio.getSelection());
        }
        catch (Exception exception) {
            return false;
        }
        this.fCrawlerSession.setDepth(depth);
        this.fCrawlerSession.setPromptWhenOverwritingFile(this.fImportPage2.isPromptForOverwriting());
        this.fCrawlerSession.setFixLinks(this.fImportPage2.isFixLinks());
        this.fCrawlerSession.setLinkStyle(0);
        this.fCrawlerSession.setBuildProject(false);
        this.fCrawlerSession.setConnectionTimeout(this.fImportPage2.getConnecionTimeout());
        this.fCrawlerSession.setFollowBackLinks(!this.fImportPage2.isOnlyFollowWithPrefix());
        this.fCrawlerSession.setCreateCorrespondingContainerStructure(this.fImportPage2.isCreateCorrespondingContainerStructure());
        if (this.fUseFirewall) {
            this.fCrawlerSession.setProxyType(this.fProxyType);
            this.fCrawlerSession.setProxyServer(this.fProxyServer);
            this.fCrawlerSession.setProxyServerPort(this.fProxyPort);
        }
        return this.executeImportOperation(new HTTPImportOperation(container, this.fCrawlerSession, this), container);
    }

    public HTTPImportPage2 getImportPage2() {
        return this.fImportPage2;
    }

    private URL getSeedUrl() {
        String urlString;
        URI uri;
        URL url = null;
        String rawString = this.fStartUrlField.getText();
        if (rawString != null) {
            rawString.trim();
            if (rawString.length() == 0) {
                return url;
            }
        } else {
            return null;
        }
        try {
            url = new URL(rawString);
        }
        catch (MalformedURLException malformedURLException) {
            rawString = HTTP_PREFIX + rawString;
            try {
                url = new URL(rawString);
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        if (url != null) {
            if (url.getProtocol() != null && !url.getProtocol().equalsIgnoreCase(HTTP_PROTOCOL)) {
                url = null;
            }
            if (url != null && url.getHost() != null && url.getHost().length() == 0) {
                url = null;
            }
        }
        if (url != null && (uri = new URI(urlString = url.toExternalForm())).getFileExtension() == null) {
            try {
                url = new URL(String.valueOf(urlString) + "/");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    protected IResource getSpecifiedContainer() {
        String pathString;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(pathString = new Path(this.fContainerNameField.getText().trim()).makeAbsolute().toString(), 7);
        if (result.isOK()) {
            Path path = new Path(pathString);
            if (workspace.getRoot().exists((IPath)path)) {
                return workspace.getRoot().findMember((IPath)path);
            }
        }
        return null;
    }

    private void handleAddDomains() {
        AddHostDialog dlg = new AddHostDialog(this.getShell());
        dlg.setBlockOnOpen(true);
        dlg.create();
        this.fHostsTable.cancelEditing();
        int rc = dlg.open();
        if (rc == 0) {
            HttpHost newHost = new HttpHost(dlg.getHost());
            String defaultPage = dlg.getDefaultPage();
            if (defaultPage != null && defaultPage.length() > 0) {
                newHost.setDefaultPage(defaultPage);
            } else {
                newHost.setDefaultPage(DEFAULT_PAGE);
            }
            ViewerItemList input = (ViewerItemList)this.fHostsTable.getInput();
            input.add((Object)newHost);
            this.fHostsTable.getTable().setFocus();
            this.fHostsTable.editElement((Object)newHost, 0);
        }
    }

    private void handleAdvancedOptions() {
        AdvancedSettingsDialog dlg = new AdvancedSettingsDialog(this.getShell());
        dlg.setUseFirewall(this.fUseFirewall);
        dlg.setProxyServer(this.fProxyServer);
        dlg.setProxyPort(this.fProxyPort);
        dlg.setProxyType(this.fProxyType);
        dlg.setBlockOnOpen(true);
        dlg.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.etools.webtools.filetransfer.wizards.impw0009");
        int rc = dlg.open();
        if (rc == 0) {
            this.fProxyServer = dlg.getProxyServer();
            this.fProxyPort = dlg.getProxyPort();
            this.fUseFirewall = dlg.isUseFirewall();
            this.fProxyType = dlg.getProxyType();
        }
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status ret = new Status(0, "com.ibm.etools.webtools.filetransfer.wizards", 0, "", null);
                return ret;
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IContainer container;
                boolean ret = false;
                if (element instanceof IContainer && (container = (IContainer)element) != null && !container.toString().equals("") && container.isAccessible()) {
                    ret = true;
                }
                return ret;
            }
        };
    }

    protected void handleContainerBrowseButtonPressed() {
        IResource container = this.getSpecifiedContainer();
        if (container != null && container.getType() == 1) {
            container = container.getParent();
        }
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(ResourceHandler.Container_Selection_15);
        dialog.setMessage(ResourceHandler.Select_a_container_to_impo_UI_);
        dialog.addFilter(filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setInitialSelection((Object)container);
        if (dialog.open() == 0) {
            IProject project;
            IVirtualComponent webComponent;
            Object element = dialog.getFirstResult();
            if (element instanceof IContainer) {
                container = (IContainer)element;
            }
            if (container instanceof IProject && (webComponent = ComponentCore.createComponent((IProject)(project = (IProject)container))) != null) {
                container = webComponent.getRootFolder().getUnderlyingFolder();
            }
        }
        if (container != null) {
            this.fContainerNameField.setText(container.getFullPath().makeRelative().toString());
            this.setPageComplete(this.determinePageCompletion(true));
        }
    }

    private void handleDeleteDomains() {
        this.fHostsTable.cancelEditing();
        IStructuredSelection selection = (IStructuredSelection)this.fHostsTable.getSelection();
        ViewerItemList input = (ViewerItemList)this.fHostsTable.getInput();
        for (HttpHost host : selection) {
            input.remove((Object)host);
            this.fDeleteButton.setEnabled(false);
        }
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.fStartUrlField) {
            this.handleSeedUrlChanges();
        } else if (source == this.fContainerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        } else if (source == this.fAddButton) {
            this.handleAddDomains();
        } else if (source == this.fDeleteButton) {
            this.handleDeleteDomains();
        } else if (source == this.fLimitToRadio || source == this.fNoDepthLimitRadio) {
            if (this.fLimitToRadio.getSelection()) {
                this.fDepthField.setEnabled(true);
            } else {
                this.fDepthField.setEnabled(false);
            }
        } else if (source == this.fAdvancedButton) {
            this.handleAdvancedOptions();
        }
        this.setPageComplete(this.determinePageCompletion(false));
    }

    private void handleSeedUrlChanges() {
        String hostName = "";
        URL temp = this.getSeedUrl();
        if (temp != null && (hostName = temp.getHost()) != null) {
            ViewerItemList list = (ViewerItemList)this.fHostsTable.getInput();
            if (list.isEmpty()) {
                list.add((Object)new HttpHost(hostName, DEFAULT_PAGE));
            } else {
                HttpHost host = (HttpHost)list.get(0);
                host.setHostName(hostName);
                list.fireItemUpdated((Object)host);
            }
        }
    }

    public String queryOverwrite(String pathString) {
        final String[] buttonStrings = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        final String path = pathString;
        final int[] ret = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(HTTPImportPage1.this.getShell(), ResourceHandler.Question_UI_, null, NLS.bind((String)ResourceHandler.resource_already_exists_WARN_, (Object[])new Object[]{path}), 3, buttonStrings, 1);
                dialog.setBlockOnOpen(true);
                dialog.create();
                ret[0] = dialog.open();
            }
        });
        return this.delocalize(buttonStrings[ret[0]]);
    }

    protected String delocalize(String localizedStr) {
        if (localizedStr.equals(IDialogConstants.YES_LABEL)) {
            return "YES";
        }
        if (localizedStr.equals(IDialogConstants.NO_LABEL)) {
            return "NO";
        }
        if (localizedStr.equals(IDialogConstants.YES_TO_ALL_LABEL)) {
            return "ALL";
        }
        if (localizedStr.equals(IDialogConstants.CANCEL_LABEL)) {
            return "CANCEL";
        }
        return localizedStr;
    }

    private void restoreWidgetValues() {
        IDialogSettings store = this.getDialogSettings();
        String[] startingUrls = null;
        if (store != null) {
            startingUrls = store.getArray(idStartingUrl);
        }
        if (startingUrls != null && startingUrls.length > 0) {
            this.fStartUrlField.setText(startingUrls[0]);
            int i = 0;
            while (i < startingUrls.length) {
                this.fStartUrlField.add(startingUrls[i]);
                ++i;
            }
            if (store.getBoolean(idNoDepthLimitRadio)) {
                this.fNoDepthLimitRadio.setSelection(true);
                this.fLimitToRadio.setSelection(false);
            } else {
                this.fLimitToRadio.setSelection(true);
                this.fNoDepthLimitRadio.setSelection(false);
            }
            try {
                this.fDepthField.setText(new Integer(store.get(idDepthValue)).toString());
            }
            catch (NumberFormatException numberFormatException) {}
            this.fUseFirewall = store.getBoolean(idUseFireWall);
            this.fProxyServer = store.get(idProxyServer);
            try {
                this.fProxyPort = Integer.parseInt(store.get(idProxyPort));
                this.fProxyType = Integer.parseInt(store.get(idProxyType));
            }
            catch (NumberFormatException numberFormatException) {
                this.fProxyPort = 0;
                this.fProxyType = HTTPCrawlerSession.HTTP_PROXY;
            }
        } else {
            this.fStartUrlField.setText("");
            this.fNoDepthLimitRadio.setSelection(true);
            this.fUseFirewall = false;
            this.fProxyPort = 0;
            this.fProxyServer = null;
            this.fProxyType = HTTPCrawlerSession.HTTP_PROXY;
        }
        if (this.fLimitToRadio.getSelection()) {
            this.fDepthField.setEnabled(true);
        } else {
            this.fDepthField.setEnabled(false);
        }
        this.fDeleteButton.setEnabled(false);
    }

    protected void saveWidgetValues() {
        IDialogSettings store = this.getDialogSettings();
        if (store != null) {
            String[] startingUrls = store.getArray(idStartingUrl);
            if (startingUrls == null) {
                startingUrls = new String[]{};
            }
            startingUrls = this.addToHistory(startingUrls, this.fStartUrlField.getText());
            store.put(idStartingUrl, startingUrls);
            store.put(idNoDepthLimitRadio, this.fNoDepthLimitRadio.getSelection());
            store.put(idDepthValue, this.fDepthField.getText());
            store.put(idUseFireWall, this.fUseFirewall);
            store.put(idProxyServer, this.fProxyServer);
            store.put(idProxyPort, Integer.toString(this.fProxyPort));
            store.put(idProxyType, Integer.toString(this.fProxyType));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.fHostsTable) {
            IStructuredSelection selection = (IStructuredSelection)this.fHostsTable.getSelection();
            ViewerItemList input = (ViewerItemList)this.fHostsTable.getInput();
            if (selection.iterator().hasNext()) {
                HttpHost host = (HttpHost)selection.iterator().next();
                boolean enableDelete = true;
                if (input.get(0) == host) {
                    enableDelete = false;
                }
                this.fDeleteButton.setEnabled(enableDelete);
            }
        }
    }

    public void setImportPage2(HTTPImportPage2 newImportPage2) {
        this.fImportPage2 = newImportPage2;
    }

    private class FailedURLsTableDialog
    extends MessageDialog {
        private List<String> URLs;

        public FailedURLsTableDialog(Shell parentShell, List<String> URLs) {
            super(parentShell, ResourceHandler.Warning_UI_, null, ResourceHandler.urlsNotFound, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.URLs = URLs;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Table table = new Table(composite, 68352);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            table.setLayout((Layout)tableLayout);
            GridData tableData = new GridData(4, 4, true, true);
            tableData.heightHint = 100;
            tableData.horizontalSpan = 2;
            table.setLayoutData((Object)tableData);
            TableColumn headingColumn = new TableColumn(table, 0);
            headingColumn.setText("URL");
            TableViewer tableViewer = new TableViewer(table);
            tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    return null;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            tableViewer.setInput(this.URLs);
            return composite;
        }
    }

    private class HostTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HostTableLabelProvider() {
        }

        public Image getColumnImage(Viewer v, Object element, int columnIndex) {
            return this.getColumnImage(element, columnIndex);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Viewer v, Object element, int columnIndex) {
            return this.getColumnText(v, element, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            HttpHost host = (HttpHost)element;
            if (columnIndex == 0) {
                return host.getHostName();
            }
            return host.getDefaultPage();
        }
    }
}

