/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.http;

import com.ibm.iwt.crawler.common.CrawlerSession;
import com.ibm.iwt.crawler.common.IDefaultPageProvider;
import com.ibm.iwt.crawler.common.PhysicalLocationManager;
import com.ibm.iwt.crawler.wizards.http.HttpHost;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class HTTPCrawlerSession
extends CrawlerSession
implements IDefaultPageProvider {
    private int fProxyType = 1;
    private String fProxyServer = null;
    private int fProxyServerPort = 0;
    private boolean fFollowBackLinks = false;
    private Hashtable fIncludedHosts = new Hashtable();
    private PhysicalLocationManager fPhysicalLocationManager = null;
    public static int HTTP_PROXY = 1;
    public static int SOCKS_PROXY = 2;
    private List<String> fFailedURLs;

    public HTTPCrawlerSession(IProject project) {
        this.fPhysicalLocationManager = new PhysicalLocationManager(this, this, project);
    }

    public void addIncludedHost(HttpHost host) {
        this.fIncludedHosts.put(host.getHostName(), host);
    }

    @Override
    public String getDefaultPage(URL url) {
        String defaultPage = "default.htm";
        HttpHost host = (HttpHost)this.fIncludedHosts.get(url.getHost());
        if (host != null) {
            defaultPage = host.getDefaultPage();
        }
        return defaultPage;
    }

    public Enumeration getExcludedFolders() {
        return null;
    }

    public Enumeration getIncludedDomains() {
        return this.fIncludedHosts.keys();
    }

    public PhysicalLocationManager getPhysicalLocationManager() {
        return this.fPhysicalLocationManager;
    }

    public String getProxyServer() {
        return this.fProxyServer;
    }

    public int getProxyServerPort() {
        return this.fProxyServerPort;
    }

    public int getProxyType() {
        return this.fProxyType;
    }

    public boolean isFollowBackLinks() {
        return this.fFollowBackLinks;
    }

    public void setFollowBackLinks(boolean newFollowBackLinks) {
        this.fFollowBackLinks = newFollowBackLinks;
    }

    public void setProxyServer(String newProxyServer) {
        this.fProxyServer = newProxyServer;
    }

    public void setProxyServerPort(int newProxyServerPort) {
        this.fProxyServerPort = newProxyServerPort;
    }

    public void setProxyType(int proxyType) {
        this.fProxyType = proxyType;
    }

    public List<String> getFailedURLs() {
        return this.fFailedURLs;
    }

    public void addFailedURL(String url) {
        if (this.fFailedURLs == null) {
            this.fFailedURLs = new ArrayList<String>();
        }
        this.fFailedURLs.add(url);
    }
}

