/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.http;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.Link;
import com.ibm.iwt.crawler.common.links.ModelUtil;
import com.ibm.iwt.crawler.http.HTTPOutputStreamGenerator;
import com.ibm.iwt.crawler.http.HttpBodyListener;
import com.ibm.iwt.crawler.http.HttpConnection;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.HttpResponse;
import com.ibm.iwt.crawler.wizards.http.HTTPCrawlerSession;
import com.ibm.iwt.crawler.wizards.http.HTTPImportOperation;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTTPBodySaver
implements HttpBodyListener,
HTTPOutputStreamGenerator {
    private HTTPCrawlerSession fCrawlerSession = null;
    private HTTPImportOperation fImportOperation = null;
    private ConnectionFactory fConnectionFactory;
    private HttpResponse response = null;
    private IProgressMonitor fMonitor = null;
    private static final String TEMP_FILE_SUFFIX = "=";

    public HTTPBodySaver(HTTPCrawlerSession session, HTTPImportOperation op, IProgressMonitor monitor) {
        this.fCrawlerSession = session;
        this.fImportOperation = op;
        this.fMonitor = monitor;
    }

    @Override
    public void bodyReceived(HttpConnection connection, HttpRequest request, HttpResponse response) {
        if (response.getStatusCode() == 200 && !response.isAbortFlag()) {
            this.fCrawlerSession.oneMoreFileImported();
            URL absoluteUrl = this.fCrawlerSession.getPhysicalLocationManager().makeAbsoluteUrl(request.getURL());
            this.fConnectionFactory.addVisitedUrl(absoluteUrl);
            this.parseAndFix(connection, request, response);
        } else {
            this.cancelStream(response);
            this.fCrawlerSession.addFailedURL(this.fCrawlerSession.getPhysicalLocationManager().makeAbsoluteUrl(request.getURL()).toString());
        }
    }

    @Override
    public void cancelStream(HttpResponse response) {
        try {
            if (response.getOSTempDest() != null) {
                response.getOSTempDest().delete();
            }
        }
        catch (Exception exception) {}
        response.setAbortFlag(true);
        response.setOSFinalDest(null);
        response.setOSTempDest(null);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.fConnectionFactory;
    }

    @Override
    public boolean getOutputStream(URL name, HttpResponse response) throws IOException {
        IFile destination = this.fCrawlerSession.getPhysicalLocationManager().localFilePath(name, this.fCrawlerSession.isCreateCorrespondingContainerStructure(), true);
        DebugInfo dbg = new DebugInfo(this, "getOutputStream()");
        if ((destination = this.fImportOperation.addFile(destination, null)) != null) {
            response.setAbortFlag(false);
            response.setOSFinalDest(destination);
            File tmpFile = File.createTempFile(String.valueOf(destination.getName()) + TEMP_FILE_SUFFIX, null, new File(WebToolsPlugin.getWebToolsPlugin().getStateLocation().toString()));
            dbg.traceOut(NLS.bind((String)ResourceHandler._8concat_INFO_, (Object[])new Object[]{tmpFile.getPath()}));
            response.setOSTempDest(tmpFile);
            return true;
        }
        dbg.traceOut(ResourceHandler.No_File_will_be_added_INFO_);
        response.setOSFinalDest(null);
        response.setOSTempDest(null);
        response.setAbortFlag(true);
        return false;
    }

    private void parseAndFix(HttpConnection connection, HttpRequest request, HttpResponse response) {
        block9: {
            InputStream input = null;
            this.response = response;
            response.close();
            try {
                boolean html;
                IFile urlFileName = this.fCrawlerSession.getPhysicalLocationManager().localFilePath(request.getURL(), this.fCrawlerSession.isCreateCorrespondingContainerStructure(), true);
                IFile destination = response.getOSFinalDest();
                String fileLocation = destination != null ? destination.getLocation().toString() : urlFileName.getLocation().toString();
                if (fileLocation.endsWith(".gif") || fileLocation.endsWith(".jpg") || fileLocation.endsWith(".png") || fileLocation.endsWith(".js") || fileLocation.startsWith("javascript:")) {
                    return;
                }
                input = response.getBody();
                IContentDescription descriptionFor = Platform.getContentTypeManager().getDescriptionFor(input, fileLocation, null);
                boolean jsp = descriptionFor == null ? false : descriptionFor.getContentType().getId().equals(ContentTypeIdForJSP.ContentTypeID_JSP);
                boolean bl = html = descriptionFor == null ? false : descriptionFor.getContentType().getId().equals(ContentTypeIdForHTML.ContentTypeID_HTML);
                if (descriptionFor != null) {
                    descriptionFor.getContentType().getId().equals(ContentTypeIdForCSS.ContentTypeID_CSS);
                }
                if (jsp || html) {
                    response.resetBody();
                    String inputString = ModelUtil.inputStreamToString(input);
                    Path docPath = new Path(fileLocation);
                    IFile virtualFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(docPath.removeLastSegments(1).append(UUID.randomUUID().toString()));
                    IDOMModel domModel = ModelUtil.getVirtualDomModel(inputString, virtualFile);
                    response.resetBody();
                    String requestUrl = request.getURL().toString();
                    LinkNode virtualFileNode = ReferenceManager.getReferenceManager().getLinkNode((IResource)virtualFile);
                    SharedModel model = html || jsp ? new SharedModel("web.node.webpage", (Object)domModel, virtualFileNode) : new SharedModel("web.node.css", null, null);
                    Collection linksCollection = ReferenceManager.getReferenceManager().parseLinksOnly(Collections.emptySet(), model, null);
                    for (ILink link : linksCollection) {
                        URL urlNew;
                        URL url;
                        String urlWithoutQueryAndFragment;
                        String rawURL = AbstractWebProvider.trimQuotes((String)link.getLinkText());
                        if (rawURL == null || rawURL.length() == 0 || (urlWithoutQueryAndFragment = ModelUtil.getLinkWithoutQueryFragment(rawURL)) == null || urlWithoutQueryAndFragment.length() == 0 || (url = ModelUtil.getAbsoluteURL(requestUrl, urlWithoutQueryAndFragment)) == null) continue;
                        if (url.getFile().equals("") && url.toExternalForm().endsWith(url.getHost()) && (urlNew = new URL(String.valueOf(url.toExternalForm()) + "/")) != null) {
                            url = urlNew;
                        }
                        Link cLink = new Link(url, 1);
                        this.fConnectionFactory.addLink(cLink, request.getResourceElement());
                        URL absoluteUrl = this.fCrawlerSession.getPhysicalLocationManager().makeAbsoluteUrl(cLink.getUrl());
                        this.fConnectionFactory.addVisitedUrl(absoluteUrl);
                    }
                }
            }
            catch (Exception exception) {
                if (input == null) break block9;
                try {
                    input.close();
                }
                catch (Exception exception2) {}
            }
        }
    }

    @Override
    public void setConnectionFactory(ConnectionFactory fConnectionFactory) {
        this.fConnectionFactory = fConnectionFactory;
    }

    public void writeOutputFile() {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            return;
        }
        try {
            if (this.response == null) {
                return;
            }
            IFile targetFile = this.response.getOSFinalDest();
            if (!targetFile.exists()) {
                try {
                    this.createContainers(targetFile);
                    targetFile.create((InputStream)new ByteArrayInputStream(new String("").getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    return;
                }
            }
            this.response.getOSFinalDest().setContents(this.response.resetBody(), true, true, null);
            if (this.response.getOSTempDest() != null) {
                this.response.getOSTempDest().delete();
            }
            this.response.setBody(null);
            this.response = null;
        }
        catch (Exception e) {
            DebugInfo dbg = new DebugInfo(this, "writeOutputFile()");
            dbg.warningOut(e.toString());
        }
    }

    private void createContainers(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        if (!parent.exists()) {
            ContainerGenerator gen = new ContainerGenerator(parent.getFullPath());
            gen.generateContainer((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

