/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.wizards.ftp;

import com.ibm.etools.ftp.core.internal.FTPRequest;
import com.ibm.etools.ftp.core.internal.FTPResponse;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.ftp.FTPBodyListener;
import com.ibm.iwt.crawler.ftp.FTPConnection;
import com.ibm.iwt.crawler.ftp.FTPOutputStreamGenerator;
import com.ibm.iwt.crawler.wizards.ftp.FTPCrawlerSession;
import com.ibm.iwt.crawler.wizards.ftp.FTPImportOperation;
import com.ibm.iwt.webtools.WebToolsPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class FTPBodySaver
implements FTPBodyListener,
FTPOutputStreamGenerator {
    private FTPCrawlerSession fCrawlerSession = null;
    private FTPImportOperation fImportOperation = null;
    private ConnectionFactory fConnectionFactory;
    private boolean saveFromLinksModel = false;
    private FTPResponse response = null;
    private IProgressMonitor fMonitor = null;
    private static final String TEMP_FILE_SUFFIX = "=";

    public FTPBodySaver(FTPCrawlerSession session, FTPImportOperation op, IProgressMonitor monitor) {
        this.fCrawlerSession = session;
        this.fImportOperation = op;
        this.fMonitor = monitor;
    }

    @Override
    public void bodyReceived(FTPConnection connection, FTPRequest request, FTPResponse response) {
        this.response = response;
        DebugInfo dbg = new DebugInfo(this, "bodyReceived()");
        if (response.isAbortFlag()) {
            dbg.traceOut(ResourceHandler.Aborted__INFO_, 5);
            return;
        }
        this.fCrawlerSession.oneMoreFileImported();
    }

    @Override
    public void cancelStream(FTPResponse response) {
        try {
            if (response.getOSTempDest() != null) {
                response.getOSTempDest().delete();
            }
        }
        catch (Exception exception) {}
        try {
            IFile destination = response.getOSFinalDest();
            if (destination != null) {
                destination.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {}
        response.setAbortFlag(true);
        response.setOSFinalDest(null);
        response.setOSTempDest(null);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.fConnectionFactory;
    }

    @Override
    public boolean getOutputStream(URL name, FTPResponse response) throws IOException {
        IFile destination = this.fCrawlerSession.getPhysicalLocationManager().localFilePath(name, this.fCrawlerSession.isCreateCorrespondingContainerStructure(), true);
        if ((destination = this.fImportOperation.addFile(destination, null)) != null) {
            response.setAbortFlag(false);
            response.setOSFinalDest(destination);
            File tmpFile = File.createTempFile(String.valueOf(destination.getName()) + TEMP_FILE_SUFFIX, null, new File(WebToolsPlugin.getWebToolsPlugin().getStateLocation().toString()));
            if (tmpFile != null) {
                response.setOSTempDest(tmpFile);
            }
            return true;
        }
        response.setOSFinalDest(null);
        response.setOSTempDest(null);
        response.setAbortFlag(true);
        return false;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory fConnectionFactory) {
        this.fConnectionFactory = fConnectionFactory;
    }

    public void writeOutputFile() {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            return;
        }
        try {
            if (this.response == null) {
                return;
            }
            IFile targetFile = this.response.getOSFinalDest();
            if (!targetFile.exists()) {
                try {
                    this.createContainers(targetFile);
                    targetFile.create((InputStream)new ByteArrayInputStream(new String("").getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                    return;
                }
            }
            if (!this.saveFromLinksModel) {
                this.response.getOSFinalDest().setContents(this.response.getBody(), true, true, null);
            }
            if (this.response.getOSTempDest() != null) {
                this.response.getOSTempDest().delete();
            }
            this.response.setBody(null);
            this.response = null;
        }
        catch (Exception e) {
            DebugInfo dbg = new DebugInfo(this, "writeOutputFile()");
            dbg.warningOut(e.toString());
        }
    }

    private void createContainers(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        if (!parent.exists()) {
            ContainerGenerator gen = new ContainerGenerator(parent.getFullPath());
            gen.generateContainer((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

