/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.http.CrawlerConnectionFactory;
import com.ibm.iwt.crawler.http.HttpConnection;
import com.ibm.iwt.crawler.http.HttpHeadersListener;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.util.NLS;

public class HttpRedirectionHandler
implements HttpHeadersListener {
    CrawlerConnectionFactory connectionFactory;

    public HttpRedirectionHandler(CrawlerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void headersReceived(HttpConnection connection, HttpRequest request, HttpResponse response) {
        int status = response.getStatusCode();
        if (status != 301 && status != 302) {
            return;
        }
        try {
            String location = response.getHeaders().getHeader("Location");
            URL redirection = new URL(request.getURL(), location);
            this.connectionFactory.addUrl(new ResourceElement(redirection));
        }
        catch (MalformedURLException e) {
            DebugInfo dbg = new DebugInfo(this, "headersReceived()");
            dbg.warningOut(NLS.bind((String)ResourceHandler._25concat_EXC_, (Object[])new Object[]{e}));
        }
        catch (Exception e) {
            DebugInfo dbg = new DebugInfo(this, "headersReceived()");
            dbg.warningOut(NLS.bind((String)ResourceHandler._26concat_EXC_, (Object[])new Object[]{e}));
        }
        connection.setStopFlag();
    }
}

