/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.ConnectorFailureException;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.http.HttpConnection;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.http.RetrieverFailureException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.osgi.util.NLS;

public class FirewallHttpConnection
extends HttpConnection {
    private InetAddress socksAddress = null;
    private int socksPort;
    private InetAddress proxyAddress = null;
    private int proxyPort;
    private boolean connectedThroughProxy;

    public FirewallHttpConnection(HttpRequest request, InetAddress socksAddress, int socksPort, InetAddress proxyAddress, int proxyPort) {
        super(request);
        this.socksAddress = socksAddress;
        this.socksPort = socksPort;
        this.proxyAddress = proxyAddress;
        this.proxyPort = proxyPort;
    }

    @Override
    protected Socket connect(InetAddress address, int port) throws ConnectorFailureException {
        DebugInfo dbg;
        this.connectedThroughProxy = false;
        if (this.proxyAddress != null) {
            try {
                Socket socket = this.connectToProxy();
                this.connectedThroughProxy = true;
                return socket;
            }
            catch (ConnectorFailureException connectorFailureException) {
                dbg = new DebugInfo(this, "connect()");
                dbg.warningOut(ResourceHandler._1connection_to_proxy_failed_EXC_);
            }
        }
        if (this.socksAddress != null) {
            try {
                Socket socket = this.connectToSocks(address, port);
                return socket;
            }
            catch (ConnectorFailureException connectorFailureException) {
                dbg = new DebugInfo(this, "connect()");
                dbg.warningOut(ResourceHandler.connection_to_SOCKS_failed_EXC_);
            }
        }
        throw new ConnectorFailureException();
    }

    private Socket connectToProxy() throws ConnectorFailureException {
        return super.connect(this.proxyAddress, this.proxyPort);
    }

    private Socket connectToSocks(InetAddress address, int port) throws ConnectorFailureException {
        Socket socket = super.connect(this.socksAddress, this.socksPort);
        byte[] socksRequest = new byte[9];
        socksRequest[0] = 4;
        socksRequest[1] = 1;
        socksRequest[2] = (byte)(port >> 8);
        socksRequest[3] = (byte)port;
        byte[] addressBytes = address.getAddress();
        socksRequest[4] = addressBytes[0];
        socksRequest[5] = addressBytes[1];
        socksRequest[6] = addressBytes[2];
        socksRequest[7] = addressBytes[3];
        socksRequest[8] = 0;
        OutputStream os = null;
        InputStream is = null;
        try {
            os = socket.getOutputStream();
            os.write(socksRequest);
            os.flush();
            is = socket.getInputStream();
            socket.setSoTimeout(10000);
            byte[] socksReply = new byte[8];
            int bytesRead = 0;
            while (bytesRead < 8) {
                bytesRead += is.read(socksReply, bytesRead, 8 - bytesRead);
            }
            if (socksReply[0] != 0 || socksReply[1] != 90) {
                DebugInfo dbg = new DebugInfo(this, "connectToSocks()");
                dbg.warningOut(ResourceHandler.Bad_reply_from_SOCKS_serve_WARN_);
                os.close();
                is.close();
                socket.close();
            }
            return socket;
        }
        catch (IOException e) {
            try {
                DebugInfo dbg = new DebugInfo(this, "connectToSocks()");
                dbg.warningOut(NLS.bind((String)ResourceHandler._20concat_EXC_, (Object[])new Object[]{e}));
                os.close();
                is.close();
                socket.close();
                return socket;
            }
            catch (Exception exception) {
                throw new ConnectorFailureException();
            }
        }
    }

    @Override
    protected void fetch(Socket socket) throws RetrieverFailureException, UserCancelledException {
        if (this.connectedThroughProxy) {
            this.request.setUsingProxy();
        }
        super.fetch(socket);
    }
}

