/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.http;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.IURLFilter;
import com.ibm.iwt.crawler.common.Link;
import com.ibm.iwt.crawler.common.URLFilter;
import com.ibm.iwt.crawler.http.FirewallHttpConnection;
import com.ibm.iwt.crawler.http.HTTPOutputStreamGenerator;
import com.ibm.iwt.crawler.http.HttpBodyListener;
import com.ibm.iwt.crawler.http.HttpConnection;
import com.ibm.iwt.crawler.http.HttpHeadersListener;
import com.ibm.iwt.crawler.http.HttpRequest;
import com.ibm.iwt.crawler.wizards.http.HTTPCrawlerSession;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CrawlerConnectionFactory
implements ConnectionFactory {
    private Hashtable visitedUrls = new Hashtable();
    private Vector queue = new Vector();
    private Vector headersListeners = new Vector();
    private Vector bodyListeners = new Vector();
    private IURLFilter filter = new URLFilter();
    private InetAddress socksAddress = null;
    private int socksPort;
    private InetAddress proxyAddress = null;
    private HTTPOutputStreamGenerator ofsGenerator = null;
    private int proxyPort;
    private HTTPCrawlerSession fCrawlerSession;
    private String fTempFolder = "";
    private IProgressMonitor fMonitor = null;

    public CrawlerConnectionFactory(ResourceElement[] urls, HTTPCrawlerSession crawlerSession) throws UnknownHostException {
        int i = 0;
        while (i < urls.length) {
            this.addUrl(urls[i]);
            this.filter.addSiteHostname(urls[i].getUrl().getHost());
            ++i;
        }
        this.initConnectionParams(crawlerSession);
    }

    public CrawlerConnectionFactory(ResourceElement url, HTTPCrawlerSession crawlerSession) throws UnknownHostException {
        this.addUrl(url);
        this.filter.addSiteHostname(url.getUrl().getHost());
        this.initConnectionParams(crawlerSession);
    }

    public void addBodyListener(HttpBodyListener l) {
        this.bodyListeners.addElement(l);
    }

    public void addHeadersListener(HttpHeadersListener l) {
        this.headersListeners.addElement(l);
    }

    @Override
    public ResourceElement addLink(Link link, ResourceElement parent) {
        ResourceElement res = new ResourceElement(link.getUrl(), parent.getDepth() + 1);
        this.addUrl(res);
        return res;
    }

    public synchronized void addUrl(ResourceElement resource) {
        String urlKey = this.getBaseUrl(resource.getUrl());
        if (!this.visitedUrls.containsKey(urlKey)) {
            this.visitedUrls.put(urlKey, resource);
            this.queue.addElement(resource);
        }
    }

    @Override
    public void addVisitedUrl(URL url) {
        String urlKey = this.getBaseUrl(url);
        this.visitedUrls.put(urlKey, url);
    }

    protected String getBaseUrl(URL url) {
        String retVal = url.toString();
        int offset = retVal.indexOf(35);
        if (offset > 0) {
            retVal = retVal.substring(0, offset);
        }
        if ((offset = retVal.indexOf(63)) > 0) {
            retVal = retVal.substring(0, offset);
        }
        return retVal;
    }

    public int getConnectionTimeout() {
        return this.fCrawlerSession.getConnectionTimeout();
    }

    protected HttpConnection getHttpConnection(ResourceElement url) {
        HttpRequest request = new HttpRequest(url);
        HttpConnection connection = null;
        connection = this.socksAddress != null || this.proxyAddress != null ? new FirewallHttpConnection(request, this.socksAddress, this.socksPort, this.proxyAddress, this.proxyPort) : new HttpConnection(request);
        connection.setTempFolder(this.getTempFolder());
        connection.setConnectionTimeout(this.getConnectionTimeout());
        connection.setProgressMonitor(this.fMonitor);
        return connection;
    }

    @Override
    public Connection getNewConnection() {
        DebugInfo dbg = new DebugInfo(this, "getNewConnection()");
        while (!this.queue.isEmpty()) {
            ResourceElement resource = (ResourceElement)this.queue.elementAt(0);
            URL url = resource.getUrl();
            this.queue.removeElementAt(0);
            if (this.filter.shouldCrawl(resource)) {
                String protocol = url.getProtocol();
                if (protocol.equals("http")) {
                    HttpConnection connection = this.getHttpConnection(resource);
                    Enumeration e = this.headersListeners.elements();
                    while (e.hasMoreElements()) {
                        connection.addHeadersListener((HttpHeadersListener)e.nextElement());
                    }
                    e = this.bodyListeners.elements();
                    while (e.hasMoreElements()) {
                        connection.addBodyListener((HttpBodyListener)e.nextElement());
                    }
                    if (this.ofsGenerator == null) {
                        connection.bufferInputData();
                    } else {
                        connection.doNotBuffer(this.ofsGenerator);
                    }
                    this.fMonitor.setTaskName(NLS.bind((String)ResourceHandler.Importing_file___UI_, (Object[])new Object[]{new Integer(this.fCrawlerSession.getNoOfFilesImported() + 1).toString()}));
                    SubProgressMonitor subMonitor = new SubProgressMonitor(this.fMonitor, 1);
                    connection.setProgressMonitor((IProgressMonitor)subMonitor);
                    return connection;
                }
                dbg.traceOut(NLS.bind((String)ResourceHandler._22concat_INFO_, (Object[])new Object[]{url.toString()}));
                continue;
            }
            dbg.traceOut(NLS.bind((String)ResourceHandler._3concat_INFO_, (Object[])new Object[]{url.toString()}));
        }
        return null;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    public String getTempFolder() {
        return this.fTempFolder;
    }

    @Override
    public IURLFilter getURLFilter() {
        return this.filter;
    }

    public void setOfsGenerator(HTTPOutputStreamGenerator ofsGenerator) {
        this.ofsGenerator = ofsGenerator;
    }

    public void setProgressMonitor(IProgressMonitor newProgressListener) {
        this.fMonitor = newProgressListener;
    }

    public void setTempFolder(String newTempFolder) {
        this.fTempFolder = newTempFolder;
    }

    public void setURLFilter(IURLFilter filter) {
        this.filter = filter;
    }

    private void initConnectionParams(HTTPCrawlerSession crawlerSession) throws UnknownHostException {
        this.fCrawlerSession = crawlerSession;
        String proxyServer = crawlerSession.getProxyServer();
        if (proxyServer != null) {
            if (crawlerSession.getProxyType() == HTTPCrawlerSession.HTTP_PROXY) {
                this.proxyAddress = InetAddress.getByName(proxyServer);
                this.proxyPort = crawlerSession.getProxyServerPort();
            } else {
                this.socksAddress = InetAddress.getByName(proxyServer);
                this.socksPort = crawlerSession.getProxyServerPort();
            }
        }
    }
}

