/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.ftp;

import com.ibm.etools.ftp.core.FTPCoreActivator;
import com.ibm.etools.ftp.core.internal.FTPRequest;
import com.ibm.etools.ftp.core.internal.FTPResponse;
import com.ibm.etools.ftp.core.internal.FtpSupport;
import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.etools.ftp.core.internal.UserCancelledException;
import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.ImportException;
import com.ibm.iwt.crawler.ftp.FTPConnectionParams;
import com.ibm.iwt.crawler.ftp.FTPResourceElement;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ImportFtpService
extends FtpSupport {
    private String fHomeDirectory = "";
    private String fAS400Fix = " ";
    private int fServerSocketTimeout = 30000;
    private FTPConnectionParams fServerInfo = null;
    private String host = null;
    private int port = 21;
    private boolean getHomeDirectoryAfterLogin;
    private String currentFile = null;
    private long currentFileSize = 0L;
    private IProgressMonitor monitor;

    public ImportFtpService(String host, int port, FTPConnectionParams params, boolean getHomeDirectoryAfterLogin, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.fServerInfo = params;
        this.host = host;
        this.port = port;
        this.getHomeDirectoryAfterLogin = getHomeDirectoryAfterLogin;
    }

    private String adjustDirectoryPath(String p) {
        if (p.startsWith("/")) {
            p = p.length() > 1 ? p.substring(1) : "";
        }
        return String.valueOf(this.fHomeDirectory) + p;
    }

    public void getFile(FTPRequest request, FTPResponse response) throws ImportException, UserCancelledException {
        String path = "";
        try {
            ResourceElement re = request.getResourceElement();
            this.currentFile = path = re.getUrl().getFile();
            this.currentFileSize = re instanceof FTPResourceElement ? ((FTPResourceElement)re).getSize() : 0L;
            int lastindex = path.lastIndexOf("/");
            String p = path.substring(0, lastindex + 1);
            String fileName = path.substring(lastindex + 1);
            p = this.adjustDirectoryPath(p);
            this.cd(p);
            if (FTPCoreActivator.getDefault().getContentRegistry().getContentProperty(path).isAnAsciiFile()) {
                super.ascii();
            } else {
                super.binary();
            }
            super.get(fileName, response, this.monitor);
        }
        catch (IOException iOException) {
            throw new ImportException(NLS.bind((String)ResourceHandler.failed_to_get_file_EXC_, (Object)(String.valueOf(path) + ".")));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new ImportException(NLS.bind((String)ResourceHandler.failed_to_get_file_EXC_, (Object)(String.valueOf(path) + ".")));
        }
    }

    public Vector list(String folder) throws ImportException {
        try {
            folder = this.adjustDirectoryPath(folder);
            this.cd(folder);
            return this.list();
        }
        catch (IOException iOException) {
            throw new ImportException(NLS.bind((String)ResourceHandler.failed_to_get_listing_EXC_, (Object)(String.valueOf(folder) + ".")));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setup() throws ImportException {
        if (!this.fServerInfo.getUseFirewall() || this.fServerInfo.getFirewallData() == null) {
            try {
                this.openServer(this.host, this.port);
            }
            catch (IOException v0) {
                throw new ImportException(NLS.bind((String)ResourceHandler.Failed_to_connect_to_the_s_2_ERROR_, (Object)(String.valueOf(this.host) + ".")));
            }
            this.setPassiveTransferMode(this.fServerInfo.isPasvMode());
            try {
                this.login(this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            }
            catch (IOException v1) {
                throw new ImportException(ResourceHandler.Invalid_user_name_or_passw_EXC_);
            }
        }
        this.setPassiveTransferMode(this.fServerInfo.isPasvMode());
        if (this.fServerInfo.getFirewallData().getUseSocks()) {
            this.fUseSocks = true;
            this.fSocksHostName = this.fServerInfo.getFirewallData().getSocksHostName();
            this.fSocksPort = this.fServerInfo.getFirewallData().getSocksPort();
            this.setPassiveTransferMode(true);
            try {
                this.openServer(this.host, this.port);
            }
            catch (Exception v2) {
                throw new ImportException(ResourceHandler.connection_to_socks_failed_EXC_);
            }
            try {
                this.login(this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            }
            catch (Exception v3) {
                throw new ImportException(ResourceHandler.Invalid_user_name_or_passw_EXC_);
            }
        }
        try {
            firewallData = this.fServerInfo.getFirewallData();
            hostname = firewallData.getHostname();
            firewallPort = firewallData.getPort();
            this.openServer(hostname, firewallPort);
            this.serverSocket.setSoTimeout(this.fServerSocketTimeout);
            type = firewallData.getType();
            if (type == 1) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall(this.host, this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            } else if (type == 3) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall2(this.host, this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            } else if (type == 2) {
                this.loginPastFirewall2(this.host, this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            } else if (type == 4) {
                this.login(firewallData.getUserID(), firewallData.getPassword());
                this.loginPastFirewall3(this.host, this.fServerInfo.getUserName(), this.fServerInfo.getPassword());
            }
        }
        catch (Exception v4) {
            throw new ImportException(ResourceHandler.connection_to_proxy_failed_EXC_);
        }
        if (this.getHomeDirectoryAfterLogin) {
            try {
                this.fHomeDirectory = this.pwd();
                this.fHomeDirectory = this.fHomeDirectory.replace('\\', '/');
                if (this.fHomeDirectory.endsWith("/")) ** GOTO lbl63
                this.fHomeDirectory = String.valueOf(this.fHomeDirectory) + "/";
            }
            catch (IOException v5) {
                throw new ImportException(ResourceHandler.Failed_to_get_current_dire_EXC_);
            }
        } else {
            this.fHomeDirectory = "/";
        }
lbl63:
        // 3 sources

        try {
            this.cd(this.fAS400Fix);
        }
        catch (IOException v6) {}
    }

    protected String getProgressReport(long totalWorked) {
        String report;
        long percentage = 100L;
        if (this.currentFileSize != 0L) {
            percentage = totalWorked * 100L / this.currentFileSize;
        }
        if (percentage < 0L) {
            percentage = 0L;
        }
        if (percentage > 100L) {
            percentage = 100L;
        }
        if ((report = "(" + new Long(percentage).toString() + "%) " + this.host).endsWith("/")) {
            report = report.substring(0, report.length() - 1);
        }
        if (this.currentFile.startsWith("/")) {
            this.currentFile = this.currentFile.substring(1);
        }
        report = String.valueOf(report) + "/" + this.currentFile;
        return report;
    }
}

