/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.ftp;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.ConnectionManager;
import com.ibm.iwt.crawler.common.URLFilter;
import com.ibm.iwt.crawler.common.Worker;
import com.ibm.iwt.crawler.ftp.FTPBodyListener;
import com.ibm.iwt.crawler.ftp.FTPCrawlerConnectionFactory;
import com.ibm.iwt.crawler.ftp.FTPOutputStreamGenerator;
import com.ibm.iwt.crawler.wizards.ftp.FTPBodySaver;
import com.ibm.iwt.crawler.wizards.ftp.FTPCrawlerSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class FTPCrawler
extends ConnectionManager {
    protected long timeLimit;
    private static String fErrorString;
    private FTPBodyListener fBodyListener;

    public FTPCrawler(ConnectionFactory connectionFactory, int numberOfWorkers, long timeLimit) {
        super(connectionFactory, numberOfWorkers);
        this.timeLimit = timeLimit;
    }

    public static String getErrorString() {
        return fErrorString;
    }

    public static void setErrorString(String newErrorString) {
        fErrorString = newErrorString;
    }

    public static String startCrawling(FTPCrawlerSession crawlerSession, FTPBodyListener saveListner, FTPOutputStreamGenerator ofsGenerator, IProgressMonitor monitor) {
        try {
            fErrorString = null;
            URL url = new URL(crawlerSession.getSeedUrl());
            ResourceElement seed = new ResourceElement(url, -1);
            seed.setDirectory(true);
            FTPCrawlerConnectionFactory connectionFactory = new FTPCrawlerConnectionFactory(seed, crawlerSession);
            connectionFactory.setProgressMonitor(monitor);
            URLFilter filter = new URLFilter(url, crawlerSession.getDepth(), false);
            Iterator iter = crawlerSession.getExcludedFolders();
            while (iter.hasNext()) {
                filter.addExcludedFolder((String)iter.next());
            }
            connectionFactory.setURLFilter(filter);
            saveListner.setConnectionFactory(connectionFactory);
            connectionFactory.addBodyListener(saveListner);
            connectionFactory.setOfsGenerator(ofsGenerator);
            FTPCrawler crawler = new FTPCrawler(connectionFactory, 1, 15000L);
            crawler.setProgressMonitor(monitor);
            crawler.setFtpBodyListener(saveListner);
            crawler.run();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fErrorString;
    }

    @Override
    public void finishWorkerJobs(Worker worker) {
        if (this.fBodyListener != null && this.fBodyListener instanceof FTPBodySaver) {
            ((FTPBodySaver)this.fBodyListener).writeOutputFile();
        }
    }

    public void setFtpBodyListener(FTPBodyListener listener) {
        this.fBodyListener = listener;
    }
}

