/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common.links;

import com.ibm.iwt.crawler.common.URI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ModelUtil {
    public static IStructuredDocument createNewDocument(String contents) {
        IStructuredDocument document = null;
        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
        IModelHandler handler = null;
        while (handler == null && !"org.eclipse.core.runtime.text".equals(contentType.getId())) {
            handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType.getId());
            contentType = contentType.getBaseType();
        }
        if (handler != null) {
            document = (IStructuredDocument)handler.getDocumentLoader().createNewStructuredDocument();
            document.set(contents);
        }
        return document;
    }

    public static IStructuredModel getModel(IStructuredDocument document, URIResolver resolver, String baseLocationId) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            throw iae;
        }
        String contentType = ContentTypeIdForJSP.ContentTypeID_JSP;
        IStructuredModel model = null;
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType);
        IModelLoader loader = handler.getModelLoader();
        model = loader.createModel(document, baseLocationId, handler);
        try {
            model.setId(baseLocationId);
            if (model instanceof AbstractStructuredModel) {
                ((AbstractStructuredModel)model).setContentTypeIdentifier(contentType);
            }
            model.setResolver(resolver);
            model.setDirtyState(true);
        }
        catch (ResourceInUse e) {
            e.printStackTrace();
            model = null;
        }
        return model;
    }

    public static IStructuredModel getCSSModel(IStructuredDocument document, URIResolver resolver, String baseLocationId) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            throw iae;
        }
        String contentType = ContentTypeIdForCSS.ContentTypeID_CSS;
        IStructuredModel model = null;
        IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(contentType);
        IModelLoader loader = handler.getModelLoader();
        model = loader.createModel(document, baseLocationId, handler);
        try {
            model.setId(baseLocationId);
            if (model instanceof AbstractStructuredModel) {
                ((AbstractStructuredModel)model).setContentTypeIdentifier(contentType);
            }
            model.setResolver(resolver);
            model.setDirtyState(true);
        }
        catch (ResourceInUse e) {
            e.printStackTrace();
            model = null;
        }
        return model;
    }

    public static IDOMModel getVirtualDomModel(String contents, IFile virtualFile) {
        try {
            IStructuredDocument document = ModelUtil.createNewDocument(contents);
            IDOMModel model = (IDOMModel)ModelUtil.getModel(document, ModelUtil.createResolver(virtualFile.getProject(), virtualFile.getFullPath()), virtualFile.getFullPath().toString());
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URIResolver createResolver(IProject project, IPath docPath) {
        URIResolver resolver = (URIResolver)project.getAdapter(URIResolver.class);
        if (resolver == null) {
            resolver = new ProjectResolver(project);
        }
        resolver.setFileBaseLocation(docPath.toString());
        return resolver;
    }

    /*
     * Unable to fully structure code
     */
    public static URL getAbsoluteURL(String sourceLocation, String raw) {
        block15: {
            url = null;
            try {
                url = new URL(raw);
                break block15;
            }
            catch (MalformedURLException v0) {
                sourceLocation2 = sourceLocation;
                if (raw.length() == 0) {
                    return null;
                }
                if (raw.indexOf("://") != -1) {
                    return null;
                }
                if (raw.startsWith("/")) {
                    try {
                        srcURL = new URL(sourceLocation2);
                        prefix = sourceLocation2.substring(0, sourceLocation2.length() - srcURL.getFile().length());
                        if (!prefix.endsWith("/")) {
                            prefix = prefix.substring(0, prefix.length());
                        }
                        url = new URL(String.valueOf(prefix) + raw);
                    }
                    catch (MalformedURLException v1) {}
                    break block15;
                }
                try {
                    sLoc = new URI(sourceLocation2);
                    rLoc = new URI(raw);
                }
                catch (Exception v2) {
                    return null;
                }
                if (!sLoc.hasTrailingSeparator()) {
                    sLoc = (URI)sLoc.removeLastPathSegments(1);
                    sLoc = (URI)sLoc.addTrailingSeparator();
                }
                ** while (!rLoc.toString().equals((Object)"") && rLoc.pathSegment((int)0) != null && rLoc.pathSegment((int)0).equals((Object)".."))
            }
lbl-1000:
            // 1 sources

            {
                sLoc = (URI)sLoc.removeLastPathSegments(1);
                rLoc = (URI)rLoc.removeFirstPathSegments(1);
                continue;
            }
lbl34:
            // 2 sources

            while (!rLoc.toString().equals("") && rLoc.pathSegment(0) != null && rLoc.pathSegment(0).equals(".")) {
                rLoc = (URI)rLoc.removeFirstPathSegments(1);
            }
            try {
                url = new URL(String.valueOf(sLoc.toString()) + rLoc.toString());
            }
            catch (MalformedURLException v3) {}
        }
        return url;
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            ((OutputStream)os).write(buffer, 0, len);
        }
        String result = ((Object)os).toString();
        in.close();
        ((OutputStream)os).close();
        return result;
    }

    public static String getLinkWithoutQueryFragment(String originalLink) {
        int poundIndex;
        if (originalLink == null) {
            originalLink = "";
        }
        String raw = originalLink = originalLink.trim();
        int extraIndex = originalLink.indexOf(63);
        if (extraIndex != -1) {
            originalLink = originalLink.substring(0, extraIndex);
        }
        raw = (poundIndex = originalLink.lastIndexOf(35)) != -1 ? originalLink.substring(0, poundIndex) : originalLink;
        return raw;
    }
}

