/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.etools.ftp.core.internal.ResourceElement;
import com.ibm.iwt.crawler.common.IURI;
import com.ibm.iwt.crawler.common.IURLFilter;
import com.ibm.iwt.crawler.common.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class URLFilter
implements IURLFilter {
    private Hashtable siteHostnames = new Hashtable();
    private Vector siteDomains = new Vector();
    private Vector excludedDomains = new Vector();
    private Hashtable includedUrls = new Hashtable();
    private Hashtable excludedUrls = new Hashtable();
    private Hashtable fExcludedFolders = new Hashtable();
    private int fDepth = -1;
    private IURI fURIPrefix = null;
    private static final Boolean dummy = new Boolean(true);

    public URLFilter() {
    }

    public URLFilter(URL url, int depth, boolean checkForBackLinks) {
        this();
        this.siteHostnames.put(url.getHost(), dummy);
        this.fDepth = depth;
        this.fURIPrefix = null;
        if (checkForBackLinks) {
            try {
                this.fURIPrefix = this.getURIFolder(url);
            }
            catch (Exception exception) {}
        }
    }

    public void addExcludedDomain(String domain) {
        this.excludedDomains.addElement(domain);
    }

    @Override
    public void addExcludedFolder(String folder) {
        this.fExcludedFolders.put(folder, folder);
    }

    public void addExcludedUrl(URL url) {
        this.excludedUrls.put(url, dummy);
    }

    public void addIncludedUrl(URL url) {
        this.includedUrls.put(url, dummy);
    }

    public void addSiteDomain(String domain) {
        this.siteDomains.addElement(domain);
    }

    @Override
    public void addSiteHostname(String hostname) {
        this.siteHostnames.put(hostname, dummy);
    }

    IURI getURIFolder(URL url) {
        IURI uri = null;
        try {
            uri = new URI(url.toExternalForm().toLowerCase());
            if (uri.getFileExtension() != null) {
                uri = uri.removeLastPathSegments(1);
            }
            uri = uri.addTrailingSeparator();
        }
        catch (Exception exception) {}
        return uri;
    }

    @Override
    public boolean isABackLink(URL url) {
        boolean bRet = true;
        if (this.fURIPrefix == null) {
            return false;
        }
        IURI newUri = this.getURIFolder(url);
        if (newUri != null) {
            if (!newUri.getHost().equalsIgnoreCase(this.fURIPrefix.getHost()) || newUri.getPort() != this.fURIPrefix.getPort()) {
                return false;
            }
            bRet = !this.fURIPrefix.isPrefixOf(newUri);
        }
        return bRet;
    }

    @Override
    public boolean isAllowedDepth(int depth) {
        return this.fDepth == -1 || depth == -1 || depth <= this.fDepth;
    }

    boolean isAnExcludedFolder(String folder) {
        boolean excluded = false;
        Enumeration enm = this.fExcludedFolders.keys();
        while (enm.hasMoreElements()) {
            String eFolder = (String)enm.nextElement();
            if (!folder.startsWith(eFolder)) continue;
            excluded = true;
            break;
        }
        return excluded;
    }

    @Override
    public boolean isAnExcludedUrl(URL url) {
        String hostname = url.getHost();
        return this.excludedUrls.containsKey(url) || this.isDomainExcluded(hostname);
    }

    @Override
    public boolean isAnIncludedUrl(URL url) {
        return this.includedUrls.containsKey(url);
    }

    private boolean isDomainExcluded(String hostname) {
        Enumeration e = this.excludedDomains.elements();
        while (e.hasMoreElements()) {
            String domain = (String)e.nextElement();
            if (!hostname.endsWith(domain)) continue;
            return true;
        }
        return false;
    }

    private boolean isInSiteDomain(String hostname) {
        Enumeration e = this.siteDomains.elements();
        while (e.hasMoreElements()) {
            String domain = (String)e.nextElement();
            if (!hostname.endsWith(domain)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInSiteHosts(URL url) {
        String hostname = url.getHost();
        return this.siteHostnames.containsKey(hostname) || this.isInSiteDomain(hostname);
    }

    @Override
    public boolean shouldCrawl(ResourceElement resource) {
        URL url = resource.getUrl();
        String hostname = url.getHost();
        String fileName = url.getFile();
        if (this.fDepth != -1 && resource.getDepth() != -1 && resource.getDepth() > this.fDepth) {
            return false;
        }
        if (this.fURIPrefix != null && this.isABackLink(url)) {
            return false;
        }
        if (this.includedUrls.containsKey(url)) {
            return true;
        }
        if (this.excludedUrls.containsKey(url) || this.isDomainExcluded(hostname)) {
            return false;
        }
        if (this.isAnExcludedFolder(fileName)) {
            return false;
        }
        return this.siteHostnames.containsKey(hostname) || this.isInSiteDomain(hostname);
    }
}

