/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;

public class CrawlerSession {
    public static final String DEFAULT_HOME_PAGE = "default.htm";
    public static final int LINK_STYLE_SELF = 0;
    public static final int LINK_STYLE_DOC_ROOT = 1;
    private String fSeedUrl;
    private int fThreadCount = 1;
    private long fGlobalTimeout = 15000L;
    private IContainer fContainer = null;
    private int fDepth;
    private boolean fPromptWhenOverwritingFile = true;
    private boolean fFixLinks;
    private int fLinkStyle;
    private boolean fBuildProject;
    private boolean fCreateCorrespondingContainerStructure = false;
    private Hashtable fSpecialUrlPrefixes;
    private int fNoOfFilesImported = 0;
    private int fConnectionTimeout;

    public CrawlerSession() {
        this.loadSpecialUrlPrefixes();
    }

    public int getConnectionTimeout() {
        return this.fConnectionTimeout;
    }

    public int getDepth() {
        return this.fDepth;
    }

    long getGlobalTimeout() {
        return this.fGlobalTimeout;
    }

    public int getLinkStyle() {
        return this.fLinkStyle;
    }

    public IContainer getLocalFolder() {
        return this.fContainer;
    }

    public int getNoOfFilesImported() {
        return this.fNoOfFilesImported;
    }

    public String getSeedUrl() {
        return this.fSeedUrl;
    }

    int getThreadCount() {
        return this.fThreadCount;
    }

    public boolean isAUrlWithSpecialPreix(String url1) {
        boolean bRet = false;
        URL url = null;
        try {
            url = new URL(url1);
        }
        catch (MalformedURLException malformedURLException) {}
        if (url == null || this.fSpecialUrlPrefixes == null) {
            return bRet;
        }
        String file = url.getFile();
        Enumeration enm = this.fSpecialUrlPrefixes.keys();
        while (enm.hasMoreElements()) {
            String specialPrefix = (String)enm.nextElement();
            if (file.indexOf(specialPrefix) != 0) continue;
            return true;
        }
        return bRet;
    }

    public boolean isBuildProject() {
        return this.fBuildProject;
    }

    public boolean isCreateCorrespondingContainerStructure() {
        return this.fCreateCorrespondingContainerStructure;
    }

    public boolean isFixLinks() {
        return this.fFixLinks;
    }

    public boolean isPromptWhenOverwritingFile() {
        return this.fPromptWhenOverwritingFile;
    }

    private void loadSpecialUrlPrefixes() {
        this.fSpecialUrlPrefixes = new Hashtable();
        this.fSpecialUrlPrefixes.put("/servlet", "/servlet");
    }

    public int oneMoreFileImported() {
        return ++this.fNoOfFilesImported;
    }

    public void setBuildProject(boolean newBuildProject) {
        this.fBuildProject = newBuildProject;
    }

    public void setConnectionTimeout(int newConnectionTimeout) {
        this.fConnectionTimeout = newConnectionTimeout;
    }

    public void setCreateCorrespondingContainerStructure(boolean newCreateCorrespondingContainerStructure) {
        this.fCreateCorrespondingContainerStructure = newCreateCorrespondingContainerStructure;
    }

    public void setDepth(int newDepth) {
        this.fDepth = newDepth;
    }

    public void setFixLinks(boolean newFixLinks) {
        this.fFixLinks = newFixLinks;
    }

    void setGlobalTimeout(long globalTimeout) {
        this.fGlobalTimeout = globalTimeout;
    }

    public void setLinkStyle(int newLinkStyle) {
        this.fLinkStyle = newLinkStyle;
    }

    public void setLocalFolder(IContainer basePath) {
        this.fContainer = basePath;
    }

    public void setPromptWhenOverwritingFile(boolean newPromptWhenOverwritingFile) {
        this.fPromptWhenOverwritingFile = newPromptWhenOverwritingFile;
    }

    public void setSeedUrl(String newSeedUrl) {
        this.fSeedUrl = newSeedUrl;
    }

    void setSpecialUrlPrefixes(Hashtable newSpecialUrlPrefixes) {
        this.fSpecialUrlPrefixes = newSpecialUrlPrefixes;
    }

    void setThreadCount(int threadCount) {
        this.fThreadCount = threadCount;
    }
}

