/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iwt.crawler.common;

import com.ibm.etools.webtools.filetransfer.wizards.nls.ResourceHandler;
import com.ibm.iwt.crawler.common.Connection;
import com.ibm.iwt.crawler.common.ConnectionEvent;
import com.ibm.iwt.crawler.common.ConnectionFactory;
import com.ibm.iwt.crawler.common.ConnectionListener;
import com.ibm.iwt.crawler.common.CrawlerSession;
import com.ibm.iwt.crawler.common.DebugInfo;
import com.ibm.iwt.crawler.common.Worker;
import com.ibm.iwt.crawler.common.WorkerPool;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ConnectionManager
implements ConnectionListener,
Runnable {
    private ConnectionFactory connectionFactory;
    private WorkerPool workers;
    private volatile boolean cont = true;
    private volatile int numberOfLiveConnections = 0;
    private IProgressMonitor fMonitor = null;
    private CrawlerSession fCrawlerSession = null;

    public ConnectionManager(ConnectionFactory connectionFactory, int numberOfWorkers) {
        this.connectionFactory = connectionFactory;
        this.workers = new WorkerPool(numberOfWorkers);
    }

    @Override
    public synchronized void connectionStateChanged(ConnectionEvent event) {
        switch (event.getState()) {
            case 1: {
                ++this.numberOfLiveConnections;
                break;
            }
            case 2: {
                --this.numberOfLiveConnections;
                this.notify();
            }
        }
    }

    public synchronized void finish() {
        this.cont = false;
    }

    protected synchronized Connection getNewConnection() throws InterruptedException {
        Connection connection = null;
        while ((connection = this.connectionFactory.getNewConnection()) == null) {
            if (!this.hasLiveConnections()) break;
            this.wait();
        }
        return connection;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    public CrawlerSession getCrawlerSession() {
        return this.fCrawlerSession;
    }

    public synchronized boolean hasLiveConnections() {
        return this.numberOfLiveConnections != 0;
    }

    @Override
    public void run() {
        while (this.cont) {
            try {
                Connection connection;
                Worker worker = this.workers.grabWorker();
                this.finishWorkerJobs(worker);
                this.fMonitor.worked(1);
                if (this.fMonitor.isCanceled() || (connection = this.getNewConnection()) == null || this.fMonitor.isCanceled()) break;
                connection.addConnectionListener(this);
                connection.setState(1);
                worker.assignConnection(connection);
            }
            catch (InterruptedException interruptedException) {
                DebugInfo dbg = new DebugInfo(this, "run()");
                dbg.traceOut(ResourceHandler.Interrupted__EXC_, 5);
                break;
            }
        }
        this.workers.finish();
    }

    public void setProgressMonitor(IProgressMonitor newProgressListener) {
        this.fMonitor = newProgressListener;
    }

    public void setCrawlerSession(CrawlerSession cs) {
        this.fCrawlerSession = cs;
    }

    public abstract void finishWorkerJobs(Worker var1);
}

