/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.examples.internal;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.webtools.examples.internal.nls.Messages;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.RuntimeUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class WAS6TargetOperation
extends WTPOperation {
    private static final String RUNTIME_LOCATION_PROPERTY = "location";
    private IProject project;
    private final String[] targets;
    private String location = null;

    public WAS6TargetOperation(String[] targets) {
        this.targets = targets;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Set runtimes = RuntimeManager.getRuntimes();
        boolean found = false;
        Iterator runtimeIter = runtimes.iterator();
        while (!found && runtimeIter.hasNext()) {
            IRuntime runtime = (IRuntime)runtimeIter.next();
            if (!RuntimeUtil.isTargetedAtWASV60((IRuntime)runtime)) continue;
            found = true;
            this.location = this.findRuntimeLocation(runtime);
            int j = 0;
            while (j < this.targets.length) {
                IProject targetProject = this.getProject(this.targets[j]);
                targetProject.open(null);
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)targetProject);
                    facetedProject.setRuntime(runtime, monitor);
                }
                catch (CoreException coreException) {
                    found = false;
                }
                ++j;
            }
        }
        if (!found) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell shell = new Shell(display);
            MessageDialog.openWarning((Shell)shell, (String)Messages.WAS6TargetOperation_Target_Warning, (String)Messages.WAS6TargetOperation_Target_Server_not_found);
        }
    }

    private String findRuntimeLocation(IRuntime runtime) {
        List runtimeComponents = runtime.getRuntimeComponents();
        String location = null;
        int i = 0;
        while (location == null && i < runtimeComponents.size()) {
            IRuntimeComponent current = (IRuntimeComponent)runtimeComponents.get(i);
            location = current.getProperty(RUNTIME_LOCATION_PROPERTY);
            ++i;
        }
        return location;
    }

    private IProject getProject(String prjName) {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        this.project = wsr.getProject(prjName);
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }
}

