/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.examples.internal;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.jsf.support.wizard.JsfWizardOperationBase;
import com.ibm.etools.jsf.support.wizard.WizardUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public class FacesExamplePostOperation
extends WTPOperation {
    private IProject project;
    private String JSF_PROJECT_NAME = "JSFandSDO";
    private String EAR_PROJECT_NAME = "JSFandSDOEAR";
    private static final String DERBY_DRIVER_PLUGIN = "org.apache.derby.core";
    private static final String SDO_RUNTIME_PLUGIN = "com.ibm.etools.sdo.runtime";
    private final String SDO_DOMINO_PLUGIN = "com.ibm.etools.webtools.sdo.domino";
    private final String CON_SETUP_FILE = ".wdo-connections";
    private final String DATABASE_LOCATION_STRING_1 = "WebContent";
    private final String DATABASE_LOCATION_STRING_2 = "DerbySampleData";
    private final String DATABASE_LOCATION_STRING_3 = "database";
    private final String RESOURSES_XML_EXTENTION = "/EarContent/META-INF/ibmconfig/cells/defaultCell/applications/defaultApp/deployments/defaultApp/resources.xml";
    private IPath derbyJarPath;
    private final String LIB_FOLDER_PATH = "WebContent/WEB-INF/lib";
    private final String WEB_CONTENT_FOLDER = "WebContent";
    private final String DERBY_FILE_NAME = "derby.jar";
    private final String WDO_CONNECTIONS_FILE = ".wdo-connections";
    private final String JDBC_MEDIATOR_JAR_FILE = "jdbcmediator.jar";
    private final String COM_IBM_ES_EMF_JAR_FILE = "com.ibm.ws.emf_2.0.0.jar";
    private final String JDBC_MEDIATOR_SAMPLE_JAR_FILE = "jdbcmediator_sample.jar";
    private final String DB_README_FILE = "database_readme.html";
    private static final String NEW_JSF_BASE = "jsf.base";
    private static final String NEW_JSF_RI = "jsf.ri";
    private static final String NEW_JSF_EXTENDED = "jsf.extended";
    private static final String NEW_JSF_RTE = "jsf.rte";
    private static final String NEW_JSF_ODC = "jsf.odc";
    private Bundle pluginBundle = Platform.getBundle((String)"org.apache.derby.core");
    private boolean wasImport = false;
    private final String RADCE_STRING = "Rational Application Developer Community Edition";

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                block8: {
                    FacesExamplePostOperation.this.setProject(FacesExamplePostOperation.this.JSF_PROJECT_NAME);
                    FacesExamplePostOperation.this.getProject().open(null);
                    FacesExamplePostOperation.this.wasImport = FacesExamplePostOperation.this.isWasImport();
                    try {
                        if (FacesExamplePostOperation.this.pluginBundle != null) {
                            try {
                                FacesExamplePostOperation.this.derbyJarPath = new Path(FileLocator.resolve((URL)FacesExamplePostOperation.this.pluginBundle.getEntry("/")).getPath()).removeTrailingSeparator();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                FacesExamplePostOperation.this.performWizardOperation(FacesExamplePostOperation.NEW_JSF_BASE, FacesExamplePostOperation.this.project);
                                FacesExamplePostOperation.this.performWizardOperation(FacesExamplePostOperation.NEW_JSF_EXTENDED, FacesExamplePostOperation.this.project);
                                FacesExamplePostOperation.this.performWizardOperation(FacesExamplePostOperation.NEW_JSF_ODC, FacesExamplePostOperation.this.project);
                                FacesExamplePostOperation.this.performWizardOperation(FacesExamplePostOperation.NEW_JSF_RI, FacesExamplePostOperation.this.project);
                                FacesExamplePostOperation.this.performWizardOperation(FacesExamplePostOperation.NEW_JSF_RTE, FacesExamplePostOperation.this.project);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            FacesExamplePostOperation.this.copyJars();
                            FacesExamplePostOperation.this.configureWDOConnection();
                            FacesExamplePostOperation.this.configureResources();
                            if (!FacesExamplePostOperation.this.wasImport) {
                                FacesExamplePostOperation.this.deleteDatabaseReadme();
                            }
                            FacesExamplePostOperation.this.addResources();
                            break block8;
                        }
                        final Display display = PlatformUI.getWorkbench().getDisplay();
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = new Shell(display);
                                MessageDialog.openWarning((Shell)shell, (String)"Error:", (String)"Required driver: org.apache.derby.corewas not found");
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        op.run(monitor);
    }

    private boolean isWasImport() {
        boolean ret = false;
        IProduct prod = Platform.getProduct();
        if (prod != null && prod.getName().compareToIgnoreCase("Rational Application Developer Community Edition") == 0) {
            return false;
        }
        if (Platform.getBundle((String)"com.ibm.etools.webtools.sdo.domino") != null) {
            ret = true;
        }
        return ret;
    }

    private void copyJars() {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        IProject resourcesProject = wsr.getProject(this.JSF_PROJECT_NAME);
        Bundle sdoPluginBundle = Platform.getBundle((String)SDO_RUNTIME_PLUGIN);
        if (sdoPluginBundle == null) {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = new Shell(display);
                    MessageDialog.openWarning((Shell)shell, (String)"Error:", (String)"Required plugin com.ibm.etools.sdo.runtime NOT found");
                }
            });
            return;
        }
        IPath prjPath = resourcesProject.getLocation();
        prjPath.append("WebContent/WEB-INF/lib");
        try {
            IPath sourcePath = new Path(FileLocator.resolve((URL)sdoPluginBundle.getEntry("/")).getPath()).removeTrailingSeparator();
            sourcePath = sourcePath.append("lib");
            IPath EMFsourcePath = sourcePath.append("com.ibm.ws.emf_2.0.0.jar");
            File EMFsourceFile = new File(EMFsourcePath.toOSString());
            IFile targetFile = resourcesProject.getFile(String.valueOf("WebContent/WEB-INF/lib") + "/" + "com.ibm.ws.emf_2.0.0.jar");
            this.copyFile(EMFsourceFile, targetFile);
            IPath JDBCsourcePath = sourcePath.append("jdbcmediator.jar");
            File JDBCsourceFile = new File(JDBCsourcePath.toOSString());
            targetFile = resourcesProject.getFile(String.valueOf("WebContent/WEB-INF/lib") + "/" + "jdbcmediator_sample.jar");
            this.copyFile(JDBCsourceFile, targetFile);
            IPath derbyPath = this.derbyJarPath.append("derby.jar");
            File DerbySourceFile = new File(derbyPath.toOSString());
            targetFile = resourcesProject.getFile(String.valueOf("WebContent/WEB-INF/lib") + "/" + "derby.jar");
            this.copyFile(DerbySourceFile, targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyFile(File srcFile, IFile copyFile) {
        try {
            FileInputStream sourceStream = new FileInputStream(srcFile);
            if (!copyFile.exists()) {
                copyFile.create((InputStream)sourceStream, true, null);
            } else {
                copyFile.setContents((InputStream)sourceStream, true, false, null);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void setProject(String prjName) {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        this.project = wsr.getProject(prjName);
    }

    public IProject getProject() {
        return this.project;
    }

    private int findIndexOfChar(char targetChar, String str, int starting_index) {
        int ret = -1;
        int i = starting_index;
        while (i >= 0) {
            if (str.charAt(i) == targetChar) {
                return i;
            }
            --i;
        }
        return ret;
    }

    public void configureResources() {
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        IProject resourcesProject = wsr.getProject(this.EAR_PROJECT_NAME);
        String resourcesPath = String.valueOf(resourcesProject.getLocation().toString()) + "/EarContent/META-INF/ibmconfig/cells/defaultCell/applications/defaultApp/deployments/defaultApp/resources.xml";
        IPath wdoFile = resourcesProject.getLocation().append("/EarContent/META-INF/ibmconfig/cells/defaultCell/applications/defaultApp/deployments/defaultApp/resources.xml");
        File conFile = wdoFile.toFile();
        try {
            BufferedReader bReader = new BufferedReader(new InputStreamReader(new FileInputStream(resourcesPath)));
            LinkedList<String> list = new LinkedList<String>();
            String strLine = bReader.readLine();
            while (strLine != null) {
                StringBuffer buffer;
                int index;
                if (strLine.indexOf("WebContent") > -1 && strLine.indexOf("DerbySampleData") > -1 && strLine.indexOf("database") > -1) {
                    index = this.findIndexOfChar('\"', strLine, strLine.indexOf("WebContent"));
                    IProject project = wsr.getProject(this.JSF_PROJECT_NAME);
                    IPath prjPath = project.getLocation();
                    buffer = new StringBuffer(strLine);
                    buffer = buffer.replace(index + 1, strLine.indexOf("WebContent") - 1, prjPath.toOSString());
                    strLine = buffer.toString();
                }
                if (strLine.indexOf("derby.jar") > -1) {
                    index = this.findIndexOfChar('>', strLine, strLine.indexOf("derby.jar"));
                    buffer = new StringBuffer(strLine);
                    buffer = buffer.replace(index + 1, strLine.indexOf("derby.jar") - 1, this.derbyJarPath.toOSString());
                    strLine = buffer.toString();
                }
                list.add(strLine);
                strLine = bReader.readLine();
            }
            bReader.close();
            conFile.delete();
            conFile = new File(resourcesProject.getLocation().append("/EarContent/META-INF/ibmconfig/cells/defaultCell/applications/defaultApp/deployments/defaultApp/resources.xml").toString());
            PrintWriter pWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(conFile)));
            int x = 0;
            while (x < list.size()) {
                pWriter.println((String)list.get(x));
                pWriter.flush();
                ++x;
            }
            pWriter.close();
            resourcesProject.refreshLocal(2, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void configureWDOConnection() {
        IPath prjPath = this.project.getLocation();
        IPath wdoFile = this.project.getLocation().append(".wdo-connections");
        File conFile = wdoFile.toFile();
        try {
            BufferedReader bReader = new BufferedReader(new InputStreamReader(new FileInputStream(conFile)));
            LinkedList<String> list = new LinkedList<String>();
            String strLine = bReader.readLine();
            while (strLine != null) {
                StringBuffer buffer;
                int index;
                String prjVar = "%database-location%";
                if (strLine.indexOf("WebContent") > -1 && strLine.indexOf("DerbySampleData") > -1 && strLine.indexOf("database") > -1) {
                    index = this.findIndexOfChar('\"', strLine, strLine.indexOf("WebContent"));
                    buffer = new StringBuffer(strLine);
                    buffer = buffer.replace(index + 1, strLine.indexOf("WebContent") - 1, "jdbc:derby:" + prjPath.toOSString());
                    strLine = buffer.toString();
                }
                if (strLine.indexOf(prjVar) > -1) {
                    buffer = new StringBuffer(strLine);
                    int prjIndex = buffer.toString().indexOf(prjVar);
                    buffer = buffer.replace(prjIndex, prjIndex + prjVar.length(), prjPath.toOSString());
                    strLine = buffer.toString();
                } else if (strLine.indexOf("derby.jar") > -1) {
                    index = this.findIndexOfChar('\"', strLine, strLine.indexOf("derby.jar"));
                    buffer = new StringBuffer(strLine);
                    buffer = buffer.replace(index + 1, strLine.indexOf("derby.jar") - 1, this.derbyJarPath.toOSString());
                    strLine = buffer.toString();
                }
                list.add(strLine);
                strLine = bReader.readLine();
            }
            bReader.close();
            conFile.delete();
            conFile = new File(String.valueOf(this.project.getLocation().addTrailingSeparator().toOSString()) + ".wdo-connections");
            PrintWriter pWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(conFile)));
            int x = 0;
            while (x < list.size()) {
                pWriter.println((String)list.get(x));
                pWriter.flush();
                ++x;
            }
            pWriter.close();
            this.project.refreshLocal(2, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void addResources() throws IOException {
        WTPOperation operation = WizardUtil.buildWizardOperation((String)"http://www.ibm.com/jsf/html_extended", (IProject)this.getProject());
        try {
            operation.run(null);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
    }

    private void performWizardOperation(String wizardId, IProject thisProject) {
        JsfWizardOperationBase operation = WizardUtil.getWizardOperation((String)wizardId, (IProject)thisProject);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable((WTPOperation)operation){
            private final /* synthetic */ WTPOperation val$operation;
            {
                this.val$operation = wTPOperation;
            }

            @Override
            public void run() {
                try {
                    Shell shell = new Shell(display);
                    ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(shell);
                    monitorDialog.create();
                    this.val$operation.run(monitorDialog.getProgressMonitor());
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
            }
        });
    }

    private void deleteDatabaseReadme() {
        IPath wdoFile = this.project.getLocation().append(String.valueOf("WebContent") + "/" + "database_readme.html");
        File conFile = wdoFile.toFile();
        conFile.delete();
    }
}

