/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.ui.internal;

import com.ibm.etools.sdo.ui.internal.Validator;
import com.ibm.etools.sdo.ui.internal.WdoTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WdoTagImpl
extends WdoTag {
    Node tagNode = null;
    private NamedNodeMap attributes = null;
    private static final String EXPR_SEPARATOR = "/";
    private ArrayList children = null;

    public WdoTagImpl(Node jsfTag) {
        this.tagNode = jsfTag;
    }

    @Override
    public void addChild(int index, WdoTag component) {
        this.checkComponentId(component.getComponentId());
        this.getChildList().add(index, component);
        if (component instanceof WdoTagImpl) {
            ((WdoTagImpl)component).setParent(this);
        }
    }

    @Override
    public void addChild(WdoTag component) {
        this.checkComponentId(component.getComponentId());
        this.getChildList().add(component);
        if (component instanceof WdoTagImpl) {
            ((WdoTagImpl)component).setParent(this);
        }
    }

    @Override
    public void addValidator(Validator validator) {
    }

    private void checkComponentId(String componentId) {
        if (componentId == null) {
            throw new NullPointerException();
        }
        if (this.isChildrenAllocated()) {
            for (WdoTag kid : this.children) {
                if (!componentId.equals(kid.getComponentId())) continue;
                throw new IllegalArgumentException(componentId);
            }
        }
    }

    @Override
    public void clearChildren() {
        if (!this.isChildrenAllocated()) {
            return;
        }
        this.children.clear();
    }

    @Override
    public void clearValidators() {
    }

    @Override
    public boolean containsChild(WdoTag component) {
        return component.getParent() == this;
    }

    @Override
    public Node getAsNode() {
        return this.tagNode;
    }

    @Override
    public String getAttribute(String name) {
        Node attribute;
        if (name == null) {
            throw new NullPointerException("getAttribute");
        }
        if ("compoundId".equals(name)) {
            return this.getCompoundId();
        }
        NamedNodeMap attributes = this.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(name)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    @Override
    public Iterator getAttributeNames() {
        this.isAttributesAllocated();
        return Collections.EMPTY_LIST.iterator();
    }

    private NamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.tagNode.hasAttributes() ? this.tagNode.getAttributes() : null;
        }
        return this.attributes;
    }

    @Override
    public String getBody() {
        return this.tagNode.getNodeValue();
    }

    @Override
    public WdoTag getChild(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    private List getChildList() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    @Override
    public NodeList getChildren() {
        return this.tagNode.getChildNodes();
    }

    @Override
    public String getComponentId() {
        return this.getAttribute("componentId");
    }

    @Override
    public String getCompoundId() {
        WdoTag parent = this.getParent();
        if (parent == null) {
            return EXPR_SEPARATOR;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getComponentId());
        while (parent != null) {
            list.add(0, parent.getComponentId());
            parent = parent.getParent();
        }
        StringBuffer sb = new StringBuffer();
        int n = list.size();
        int i = 0;
        while (i < n) {
            if (i != 1) {
                sb.append(EXPR_SEPARATOR);
            }
            if (i > 0) {
                sb.append((String)list.get(i));
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public WdoTag getParent() {
        return new WdoTagImpl(this.tagNode.getParentNode());
    }

    @Override
    public String getRenderer() {
        return WdoTag.getRenderer(this.tagNode);
    }

    @Override
    public String getTagName() {
        return WdoTag.getTagName(this.tagNode);
    }

    @Override
    public Iterator getValidators() {
        return null;
    }

    private boolean isAttributesAllocated() {
        return this.getAttributes() != null;
    }

    private boolean isChildrenAllocated() {
        return this.children != null;
    }

    @Override
    public void removeChild(int index) {
        WdoTag kid = this.getChild(index);
        this.getChildList().remove(index);
        if (kid instanceof WdoTagImpl) {
            ((WdoTagImpl)kid).setParent(null);
        }
    }

    @Override
    public void removeChild(WdoTag component) {
        if (component == null) {
            throw new NullPointerException("removeChild");
        }
        if (this.containsChild(component)) {
            this.getChildList().remove(component);
            if (component instanceof WdoTagImpl) {
                ((WdoTagImpl)component).setParent(null);
            }
        } else {
            throw new IllegalArgumentException("removeChild");
        }
    }

    @Override
    public void removeValidator(Validator validator) {
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("setAttribute");
        }
        if ("componentType".equals(name) || "compoundId".equals(name) || "rendersChildren".equals(name)) {
            throw new IllegalArgumentException(name);
        }
    }

    @Override
    public void setComponentId(String componentId) {
        if (componentId == null) {
            throw new NullPointerException("setComponentId");
        }
        this.setAttribute("componentId", componentId);
    }

    public void setParent(WdoTag tag) {
    }

    @Override
    public void setText(String text) {
        this.tagNode.setNodeValue(text);
    }
}

