/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.ui.internal.Status;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;

public class WizardPageStatus {
    protected Vector errorList = new Vector();
    protected Vector warningList = new Vector();
    protected Vector informationList = new Vector();

    public void addError(IStatus status) {
        this.errorList.add(status);
    }

    public void addErrorMessage(String message) {
        Status status = new Status();
        status.setError(message);
        this.errorList.add(status);
    }

    public void addInfo(IStatus status) {
        this.informationList.add(status);
    }

    public void addInfoMessage(String message) {
        Status status = new Status();
        status.setInfo(message);
        this.informationList.add(status);
    }

    public void addMessage(int severity, IStatus status) {
        switch (severity) {
            case 0: {
                this.addInfo(status);
                break;
            }
            case 2: {
                this.addWarning(status);
                break;
            }
            case 4: {
                this.addError(status);
                break;
            }
        }
    }

    public void addWarning(IStatus status) {
        this.warningList.add(status);
    }

    public void addWarningMessage(String message) {
        Status status = new Status();
        status.setWarning(message);
        this.warningList.add(status);
    }

    public void clearAll() {
        this.errorList.clear();
        this.informationList.clear();
        this.warningList.clear();
    }

    public IStatus getError() {
        if (!this.errorList.isEmpty()) {
            this.sortList(this.errorList);
            return (IStatus)this.errorList.firstElement();
        }
        return null;
    }

    public Vector getErrorList() {
        this.sortList(this.errorList);
        return this.errorList;
    }

    public Vector getInformationList() {
        this.sortList(this.informationList);
        return this.informationList;
    }

    public IStatus getWarning() {
        if (!this.warningList.isEmpty()) {
            return (IStatus)this.warningList.firstElement();
        }
        return null;
    }

    public Vector getWarningList() {
        this.sortList(this.warningList);
        return this.warningList;
    }

    public boolean isError() {
        return !this.errorList.isEmpty();
    }

    public boolean isWarning() {
        return !this.warningList.isEmpty();
    }

    protected void sortList(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof Status && arg1 instanceof Status) {
                    Status status0 = (Status)((Object)arg0);
                    Status status1 = (Status)((Object)arg1);
                    if (status0.getPriority() == status1.getPriority()) {
                        return 0;
                    }
                    if (status0.getPriority() < status1.getPriority()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }

            @Override
            public boolean equals(Object arg0) {
                return false;
            }
        });
    }
}

