/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionHandler;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCUiUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.SDODeployUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RuntimeUtil;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IRuntime;

public class WebConnectionHandler
implements IConnectionHandler {
    protected boolean deleteDataSource(IProject project, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime, Connection connection) {
        boolean deleted = false;
        if (runtime != null) {
            IRuntime wstRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            try {
                ServerSetup[] serverSetups = SDODeployUtil.getServerSetups(wstRuntime);
                if (serverSetups.length > 0) {
                    deleted = serverSetups[0].deleteDataSource(connection, project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return deleted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean findOtherDataSourceReferences(IProject project, String jndiName, Connection connection) {
        IProject[] earProjects;
        int foundCount = 0;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeUtil.getRuntime(project);
        IProject[] iProjectArray = earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)project);
        int n = earProjects.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                IProject element = iProjectArray[n2];
                EARArtifactEdit earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)element);
                try {
                    if (earEdit == null) break block14;
                    IVirtualReference[] j2eeRefsArray = earEdit.getJ2EEModuleReferences();
                    boolean innerfound = false;
                    int j = 0;
                    while (j < j2eeRefsArray.length && !innerfound) {
                        block16: {
                            WebArtifactEdit webEdit;
                            IVirtualComponent component;
                            IVirtualReference vref = j2eeRefsArray[j];
                            String type = J2EEProjectUtilities.getJ2EEComponentType((IVirtualComponent)vref.getReferencedComponent());
                            if (type != null && type.equals("jst.web") && (component = vref.getReferencedComponent()) != null && (webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component)) != null) {
                                try {
                                    try {
                                        int foundInstances = JDBCUiUtil.findResourceRefJndiCount(webEdit, project, null, jndiName, runtime, connection);
                                        foundCount += foundInstances;
                                    }
                                    catch (Exception exception) {
                                        if (webEdit != null) {
                                            webEdit.dispose();
                                        }
                                        break block16;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (webEdit != null) {
                                        webEdit.dispose();
                                    }
                                    throw throwable;
                                }
                                if (webEdit != null) {
                                    webEdit.dispose();
                                }
                            }
                        }
                        ++j;
                    }
                }
                finally {
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                }
            }
            ++n2;
        }
        return foundCount > 1;
    }

    @Override
    public void handleDelete(IProject project, Connection connection, boolean removeWebDeploymentReferences) {
        String jndiName;
        boolean multipleReferences;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeUtil.getRuntime(project);
        if (connection.getRuntime() instanceof DatasourceConnection && !(multipleReferences = this.findOtherDataSourceReferences(project, jndiName = ((DatasourceConnection)connection.getRuntime()).getJndiName(), connection))) {
            this.deleteDataSource(project, runtime, connection);
        }
        if (removeWebDeploymentReferences) {
            JDBCUiUtil.createDeployMentDescriptorIfNecesary(project);
            WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)component);
            if (webEdit != null) {
                try {
                    try {
                        WebApp app = webEdit.getWebApp();
                        boolean removed = false;
                        EList resourceRefs = app.getResourceRefs();
                        int resourceRefsLength = resourceRefs.size();
                        int i = resourceRefsLength - 1;
                        while (i >= 0) {
                            ResourceRef resourceRef = (ResourceRef)resourceRefs.get(i);
                            boolean existsInSDOConnections = false;
                            List descriptions = JDBCUiUtil.getAllDescriptions(resourceRef);
                            int j = 0;
                            while (j < descriptions.size() && !existsInSDOConnections) {
                                String description = (String)descriptions.get(j);
                                if (JDBCUiUtil.isGeneratedBySDO(description) && JDBCUiUtil.resourceRefMatchesConnection(resourceRef, connection)) {
                                    JDBCUiUtil.removeResourceRef(project, webEdit, connection, runtime);
                                    removed = true;
                                    break;
                                }
                                ++j;
                            }
                            --i;
                        }
                        EList envEntries = app.getEnvironmentProperties();
                        int envEntriesLength = envEntries.size();
                        int i2 = envEntriesLength - 1;
                        while (i2 >= 0) {
                            EnvEntry envEntry = (EnvEntry)envEntries.get(i2);
                            boolean existsInSDOConnections = false;
                            List descriptions = JDBCUiUtil.getAllDescriptions(envEntry);
                            int j = 0;
                            while (j < descriptions.size() && !existsInSDOConnections) {
                                String description = (String)descriptions.get(j);
                                if (JDBCUiUtil.isGeneratedBySDO(description) && envEntry.getName().equals(connection.getId())) {
                                    JDBCUiUtil.removeEnvEntry(webEdit, envEntry.getName());
                                    removed = true;
                                    break;
                                }
                                ++j;
                            }
                            --i2;
                        }
                        if (removed) {
                            webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
                finally {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
        }
    }
}

