/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebAppUtil {
    public static final String FACET_ID_WEB_PROJECT = "jst.web";
    public static final String FACET_ID_EJB_PROJECT = "jst.ejb";
    public static final String FACET_ID_UTILITY_PROJECT = "jst.utility";

    public static ResourceRef findResourceRef(String resourceRefName, IProject project) throws Exception {
        ResourceRef ref = null;
        ResourceRef[] resourceRefs = WebAppUtil.getResourceRefs(project);
        int i = 0;
        while (i < resourceRefs.length) {
            ResourceRef resourceRef = resourceRefs[i];
            if (resourceRef.getName().equals(resourceRefName)) {
                ref = resourceRef;
                break;
            }
            ++i;
        }
        return ref;
    }

    private static IFacetedProject getFacetedProject(IProject project) {
        IFacetedProject fProject = null;
        try {
            fProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return fProject;
    }

    public static ResourceRef[] getResourceRefs(IProject project) {
        List refs;
        block6: {
            refs = Collections.EMPTY_LIST;
            if (WebAppUtil.isWebProject(project)) {
                WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
                try {
                    try {
                        WebApp app = webEdit.getWebApp();
                        refs = app.getResourceRefs();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        webEdit.dispose();
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    webEdit.dispose();
                    throw throwable;
                }
                webEdit.dispose();
            }
        }
        return refs.toArray(new ResourceRef[refs.size()]);
    }

    public static boolean isEJBProject(IProject project) {
        boolean ret = false;
        IFacetedProject facetedProject = WebAppUtil.getFacetedProject(project);
        if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)FACET_ID_EJB_PROJECT))) {
            ret = true;
        }
        return ret;
    }

    public static boolean isUtilityProject(IProject project) {
        boolean ret = false;
        IFacetedProject facetedProject = WebAppUtil.getFacetedProject(project);
        if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)FACET_ID_UTILITY_PROJECT))) {
            ret = true;
        }
        return ret;
    }

    public static boolean isWebProject(IProject project) {
        boolean ret = false;
        IFacetedProject facetedProject = WebAppUtil.getFacetedProject(project);
        if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)FACET_ID_WEB_PROJECT))) {
            ret = true;
        }
        return ret;
    }
}

