/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.ui.internal.ComboDataType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;

public class StringUtil {
    public static boolean belongsTo(String sample, String[] group) {
        if (sample != null && group != null) {
            int i = 0;
            while (i < group.length) {
                if (sample.equals(group[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean belongsToIgnoreCase(String sample, String[] group) {
        if (sample != null && group != null) {
            int i = 0;
            while (i < group.length) {
                if (sample.equalsIgnoreCase(group[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean compare(String value, String value2) {
        if (value == null && value2 == null) {
            return true;
        }
        if (value != null && value2 != null) {
            return value.equals(value2);
        }
        return false;
    }

    public static boolean compare(String[] values, String[] values2) {
        if (values == null && values2 == null) {
            return true;
        }
        if (values != null && values2 != null) {
            if (values.length != values2.length) {
                return false;
            }
            int i = 0;
            while (i < values.length) {
                if (!StringUtil.compare(values[i], values2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean compareIgnoreCase(String value, String value2) {
        if (value == null && value2 == null) {
            return true;
        }
        if (value != null && value2 != null) {
            return value.equalsIgnoreCase(value2);
        }
        return false;
    }

    public static boolean compareIgnoreCase(String[] values, String[] values2) {
        if (values == null && values2 == null) {
            return true;
        }
        if (values != null && values2 != null) {
            if (values.length != values2.length) {
                return false;
            }
            int i = 0;
            while (i < values.length) {
                if (!StringUtil.compareIgnoreCase(values[i], values2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final String convertLineDelimiters(String allText, String lineDelimiterToUse) {
        Document tempDoc = new Document(allText);
        if (lineDelimiterToUse == null) {
            lineDelimiterToUse = System.getProperty("line.separator");
        }
        String newText = new String();
        int lineCount = tempDoc.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            try {
                IRegion lineInfo = tempDoc.getLineInformation(i);
                int lineStartOffset = lineInfo.getOffset();
                int lineLength = lineInfo.getLength();
                int lineEndOffset = lineStartOffset + lineLength;
                newText = String.valueOf(newText) + allText.substring(lineStartOffset, lineEndOffset);
                if (i < lineCount - 1 && tempDoc.getLineDelimiter(i) != null) {
                    newText = String.valueOf(newText) + lineDelimiterToUse;
                }
            }
            catch (BadLocationException badLocationException) {
                return allText;
            }
            ++i;
        }
        return newText;
    }

    public static String createDisplayString(String text) {
        return ComboDataType.createDisplayString(text);
    }

    public static String formatText(String text) {
        if (text == null || text.length() < 1) {
            return null;
        }
        char[] p = text.toCharArray();
        char[] q = new char[p.length];
        int c = 0;
        boolean space = false;
        int i = 0;
        while (i < p.length) {
            if (!space) {
                if (!Character.isWhitespace(p[i])) {
                    q[c++] = p[i];
                } else {
                    q[c++] = 32;
                    space = true;
                }
            } else if (!Character.isWhitespace(p[i])) {
                q[c++] = p[i];
                space = false;
            }
            ++i;
        }
        if (c > 0) {
            return new String(q, 0, c);
        }
        return null;
    }

    public static boolean hasNonWhitespace(String value) {
        if (value != null) {
            char[] p = value.toCharArray();
            int i = 0;
            while (i < p.length) {
                if (!Character.isWhitespace(p[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

