/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class RuntimeUtil {
    public static String WAS_AST_RUNTIME_ID = "com.ibm.ws.ast.st.runtime";
    public static String WAS_AST_V60_RUNTIME_VERSION_ID = "6.0";
    public static String WAS_AST_V61_RUNTIME_VERSION_ID = "6.1";
    public static String WAS_AST_V70_RUNTIME_VERSION_ID = "7.0";
    public static String WPS_RUNTIME_ID = "com.ibm.etools.portal.runtime.core";
    public static String WPS_V51_RUNTIME_ID = "5.1";
    public static String WPS_V60_RUNTIME_ID = "6.0";
    public static String WED_RUNTIME_ID = "com.ibm.pvc.tools.j2ee.server.wctme.runtime";
    public static String WED_V61_RUNTIME_VERSION_ID = "6.1";
    public static String WED_V62_RUNTIME_VERSION_ID = "6.2";
    public static String WAS_CE_RUNTIME_ID = "org.apache.geronimo.runtime";
    public static String WAS_CE_1_0_RUNTIME_VERSION_ID = "1.0";

    public static IRuntime getRuntime(IProject project) {
        IRuntime runtime = null;
        IFacetedProject facetProj = null;
        if (project != null) {
            try {
                facetProj = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            runtime = facetProj.getRuntime();
        }
        return runtime;
    }

    protected static boolean isTargetedAt(IRuntime runtime, String runtimeId) {
        boolean allowed = false;
        if (runtime != null && runtimeId != null) {
            List runtimeComponents = runtime.getRuntimeComponents();
            for (IRuntimeComponent runtimeComponent : runtimeComponents) {
                try {
                    String id = runtimeComponent.getRuntimeComponentType().getId();
                    if (!runtimeId.startsWith(id)) continue;
                    allowed = true;
                    break;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        return allowed;
    }

    private static boolean isTargetedAt(IRuntime runtime, String runtimeId, String runtimeVersion) {
        boolean allowed = false;
        if (runtime != null) {
            List comps = runtime.getRuntimeComponents();
            for (IRuntimeComponent component : comps) {
                try {
                    String id = component.getRuntimeComponentType().getId();
                    String version = component.getRuntimeComponentVersion().getVersionString();
                    if (!runtimeId.startsWith(id) || !runtimeVersion.equals(version)) continue;
                    allowed = true;
                    break;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        return allowed;
    }

    public static boolean isTargetedAtPortalServer(IProject project) {
        IRuntime runtime = RuntimeUtil.getRuntime(project);
        return RuntimeUtil.isTargetedAtPortalServer(runtime);
    }

    public static boolean isTargetedAtPortalServer(IRuntime runtime) {
        return RuntimeUtil.isTargetedAtPortalV51(runtime) || RuntimeUtil.isTargetedAtPortalV60(runtime);
    }

    public static boolean isTargetedAtPortalV51(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WPS_RUNTIME_ID, WPS_V51_RUNTIME_ID);
    }

    public static boolean isTargetedAtPortalV60(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WPS_RUNTIME_ID, WPS_V60_RUNTIME_ID);
    }

    public static boolean isTargetedAtSupportedRuntime(IRuntime runtime) {
        return RuntimeUtil.isTargetedAtWASV60(runtime) || RuntimeUtil.isTargetedAtWASV61(runtime) || RuntimeUtil.isTargetedAtWASV70(runtime) || RuntimeUtil.isTargetedAtPortalServer(runtime) || RuntimeUtil.isTargetedAtWEDV61(runtime) || RuntimeUtil.isTargetedAtWASCE(runtime);
    }

    public static boolean isTargetedAtSupportedSDORuntime(IRuntime runtime) {
        return RuntimeUtil.isTargetedAtWASV60(runtime) || RuntimeUtil.isTargetedAtWASV61(runtime) || RuntimeUtil.isTargetedAtWASV70(runtime) || RuntimeUtil.isTargetedAtPortalServer(runtime);
    }

    public static boolean isTargetedAtWASCE(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WAS_CE_RUNTIME_ID, WAS_CE_1_0_RUNTIME_VERSION_ID);
    }

    public static boolean isTargetedAtWASV60(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WAS_AST_RUNTIME_ID, WAS_AST_V60_RUNTIME_VERSION_ID);
    }

    public static boolean isTargetedAtWASV61(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WAS_AST_RUNTIME_ID, WAS_AST_V61_RUNTIME_VERSION_ID);
    }

    public static boolean isTargetedAtWASV70(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WAS_AST_RUNTIME_ID, WAS_AST_V70_RUNTIME_VERSION_ID);
    }

    public static boolean isTargetedAtWEDV61(IRuntime runtime) {
        return RuntimeUtil.isTargetedAt(runtime, WED_RUNTIME_ID, WED_V61_RUNTIME_VERSION_ID) || RuntimeUtil.isTargetedAt(runtime, WED_RUNTIME_ID, WED_V62_RUNTIME_VERSION_ID);
    }
}

