/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.util.DataAccessLabelProvider;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RDBUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.SQLSorter;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.hierar.ServerExplorerHierarContentProviderNav;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.DatabaseHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class DataToolsDBTableViewer
extends TreeViewer {
    protected Table fSelectedTable;

    public DataToolsDBTableViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public static Table findRDBCommonTable(String tableName, Database rdbDatabase) {
        Table ret = null;
        if (tableName.indexOf(".") == -1) {
            List tabs = DatabaseHelper.findTables((Database)rdbDatabase, (String)tableName);
            if (tabs.size() > 0) {
                ret = (Table)tabs.get(0);
            }
        } else {
            String schemaName = tableName.substring(0, tableName.indexOf("."));
            String rbdTbName = tableName.substring(tableName.indexOf(".") + 1);
            Schema schema = DatabaseHelper.findSchema((Database)rdbDatabase, (String)schemaName);
            if (schema != null) {
                for (Table table : schema.getTables()) {
                    if (RDBUtil.compareIdentifiers(rdbDatabase, table.getName(), rbdTbName) != 0) continue;
                    ret = table;
                }
            }
        }
        return ret;
    }

    public Table getRDBCommonTable() {
        Table ret = null;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof Table) {
            ret = (Table)obj;
        }
        return ret;
    }

    protected void init() {
        this.setContentProvider((IContentProvider)new ShowTableConentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DataAccessLabelProvider());
    }

    public Table selectTable(String schemaName, String tableName) {
        Database db = null;
        this.fSelectedTable = null;
        if (this.getTree() != null && !this.getTree().isDisposed() && this.getInput() instanceof Database) {
            db = (Database)this.getInput();
            try {
                tableName = String.valueOf(schemaName) + "." + tableName;
                this.fSelectedTable = DataToolsDBTableViewer.findRDBCommonTable(tableName, db);
                this.expandToLevel(3);
                if (this.fSelectedTable != null) {
                    StructuredSelection select = new StructuredSelection((Object)this.fSelectedTable);
                    this.setSelection((ISelection)select);
                    this.reveal(this.fSelectedTable);
                } else {
                    this.getTree().deselectAll();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.fSelectedTable;
    }

    protected class ShowTableConentProvider
    extends ServerExplorerHierarContentProviderNav
    implements ITreeContentProvider {
        protected ShowTableConentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] ret = new Object[]{};
            if (!(parentElement instanceof Table)) {
                ret = super.getChildren(parentElement);
            }
            SQLSorter sorter = new SQLSorter();
            ret = sorter.sort(ret);
            return ret;
        }

        public Object[] getElements(Object inputElement) {
            Object[] ret = new Object[]{};
            if (inputElement instanceof Database) {
                Database db = (Database)inputElement;
                ret = this.displayDatabaseChildren(db);
            } else if (inputElement instanceof Schema) {
                Schema schema = (Schema)inputElement;
                ret = this.displaySchemaChildren(schema);
            }
            SQLSorter sorter = new SQLSorter();
            ret = sorter.sort(ret);
            return ret;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

