/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.etools.sdo.jdbc.ui.internal.Logger;
import com.ibm.etools.sdo.jdbc.ui.internal.connections.util.ConnectionsResourceFactoryImpl;
import com.ibm.etools.sdo.jdbc.ui.internal.connections.util.ConnectionsResourceImpl;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DatasourceConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DriverManagerConnectionWrapper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connections;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsFactory;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsPackage;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DevelopmentConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DocumentRoot;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DriverManagerConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RscLiveConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConnectionsHelper {
    static ConnectionsPackage init = ConnectionsPackage.eINSTANCE;

    @Deprecated
    public static final EList addConnection(IProject proj, Connection connection) throws IOException {
        return ConnectionsHelper.addConnection(proj, connection, null);
    }

    public static final EList addConnection(IProject proj, Connection connection, Shell shell) throws IOException {
        Connections connections = ConnectionsHelper.initializeConnections(proj);
        boolean addCon = true;
        for (Connection existingConnection : connections.getConnection()) {
            if (!existingConnection.getId().equals(connection.getId())) continue;
            addCon = false;
            break;
        }
        if (addCon) {
            connections.getConnection().add((Object)connection);
            ConnectionsHelper.saveConnections(connections, proj, shell);
        }
        return connections.getConnection();
    }

    @Deprecated
    public static final void editConnection(IProject proj, Connection connection) throws IOException {
        ConnectionsHelper.editConnection(proj, connection, null);
    }

    public static final void editConnection(IProject proj, Connection connection, Shell shell) throws IOException {
        Connections connections = ConnectionsHelper.initializeConnections(proj);
        int selIndex = -1;
        int i = 0;
        for (Connection existingConnection : connections.getConnection()) {
            if (existingConnection.getId().equals(connection.getId())) {
                selIndex = i;
                break;
            }
            ++i;
        }
        if (selIndex != -1) {
            connections.getConnection().set(selIndex, (Object)connection);
        }
        ConnectionsHelper.saveConnections(connections, proj, shell);
    }

    public static final String getConfigFileEncoding() {
        return "UTF-8";
    }

    public static Connection getConnection(IProject proj, String connectionId) throws IOException {
        Connection ret = null;
        EList connections = ConnectionsHelper.getConnections(proj);
        int i = 0;
        while (i < connections.size()) {
            if (((Connection)connections.get(i)).getId().equals(connectionId)) {
                ret = (Connection)connections.get(i);
                break;
            }
            ++i;
        }
        return ret;
    }

    public static final int getConnectionCount(IProject proj) throws IOException {
        return ConnectionsHelper.getConnections(proj).size();
    }

    public static IFile getConnectionFilePath(IProject proj) {
        IFile connectionsFile = null;
        if (proj != null) {
            connectionsFile = ConnectionsHelper.getConnectionsFile(proj);
        }
        return connectionsFile;
    }

    public static String getConnectionIdForDataSource(IProject project, String refName) throws IOException {
        String id = null;
        EList connections = ConnectionsHelper.getConnections(project);
        int i = 0;
        while (i < connections.size()) {
            Connection con;
            DatasourceConnection runCon;
            if (ConnectionsHelper.isDatasourceConnection(project, i) && (runCon = (DatasourceConnection)(con = (Connection)connections.get(i)).getRuntime()).getResourceReferenceName().equals(refName)) {
                id = con.getId();
            }
            ++i;
        }
        return id;
    }

    public static final EList getConnections(IProject proj) throws IOException {
        Connections connections = ConnectionsHelper.initializeConnections(proj);
        return connections.getConnection();
    }

    private static IFile getConnectionsFile(IProject project) {
        IFile file = project.getFile(".wdo-connections");
        return file;
    }

    public static final DatasourceConnectionWrapper getDatasourceConnectionWrapper(IProject project, int index) throws IOException, ArrayIndexOutOfBoundsException, ClassCastException {
        return new DatasourceConnectionWrapper((DatasourceConnection)((Connection)ConnectionsHelper.getConnections(project).get(index)).getRuntime());
    }

    public static String getDevConnectionName(Connection conn, boolean defaultConnId) {
        if (conn == null) {
            return null;
        }
        DevelopmentConnection devConn = conn.getDevelopment();
        if (devConn instanceof RscLiveConnection) {
            return ((RscLiveConnection)devConn).getName();
        }
        return defaultConnId ? conn.getId() : null;
    }

    public static final DriverManagerConnectionWrapper getDriverManagerConnectionWrapper(IProject project, int index) throws IOException, ArrayIndexOutOfBoundsException, ClassCastException {
        return new DriverManagerConnectionWrapper((DriverManagerConnection)((Connection)ConnectionsHelper.getConnections(project).get(index)).getRuntime());
    }

    public static boolean hasConnectionsFile(IProject project) {
        if (project == null) {
            return false;
        }
        IFile connectionsFile = ConnectionsHelper.getConnectionFilePath(project);
        return connectionsFile != null && connectionsFile.exists();
    }

    private static Connections initializeConnections(IProject proj) throws IOException {
        ConnectionsResourceFactoryImpl factory = new ConnectionsResourceFactoryImpl();
        IFile connectionsFile = ConnectionsHelper.getConnectionFilePath(proj);
        URI uri = URI.createFileURI((String)connectionsFile.getLocation().toOSString());
        ConnectionsResourceImpl resource = (ConnectionsResourceImpl)factory.createResource(uri);
        Connections connection = null;
        try {
            resource.load(resource.getDefaultLoadOptions());
            Object rawConnections = resource.getContents().get(0);
            if (rawConnections instanceof Connections) {
                connection = (Connections)rawConnections;
            } else if (rawConnections instanceof DocumentRoot) {
                connection = ((DocumentRoot)rawConnections).getConnections();
            }
        }
        catch (Exception exception) {
            connection = ConnectionsFactory.eINSTANCE.createConnections();
        }
        return connection;
    }

    public static boolean isConnectionExist(IProject proj, String connectionId) throws IOException {
        boolean ret = false;
        EList connections = ConnectionsHelper.getConnections(proj);
        int i = 0;
        while (i < connections.size()) {
            if (((Connection)connections.get(i)).getId().equals(connectionId)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static final boolean isConnectionsFileExist(IProject project) {
        boolean ret = false;
        IFile file = null;
        if (project != null) {
            file = ConnectionsHelper.getConnectionsFile(project);
        }
        if (file != null && file.exists()) {
            ret = true;
        }
        return ret;
    }

    public static final boolean isDatasourceConnection(IProject proj, int index) throws IOException, ArrayIndexOutOfBoundsException {
        return ((Connection)ConnectionsHelper.getConnections(proj).get(index)).getRuntime() instanceof DatasourceConnection;
    }

    public static final boolean isDriverManagerConnection(IProject proj, int index) throws IOException, ArrayIndexOutOfBoundsException {
        return ((Connection)ConnectionsHelper.getConnections(proj).get(index)).getRuntime() instanceof DriverManagerConnection;
    }

    private static void refreshFileInWorkspace(IFile file) {
        try {
            IContainer container = file.getParent();
            if (container != null) {
                container.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static final EList removeConnection(IProject proj, Connection connection) throws IOException {
        return ConnectionsHelper.removeConnection(proj, connection, null);
    }

    public static final EList removeConnection(IProject proj, Connection connection, Shell shell) throws IOException {
        Connections connections = ConnectionsHelper.initializeConnections(proj);
        boolean removeCon = false;
        int i = connections.getConnection().size() - 1;
        while (i >= 0) {
            Connection existingConnection = (Connection)connections.getConnection().get(i);
            if (existingConnection.getId().equals(connection.getId())) {
                removeCon = true;
                connections.getConnection().remove(i);
            }
            --i;
        }
        if (removeCon) {
            ConnectionsHelper.saveConnections(connections, proj, shell);
        }
        return connections.getConnection();
    }

    private static void saveConnections(Connections connections, IProject proj, final Shell shell) throws IOException {
        IFile file;
        block13: {
            ConnectionsResourceFactoryImpl factory = new ConnectionsResourceFactoryImpl();
            file = ConnectionsHelper.getConnectionFilePath(proj);
            IStatus status = file.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
            if (status.isOK()) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
                ConnectionsResourceImpl resource = (ConnectionsResourceImpl)factory.createResource(uri);
                ConnectionsHelper.setEncoding((XMLResource)resource);
                resource.getContents().clear();
                resource.getContents().add((Object)connections);
                try {
                    resource.save(resource.getDefaultSaveOptions());
                }
                catch (Exception e) {
                    final String errorMessage = e.getLocalizedMessage();
                    if (shell != null) {
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)shell, (String)ResourceHandler.SDOJDBCMediatorWizard_4, (String)errorMessage);
                            }
                        });
                        break block13;
                    }
                    Logger.logException(errorMessage, status.getException());
                    try {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)shell, (String)ResourceHandler.SDOJDBCMediatorWizard_4, (String)errorMessage);
                            }
                        });
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (status.getSeverity() != 8) {
                final String errorMessage = String.valueOf(ResourceHandler.Failed_Validate_Edit) + " - " + file.getFullPath() + ": " + status.getMessage();
                if (shell != null) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)ResourceHandler.SDOJDBCMediatorWizard_4, (String)errorMessage);
                        }
                    });
                } else {
                    Logger.logException(errorMessage, status.getException());
                    try {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)shell, (String)ResourceHandler.SDOJDBCMediatorWizard_4, (String)errorMessage);
                            }
                        });
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        if (file != null) {
            ConnectionsHelper.refreshFileInWorkspace(file);
        }
    }

    public static boolean setDevConnectionName(Connection conn, String newName) {
        if (conn == null || newName == null || newName.length() == 0) {
            return false;
        }
        DevelopmentConnection devConn = conn.getDevelopment();
        if (devConn instanceof RscLiveConnection) {
            ((RscLiveConnection)devConn).setName(newName);
            return true;
        }
        return false;
    }

    public static void setEncoding(XMLResource resource) {
        resource.setEncoding(ConnectionsHelper.getConfigFileEncoding());
    }
}

