/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.util;

import com.ibm.datatools.connection.ui.databases.actions.NewDBConnectionAction;
import com.ibm.etools.webtools.deploy.jdbc.internal.ui.SelectExistingConnectionWizard;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class ConnectionProfileUtil {
    public static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";

    public static IConnectionProfile createNewProfile() {
        LocalProfileListener listener = new LocalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        NewDBConnectionAction action = new NewDBConnectionAction();
        action.run();
        IConnectionProfile addedProfile = listener.addedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        return addedProfile;
    }

    public static IConnectionProfile openSelectExistingConnectionDialog() {
        SelectExistingConnectionWizard wizard = new SelectExistingConnectionWizard();
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(300, 350);
        dialog.create();
        dialog.open();
        return wizard.getSelectedProfile();
    }

    private static class LocalProfileListener
    implements IProfileListener {
        IConnectionProfile addedProfile;

        private LocalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.addedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
            if (profile == this.addedProfile) {
                this.addedProfile = null;
            }
        }
    }
}

