/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.propertypages;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.sdo.jdbc.ui.internal.ConnectionPage;
import com.ibm.etools.sdo.jdbc.ui.internal.data.ConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.deploy.JDBCConnectionDeployBuilder;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsUIUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;

public class JDBCConnectionsPropertyPage
extends PropertyPage
implements Listener,
Observer {
    public static final String PAGE_ID = "com.ibm.etools.sdo.jdbc.ui.propertypages.JDBCConnectionsPropertyPage";
    private IProject fProject;
    private Composite fNoConnectionsComposite;
    private Composite fYouGotConnectionsComposite;
    private Composite fTopComposite;
    private Button fCreateNewConnectionButton;
    private ConnectionPage fConnectionPage;
    private boolean connectionsChanged = false;

    public JDBCConnectionsPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    public static boolean addSDOBuilderToBuildSpec(String successorID, IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(JDBCConnectionDeployBuilder.SDO_DEPLOY_BUILDER_ID) || commands[i].getBuilderName().equals(JDBCConnectionDeployBuilder.OLD_SDO_DEPLOY_BUILDER_ID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            boolean successorFound = false;
            ICommand command = description.newCommand();
            if (MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible")) {
                command.setBuilderName(JDBCConnectionDeployBuilder.OLD_SDO_DEPLOY_BUILDER_ID);
            } else {
                command.setBuilderName(JDBCConnectionDeployBuilder.SDO_DEPLOY_BUILDER_ID);
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            int j = 0;
            int index = 0;
            while (j < commands.length) {
                if (successorID != null && commands[j].getBuilderName().equals(successorID)) {
                    successorFound = true;
                    newCommands[index++] = command;
                }
                newCommands[index] = commands[j];
                ++j;
                ++index;
            }
            if (!successorFound) {
                newCommands[newCommands.length - 1] = command;
            }
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        return !found;
    }

    public void applyData(Object data) {
        if (data instanceof ConnectionData) {
            this.fConnectionPage.setConnectionData((ConnectionData)data);
            this.fConnectionPage.updateCustomAttributeView();
            this.fConnectionPage.updateConnDescriptionComposite();
        }
    }

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            this.fProject = (IProject)element;
        }
        this.fTopComposite = DialogUtil.createComposite(parent, 1);
        this.fTopComposite.setLayout((Layout)new StackLayout());
        this.fNoConnectionsComposite = DialogUtil.createComposite(this.fTopComposite, 1);
        DialogUtil.createLabel(this.fNoConnectionsComposite, ResourceHandler.JDBCConnectionsPropertyPage_1);
        DialogUtil.createLabel(this.fNoConnectionsComposite, "");
        Label lab = DialogUtil.createLabel(this.fNoConnectionsComposite, ResourceHandler.JDBCConnectionsPropertyPage_4);
        GridData layoutData = (GridData)lab.getLayoutData();
        layoutData.widthHint = 400;
        this.fCreateNewConnectionButton = DialogUtil.createButton(this.fNoConnectionsComposite, ResourceHandler.JDBCConnectionsPropertyPage_2, 8, new GridData(32));
        this.fCreateNewConnectionButton.addListener(13, (Listener)this);
        this.fYouGotConnectionsComposite = DialogUtil.createComposite(this.fTopComposite, 1);
        DialogUtil.createLabel(this.fYouGotConnectionsComposite, ResourceHandler.JDBCConnectionsPropertyPage_3);
        this.fConnectionPage = new ConnectionPage();
        ConnectionData connectionData = new ConnectionData();
        connectionData.setShell(this.getShell());
        this.fConnectionPage.setConnectionData(connectionData);
        this.getConnectionData().setConnect(false);
        this.fConnectionPage.setProject(this.fProject);
        this.fConnectionPage.createControl(this.fYouGotConnectionsComposite);
        this.fConnectionPage.addObserver(this);
        this.fConnectionPage.updateConnDescriptionComposite();
        this.updateTopComposite();
        return this.fTopComposite;
    }

    private int getConnectionCount() {
        int count = 0;
        try {
            count = ConnectionsHelper.getConnectionCount(this.fProject);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    private IConnectionData getConnectionData() {
        return this.fConnectionPage != null ? this.fConnectionPage.getConnectionData() : null;
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this.fCreateNewConnectionButton) {
            if (this.fProject != null) {
                try {
                    JDBCConnectionsPropertyPage.addSDOBuilderToBuildSpec(null, this.fProject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            IConnectionData data = ConnectionsUIUtil.createNewConnection(this.fProject, this.getShell());
            this.applyData(data);
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.connectionsChanged) {
            try {
                if (ConnectionsHelper.isConnectionsFileExist(this.fProject)) {
                    JDBCConnectionsPropertyPage.addSDOBuilderToBuildSpec(null, this.fProject);
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updateTopComposite();
        this.connectionsChanged = true;
    }

    private void updateTopComposite() {
        if (this.getConnectionCount() == 0) {
            if (((StackLayout)this.fTopComposite.getLayout()).topControl != this.fNoConnectionsComposite) {
                ((StackLayout)this.fTopComposite.getLayout()).topControl = this.fNoConnectionsComposite;
                this.fTopComposite.layout();
            }
        } else if (((StackLayout)this.fTopComposite.getLayout()).topControl != this.fYouGotConnectionsComposite) {
            ((StackLayout)this.fTopComposite.getLayout()).topControl = this.fYouGotConnectionsComposite;
            this.fConnectionPage.updateCustomAttributeView();
            this.fTopComposite.layout();
        }
    }
}

