/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import com.ibm.etools.sdo.jdbc.ui.internal.deploy.WASExtensions;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RegistryReader;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class WasExtensionsRegistryReader
extends RegistryReader {
    private static final String SERVER_SETUP_EXT_PNT_ID = "wasExtensions";
    private static final String WAS_EXTENSIONS = "wasExtensions";
    private static final String CLASS_ATT = "class";
    private static final String ID_ATT = "id";
    private static WasExtensionsRegistryReader fWASExtensionsRegistryReader;
    private Map fElements = new HashMap();

    protected WasExtensionsRegistryReader() {
    }

    public static WASExtensions[] createWASExtensions(String serverId) {
        fWASExtensionsRegistryReader = new WasExtensionsRegistryReader();
        fWASExtensionsRegistryReader.parseWASExtensions();
        ArrayList<WASExtensions> wasExtensions = new ArrayList<WASExtensions>();
        if (WasExtensionsRegistryReader.fWASExtensionsRegistryReader.fElements != null && WasExtensionsRegistryReader.fWASExtensionsRegistryReader.fElements.get(serverId) instanceof List) {
            List elements = (List)WasExtensionsRegistryReader.fWASExtensionsRegistryReader.fElements.get(serverId);
            int i = 0;
            while (i < elements.size()) {
                WASExtensions wasExtension = fWASExtensionsRegistryReader.createWASExtensions((IConfigurationElement)elements.get(i));
                if (wasExtension != null) {
                    wasExtensions.add(wasExtension);
                }
                ++i;
            }
        }
        return wasExtensions.toArray(new WASExtensions[wasExtensions.size()]);
    }

    private WASExtensions createWASExtensions(IConfigurationElement element) {
        String wasExtensionsClass = element.getAttribute(CLASS_ATT);
        WASExtensions ret = null;
        if (wasExtensionsClass != null) {
            Object classObject = null;
            try {
                classObject = element.createExecutableExtension(CLASS_ATT);
                if (classObject instanceof WASExtensions) {
                    ret = (WASExtensions)classObject;
                }
            }
            catch (CoreException ce) {
                this.logError(element, ce.getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private void parseWASExtensions() {
        this.readRegistry(Platform.getExtensionRegistry(), DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), "wasExtensions");
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase("wasExtensions")) {
            String id = element.getAttribute(ID_ATT);
            if (!this.fElements.containsKey(id)) {
                ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                list.add(element);
                this.fElements.put(id, list);
            } else {
                Object listObject = this.fElements.get(id);
                if (listObject instanceof List) {
                    List list = (List)listObject;
                    list.add(element);
                } else {
                    ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                    list.add(element);
                    this.fElements.put(id, list);
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

