/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import com.ibm.etools.sdo.jdbc.ui.internal.deploy.ServerSetup;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RegistryReader;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ServerSetupRegistryReader
extends RegistryReader {
    private static final String SERVER_SETUP_EXT_PNT_ID = "serverSetup";
    private static final String SERVER = "server";
    private static final String CLASS_ATT = "class";
    private static final String ID_ATT = "id";
    private static ServerSetupRegistryReader fServerSetupRegistryReader;
    private Map fElements = new HashMap();

    protected ServerSetupRegistryReader() {
    }

    public static List createServerSetups(String serverId) {
        fServerSetupRegistryReader = new ServerSetupRegistryReader();
        fServerSetupRegistryReader.parseServerSetups();
        ArrayList<ServerSetup> setUps = new ArrayList<ServerSetup>();
        if (ServerSetupRegistryReader.fServerSetupRegistryReader.fElements != null) {
            List elements = ServerSetupRegistryReader.getServerSetupThatMatch(serverId);
            int i = 0;
            while (i < elements.size()) {
                ServerSetup serverSetUp = fServerSetupRegistryReader.createServerSetup((IConfigurationElement)elements.get(i));
                if (serverSetUp != null) {
                    setUps.add(serverSetUp);
                }
                ++i;
            }
        }
        return setUps;
    }

    private static List getServerSetupThatMatch(String serverId) {
        ArrayList ret = new ArrayList();
        Set keys = ServerSetupRegistryReader.fServerSetupRegistryReader.fElements.keySet();
        for (String element : keys) {
            Pattern p = Pattern.compile(element);
            Matcher m = p.matcher(serverId);
            if (!m.matches() || !(ServerSetupRegistryReader.fServerSetupRegistryReader.fElements.get(element) instanceof List)) continue;
            ret.addAll((List)ServerSetupRegistryReader.fServerSetupRegistryReader.fElements.get(element));
        }
        return ret;
    }

    private ServerSetup createServerSetup(IConfigurationElement element) {
        String serverSetupClass = element.getAttribute(CLASS_ATT);
        ServerSetup ret = null;
        if (serverSetupClass != null) {
            Object classObject = null;
            try {
                classObject = element.createExecutableExtension(CLASS_ATT);
                if (classObject instanceof ServerSetup) {
                    ret = (ServerSetup)classObject;
                }
            }
            catch (CoreException ce) {
                this.logError(element, ce.getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private void parseServerSetups() {
        this.readRegistry(Platform.getExtensionRegistry(), DeployJDBCPlugin.getDefault().getBundle().getSymbolicName(), SERVER_SETUP_EXT_PNT_ID);
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(SERVER)) {
            String id = element.getAttribute(ID_ATT);
            if (!this.fElements.containsKey(id)) {
                ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                list.add(element);
                this.fElements.put(id, list);
            } else {
                Object listObject = this.fElements.get(id);
                if (listObject instanceof List) {
                    List list = (List)listObject;
                    list.add(element);
                } else {
                    ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
                    list.add(element);
                    this.fElements.put(id, list);
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

