/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.deploy;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetUtil {
    public static boolean changeFacetVersion(IProject project, String facetName, String newFacetversion, IProgressMonitor monitor) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    isDefined = facet.hasVersion(newFacetversion);
                    IProjectFacetVersion javafacetversion = facet.getVersion(newFacetversion);
                    HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javafacetversion, null));
                    facetedProject.modify(actions, monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean installFacet(IProject project, String facetName, String version, IProgressMonitor monitor) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    isDefined = facet.hasVersion(version);
                    IProjectFacetVersion javafacetversion = facet.getVersion(version);
                    if (!facetedProject.hasProjectFacet(facet) && !facetedProject.hasProjectFacet(javafacetversion)) {
                        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                        actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javafacetversion, null));
                        facetedProject.modify(actions, monitor);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean isFacetDefinedOnProject(IProject project, String facetName) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                isDefined = facetedProject == null || facet == null ? false : facetedProject.hasProjectFacet(facet);
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean isFacetDefinedOnProject(IProject project, String facetName, String version) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    IProjectFacetVersion facetVersion = facet.getVersion(version);
                    if (facetVersion == null) {
                        isDefined = false;
                    }
                    isDefined = facetedProject.hasProjectFacet(facetVersion);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }

    public static boolean isFacetedProject(IProject project) {
        boolean isFacetedProj = false;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) {
                isFacetedProj = true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isFacetedProj;
    }

    public static boolean uninstallFacet(IProject project, String facetName, String version, IProgressMonitor monitor) {
        boolean isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
        if (isDefined) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                if (facetedProject == null || facet == null) {
                    isDefined = false;
                } else {
                    isDefined = facet.hasVersion(version);
                    IProjectFacetVersion javafacetversion = facet.getVersion(version);
                    HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, javafacetversion, null));
                    facetedProject.modify(actions, monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                isDefined = false;
            }
        }
        return isDefined;
    }
}

