/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.data;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCSQLVendorType;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsFactory;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DatasourceConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DevelopmentConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DriverManagerConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RscImportedDatabase;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RscLiveConnection;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.RuntimeConnection;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.widgets.Shell;

public class ConnectionData
implements IConnectionData,
Cloneable {
    private IProject fProject;
    private IProgressMonitor fMonitor;
    private Shell fShell;
    private Connection fConnectionObject;
    private String fConnectionId;
    private String fUrl;
    private String fUserName;
    private String fPassword;
    private String fDriver;
    private String fResourceRefName;
    private String fClassName;
    private boolean fIsDriverManager = true;
    boolean fIsImportedDatabase = false;
    boolean fIsExistingConnection = false;
    boolean fIsNewConnection = true;
    private boolean fAutoDeploy = true;
    private String fDatabaseName;
    private String fJNDIName;
    private int fPortNumber = -1;
    private String fServerName;
    private RSCSQLVendorType fSQLVendorType = null;
    private String fDatabaseLocation;
    private String fClassLocation;
    IConnectionProfile connectionProfile;
    Database fRDBDatabase;
    private boolean fConnectionIdEditable = true;
    private boolean isConnect = true;
    private boolean reconnect = true;
    private boolean setInitialConnectionObjectDefaults = true;

    @Deprecated
    public static final void addConnection(IProject project, Connection connection) {
        ConnectionData.addConnection(project, connection, null);
    }

    public static final void addConnection(IProject project, Connection connection, Shell shell) {
        try {
            ConnectionsHelper.addConnection(project, connection, shell);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static final void editConnection(IProject project, Connection connection) {
        ConnectionData.editConnection(project, connection, null);
    }

    public static final void editConnection(IProject project, Connection connection, Shell shell) {
        try {
            ConnectionsHelper.editConnection(project, connection, shell);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final String generateUniqueConnectionId(IProject project) {
        Object[] connIds = ConnectionData.getConnectionIds(project);
        String defaulConnId = String.valueOf(project.getName()) + "_Con1";
        String connId = null;
        if (connIds.length > 0) {
            String oldConnId = connIds[connIds.length - 1];
            StringBuffer buf = new StringBuffer("");
            int i = oldConnId.length() - 1;
            while (i > 0) {
                if (!Character.isDigit(oldConnId.charAt(i))) {
                    buf.append(oldConnId.substring(0, i + 1));
                    break;
                }
                --i;
            }
            if (buf.toString().equals("")) {
                buf.append(defaulConnId);
            }
            i = 1;
            while (i <= 100) {
                String newConnId = String.valueOf(buf.toString()) + Integer.toString(i);
                if (TextUtilities.equals((String[])connIds, (String)newConnId) == -1) {
                    connId = newConnId;
                    break;
                }
                ++i;
            }
            if (connId == null) {
                Arrays.sort(connIds);
                connId = "Another" + (String)connIds[connIds.length - 1];
            }
        } else {
            connId = defaulConnId;
        }
        return connId;
    }

    public static final String[] getConnectionIds(IProject project) {
        List connectionList = ConnectionData.getConnections(project);
        ArrayList<String> connectionIdList = new ArrayList<String>();
        for (Connection conn : connectionList) {
            connectionIdList.add(conn.getId());
        }
        return connectionIdList.toArray(new String[connectionIdList.size()]);
    }

    public static final List getConnections(IProject project) {
        try {
            return ConnectionsHelper.getConnections(project);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (VerifyError e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    @Override
    public String getClassLocation() {
        return this.fClassLocation;
    }

    @Override
    public String getConnectionId() {
        return this.fConnectionId;
    }

    @Override
    public Connection getConnectionObject() {
        ConnectionsFactory factory = ConnectionsFactory.eINSTANCE;
        if (this.fConnectionObject == null) {
            this.fConnectionObject = factory.createConnection();
        }
        this.fConnectionObject.setId(this.getConnectionId());
        this.fConnectionObject.setDevelopment(this.getDevelopmentConnectionObject());
        this.fConnectionObject.setRuntime(this.getRuntimeConnectionObject());
        return this.fConnectionObject;
    }

    @Override
    public IConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            String devConnection = this.getDevConnectionName();
            if (devConnection == null) {
                return null;
            }
            try {
                this.connectionProfile = ProfileManager.getInstance().getProfileByName(devConnection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.connectionProfile;
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionObject().getRuntime().getConnectionString();
    }

    @Override
    public String getDatabaseLocation() {
        return this.fDatabaseLocation;
    }

    @Override
    public String getDatabaseName() {
        return this.fDatabaseName;
    }

    @Override
    public String getDataSourceClassName() {
        return this.fClassName;
    }

    private DatasourceConnection getDatasourceConnection(RuntimeConnection runtimeConnection) {
        DatasourceConnection datasourceConnection = (DatasourceConnection)runtimeConnection;
        datasourceConnection.setResourceReferenceName(this.getResourceRefName());
        datasourceConnection.setDatabaseName(this.getDatabaseName());
        int sqlVendorType = 0;
        RSCSQLVendorType vendorType = this.getSQLVendorType();
        if (vendorType != null) {
            sqlVendorType = vendorType.getValue();
        }
        datasourceConnection.setSqlVendorType(sqlVendorType);
        datasourceConnection.setAutoDeploy(this.isAutoDeploy());
        datasourceConnection.setClassLocation(this.getClassLocation());
        datasourceConnection.setUserid(this.getUserName());
        datasourceConnection.setPassword(this.getPassword());
        if (this.getDatabaseName() != null && this.getJNDIName() != null) {
            datasourceConnection.setJndiName(this.getJNDIName());
        }
        if (this.getPortNumber() != -1) {
            datasourceConnection.setPortNumber(this.getPortNumber());
        } else {
            datasourceConnection.unsetPortNumber();
        }
        if (this.getServerName() != null) {
            datasourceConnection.setServerName(this.getServerName());
        }
        if (this.getDatabaseLocation() != null) {
            datasourceConnection.setDatabaseLocation(this.getDatabaseLocation());
        }
        datasourceConnection.setClassname(this.getDataSourceClassName());
        return datasourceConnection;
    }

    public String getDevConnectionName() {
        if (this.fConnectionObject == null) {
            return null;
        }
        DevelopmentConnection devConnection = this.fConnectionObject.getDevelopment();
        if (devConnection instanceof RscImportedDatabase) {
            if (this.isImportedDatabase()) {
                return this.getConnectionId();
            }
        } else if (devConnection instanceof RscLiveConnection && this.isConnection()) {
            return ((RscLiveConnection)devConnection).getName();
        }
        return null;
    }

    private DevelopmentConnection getDevelopmentConnectionObject() {
        ConnectionsFactory factory = ConnectionsFactory.eINSTANCE;
        DevelopmentConnection devConnection = this.fConnectionObject.getDevelopment();
        if (devConnection != null) {
            if (devConnection instanceof RscImportedDatabase) {
                devConnection = !this.isImportedDatabase() ? null : this.getRscImportedDatabase(devConnection);
            } else if (devConnection instanceof RscLiveConnection && !this.isConnection()) {
                devConnection = null;
            }
        }
        if (devConnection == null) {
            if (this.isImportedDatabase()) {
                devConnection = factory.createRscImportedDatabase();
                devConnection.setId(String.valueOf(this.fConnectionObject.getId()) + "_dev");
                devConnection = this.getRscImportedDatabase(devConnection);
            } else if (this.isConnection()) {
                devConnection = factory.createRscLiveConnection();
                devConnection.setId(String.valueOf(this.fConnectionObject.getId()) + "_dev");
                this.updateDevConnectionNameWithRDBName((RscLiveConnection)devConnection);
            }
            this.fConnectionObject.setDevelopment(devConnection);
        }
        return devConnection;
    }

    @Override
    public String getDriver() {
        return this.fDriver;
    }

    private DriverManagerConnection getDriverManagerConnection(RuntimeConnection runtimeConnection) {
        DriverManagerConnection driverManagerConnection = (DriverManagerConnection)runtimeConnection;
        driverManagerConnection.setClassName(this.getDriver());
        driverManagerConnection.setUrl(this.getURL());
        driverManagerConnection.setAutoDeploy(this.isAutoDeploy());
        driverManagerConnection.setClassLocation(this.getClassLocation());
        driverManagerConnection.setUserid(this.getUserName());
        driverManagerConnection.setPassword(this.getPassword());
        return driverManagerConnection;
    }

    @Override
    public String getJNDIName() {
        return this.fJNDIName;
    }

    @Override
    public String getPassword() {
        return this.fPassword;
    }

    @Override
    public int getPortNumber() {
        return this.fPortNumber;
    }

    @Override
    public String getProductName() {
        int sqlVendorType2;
        RSCSQLVendorType type;
        String ret = null;
        int sqlVendorType = 0;
        RSCSQLVendorType vendorType = this.getSQLVendorType();
        if (vendorType != null) {
            sqlVendorType = vendorType.getValue();
        }
        if (sqlVendorType <= 0 && this.getConnectionObject() != null && this.getConnectionObject().getRuntime() != null && this.getConnectionObject().getRuntime() instanceof DatasourceConnection && (type = RSCSQLVendorType.get(sqlVendorType2 = ((DatasourceConnection)this.getConnectionObject().getRuntime()).getSqlVendorType())) != null) {
            this.setSQLVendorType(type);
        }
        if (sqlVendorType > 0) {
            sqlVendorType = 0;
            vendorType = this.getSQLVendorType();
            if (vendorType != null) {
                sqlVendorType = vendorType.getValue();
            }
            RSCSQLVendorType type2 = RSCSQLVendorType.get(sqlVendorType);
            ret = type2.getProductName();
        } else if (vendorType != null) {
            ret = vendorType.getProductName();
        }
        return ret;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public Database getRDBDatabase() {
        return this.getRDBDatabase(this.isConnect());
    }

    @Override
    public Database getRDBDatabase(boolean connect) {
        return this.getRDBDatabase(connect, true);
    }

    @Override
    public Database getRDBDatabase(boolean connect, boolean repromptIfConnectionFails) {
        if (this.fRDBDatabase != null) {
            return this.fRDBDatabase;
        }
        if (connect) {
            try {
                this.fRDBDatabase = RSCConnectionsHelper.getDatabaseAndInitializeConnection(this.getConnectionProfile(), this.getDevConnectionName(), repromptIfConnectionFails, this.fShell, this.fMonitor);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fRDBDatabase;
    }

    @Override
    public String getResourceRefName() {
        return this.fResourceRefName;
    }

    private RscImportedDatabase getRscImportedDatabase(DevelopmentConnection developmentConnection) {
        RscImportedDatabase importedDatabase = (RscImportedDatabase)developmentConnection;
        this.getRDBDatabase();
        return importedDatabase;
    }

    private RuntimeConnection getRuntimeConnectionObject() {
        ConnectionsFactory factory = ConnectionsFactory.eINSTANCE;
        RuntimeConnection runtimeConnection = this.fConnectionObject.getRuntime();
        if (runtimeConnection != null) {
            if (runtimeConnection instanceof DriverManagerConnection) {
                runtimeConnection = !this.isDriverManager() ? null : this.getDriverManagerConnection(runtimeConnection);
            } else if (runtimeConnection instanceof DatasourceConnection) {
                runtimeConnection = !this.isDataSource() ? null : this.getDatasourceConnection(runtimeConnection);
            }
        }
        if (runtimeConnection == null) {
            if (this.isDriverManager()) {
                runtimeConnection = factory.createDriverManagerConnection();
                runtimeConnection.setId(String.valueOf(this.fConnectionObject.getId()) + "_runtime");
                runtimeConnection = this.getDriverManagerConnection(runtimeConnection);
            } else if (this.isDataSource()) {
                runtimeConnection = factory.createDatasourceConnection();
                runtimeConnection.setId(String.valueOf(this.fConnectionObject.getId()) + "_runtime");
                runtimeConnection = this.getDatasourceConnection(runtimeConnection);
            }
            this.fConnectionObject.setRuntime(runtimeConnection);
        }
        return runtimeConnection;
    }

    @Override
    public String getServerName() {
        if (this.fServerName == null && RSCConnectionsHelper.needsServerName(this)) {
            return "localhost";
        }
        return this.fServerName;
    }

    @Override
    public RSCSQLVendorType getSQLVendorType() {
        return this.fSQLVendorType;
    }

    @Override
    public String getURL() {
        return this.fUrl;
    }

    @Override
    public String getUserName() {
        return this.fUserName;
    }

    @Override
    public boolean isAutoDeploy() {
        return this.fAutoDeploy;
    }

    @Override
    public boolean isConnect() {
        return this.isConnect;
    }

    @Override
    public boolean isConnection() {
        return this.isExistingConnection() || this.isNewConnection();
    }

    @Override
    public boolean isConnectionIdEditable() {
        return this.fConnectionIdEditable;
    }

    @Override
    public boolean isDataSource() {
        return !this.fIsDriverManager;
    }

    @Override
    public boolean isDriverManager() {
        return this.fIsDriverManager;
    }

    @Override
    public boolean isExistingConnection() {
        return this.fIsExistingConnection;
    }

    @Override
    public boolean isImportedDatabase() {
        return this.fIsImportedDatabase;
    }

    @Override
    public boolean isNewConnection() {
        return this.fIsNewConnection;
    }

    @Override
    public boolean isReconnect() {
        return this.reconnect;
    }

    @Override
    public boolean isSetInitialConnectionObjectDefaults() {
        return this.setInitialConnectionObjectDefaults;
    }

    @Override
    public void release() {
    }

    @Override
    public void setAutoDeploy(boolean fB) {
        this.fAutoDeploy = fB;
    }

    @Override
    public void setClassLocation(String fString) {
        this.fClassLocation = fString;
    }

    @Override
    public void setConnect(boolean isConnect) {
        this.isConnect = isConnect;
    }

    @Override
    public void setConnectionId(String connectionId) {
        this.fConnectionId = connectionId;
    }

    @Override
    public void setConnectionIdEditable(boolean b) {
        this.fConnectionIdEditable = b;
    }

    @Override
    public void setConnectionObject(Connection connectionObject) throws Exception {
        if (connectionObject == null) {
            return;
        }
        this.fConnectionObject = connectionObject;
        this.setConnectionId(this.fConnectionObject.getId());
        try {
            this.setDevelopmentConnectionObject(this.fConnectionObject.getDevelopment());
        }
        finally {
            this.setRuntimeConnectionObject(this.fConnectionObject.getRuntime());
        }
    }

    @Override
    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public void setConnectionString(String connectionString) {
        this.getConnectionObject().getRuntime().setConnectionString(connectionString);
    }

    @Override
    public void setDatabaseLocation(String fString) {
        this.fDatabaseLocation = fString;
    }

    @Override
    public void setDatabaseName(String fString) {
        this.fDatabaseName = fString;
    }

    @Override
    public void setDataSourceClassName(String className) {
        this.fClassName = className;
    }

    private void setDevelopmentConnectionObject(DevelopmentConnection connection) throws Exception {
        block13: {
            if (connection instanceof RscImportedDatabase) {
                RscImportedDatabase importedDatabase = (RscImportedDatabase)connection;
                String dbXmiLocation = importedDatabase.getXmiLocation();
                Path path = new Path(dbXmiLocation);
                path = path.makeRelative();
                IResource res = DeployJDBCPlugin.getWorkspace().getRoot().findMember((IPath)path);
                this.setIsImportedDatabase(true);
                this.setIsExistingConnection(false);
                this.setIsNewConnection(false);
                if (res != null && res.exists() && res.getType() == 1) {
                    Database rdbDatabase = RSCConnectionsHelper.loadRDBDatabase(res, this.fShell, this.fMonitor);
                    this.setRDBDatabase(rdbDatabase);
                } else {
                    this.setRDBDatabase(null);
                }
            } else if (connection instanceof RscLiveConnection) {
                RscLiveConnection liveConnection = (RscLiveConnection)connection;
                String connectionName = liveConnection.getName();
                try {
                    if (this.isConnect()) {
                        IConnectionProfile profileByName = ProfileManager.getInstance().getProfileByName(connectionName);
                        this.setConnectionProfile(profileByName);
                        Database database = null;
                        try {
                            database = RSCConnectionsHelper.getDatabaseAndInitializeConnection(profileByName, connectionName, this.isReconnect(), this.fShell, this.fMonitor);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.setRDBDatabase(database);
                        break block13;
                    }
                    if (this.connectionProfile != null && !this.connectionProfile.getName().equals(connectionName)) {
                        this.setConnectionProfile(null);
                    }
                }
                finally {
                    this.setIsImportedDatabase(false);
                    this.setIsExistingConnection(true);
                    this.setIsNewConnection(false);
                }
            }
        }
    }

    @Override
    public void setDriver(String string) {
        this.fDriver = string;
    }

    @Override
    public void setIsDataSource(boolean b) {
        this.fIsDriverManager = !b;
    }

    @Override
    public void setIsDriverManager(boolean b) {
        this.fIsDriverManager = b;
    }

    @Override
    public void setIsExistingConnection(boolean b) {
        this.fIsExistingConnection = b;
    }

    @Override
    public void setIsImportedDatabase(boolean b) {
        this.fIsImportedDatabase = b;
    }

    @Override
    public void setIsNewConnection(boolean b) {
        this.fIsNewConnection = b;
    }

    @Override
    public void setJNDIName(String fString) {
        this.fJNDIName = fString;
    }

    @Override
    public void setPassword(String string) {
        this.fPassword = string;
    }

    @Override
    public void setPortNumber(int fI) {
        this.fPortNumber = fI;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    @Override
    public void setProject(IProject project) {
        this.fProject = project;
    }

    @Override
    public void setRDBDatabase(Database database) {
        this.fRDBDatabase = database;
    }

    @Override
    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Override
    public void setResourceRefName(String string) {
        this.fResourceRefName = string;
    }

    private void setRuntimeConnectionObject(RuntimeConnection connection) {
        if (this.setInitialConnectionObjectDefaults) {
            if (this.isConnection()) {
                this.setRuntimeOptions(this.getConnectionProfile());
            } else {
                this.setRuntimeOptions(this.getRDBDatabase());
            }
        }
        if (connection instanceof DriverManagerConnection) {
            DriverManagerConnection driverManagerConnection = (DriverManagerConnection)connection;
            this.setIsDriverManager(true);
            this.setIsDataSource(false);
            this.setDriver(driverManagerConnection.getClassName());
            this.setURL(driverManagerConnection.getUrl());
            this.setUserName(driverManagerConnection.getUserid());
            this.setPassword(driverManagerConnection.getPassword());
            this.setAutoDeploy(driverManagerConnection.isAutoDeploy());
            this.setClassLocation(driverManagerConnection.getClassLocation());
        } else if (connection instanceof DatasourceConnection) {
            DatasourceConnection datasourceConnection = (DatasourceConnection)connection;
            this.setIsDriverManager(false);
            this.setIsDataSource(true);
            this.setResourceRefName(datasourceConnection.getResourceReferenceName());
            this.setUserName(datasourceConnection.getUserid());
            this.setPassword(datasourceConnection.getPassword());
            this.setAutoDeploy(datasourceConnection.isAutoDeploy());
            this.setDatabaseName(datasourceConnection.getDatabaseName());
            this.setDataSourceClassName(datasourceConnection.getClassname());
            this.setJNDIName(datasourceConnection.getJndiName());
            this.setPortNumber(datasourceConnection.getPortNumber());
            this.setServerName(datasourceConnection.getServerName());
            int sqlVendorType = datasourceConnection.getSqlVendorType();
            RSCSQLVendorType type = RSCSQLVendorType.get(sqlVendorType);
            if (type != null) {
                this.setSQLVendorType(type);
            }
            this.setClassLocation(datasourceConnection.getClassLocation());
            this.setDatabaseLocation(datasourceConnection.getDatabaseLocation());
        }
    }

    public void setRuntimeOptions(Database rdbDatabase) {
        if (rdbDatabase != null) {
            String name = rdbDatabase.getName();
            IConnectionProfile profileByName = ProfileManager.getInstance().getProfileByName(name);
            if (profileByName != null) {
                this.setRuntimeOptions(profileByName);
            }
        }
    }

    @Override
    public void setRuntimeOptions(IConnectionProfile rdbConnection) {
        RSCConnectionsHelper.setRuntimeDefaults(rdbConnection, this);
    }

    @Override
    public void setServerName(String fString) {
        this.fServerName = fString;
    }

    @Override
    public void setSetInitialConnectionObjectDefaults(boolean setInitialConnectionObjectDefaults) {
        this.setInitialConnectionObjectDefaults = setInitialConnectionObjectDefaults;
    }

    @Override
    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    @Override
    public void setSQLVendorType(RSCSQLVendorType fI) {
        this.fSQLVendorType = fI;
    }

    @Override
    public void setURL(String string) {
        this.fUrl = string;
    }

    @Override
    public void setUserName(String string) {
        this.fUserName = string;
    }

    private void updateDevConnectionNameWithRDBName(RscLiveConnection connection) {
        if (this.getConnectionProfile() == null) {
            return;
        }
        connection.setName(this.getConnectionProfile().getName());
    }
}

