/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal.connections.impl;

import com.ibm.etools.sdo.jdbc.ui.internal.connections.impl.RuntimeConnectionImpl;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DataAccessHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.ConnectionsPackage;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.DriverManagerConnection;
import com.ibm.icu.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class DriverManagerConnectionImpl
extends RuntimeConnectionImpl
implements DriverManagerConnection {
    protected static final String CLASS_NAME_EDEFAULT = null;
    protected String className = CLASS_NAME_EDEFAULT;
    protected static final String PASSWORD_EDEFAULT = null;
    protected String password = PASSWORD_EDEFAULT;
    protected static final String URL_EDEFAULT = null;
    protected String url = URL_EDEFAULT;
    protected static final String USERID_EDEFAULT = null;
    protected String userid = USERID_EDEFAULT;

    protected DriverManagerConnectionImpl() {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getClassName();
            }
            case 4: {
                return this.getPassword();
            }
            case 5: {
                return this.getUrl();
            }
            case 6: {
                return this.getUserid();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return CLASS_NAME_EDEFAULT == null ? this.className != null : !CLASS_NAME_EDEFAULT.equals(this.className);
            }
            case 4: {
                return PASSWORD_EDEFAULT == null ? this.password != null : !PASSWORD_EDEFAULT.equals(this.password);
            }
            case 5: {
                return URL_EDEFAULT == null ? this.url != null : !URL_EDEFAULT.equals(this.url);
            }
            case 6: {
                return USERID_EDEFAULT == null ? this.userid != null : !USERID_EDEFAULT.equals(this.userid);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setClassName((String)newValue);
                return;
            }
            case 4: {
                this.setPassword((String)newValue);
                return;
            }
            case 5: {
                this.setUrl((String)newValue);
                return;
            }
            case 6: {
                this.setUserid((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return ConnectionsPackage.Literals.DRIVER_MANAGER_CONNECTION;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setClassName(CLASS_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 5: {
                this.setUrl(URL_EDEFAULT);
                return;
            }
            case 6: {
                this.setUserid(USERID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getConnectionString() {
        StringBuffer connectionString = new StringBuffer();
        connectionString.append(this.getUrl());
        connectionString.append(",");
        connectionString.append(this.getClassName());
        if (this.getUserid() != null && this.getPassword() != null) {
            connectionString.append(",");
            connectionString.append(this.getUserid());
            connectionString.append(",");
            connectionString.append(this.getPassword());
        } else if (this.getUserid() != null && this.getStoredPass() != null) {
            connectionString.append(",");
            connectionString.append(this.getUserid());
            connectionString.append(",");
            connectionString.append(this.getStoredPass());
        } else if (this.getUserid() != null) {
            connectionString.append(",");
            connectionString.append(this.getUserid());
        }
        return connectionString.toString();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getStoredPass() {
        return DataAccessHelper.recvData(RSCConnectionsHelper.getRealm(this.getUrl()), this.getUserid());
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getUserid() {
        return this.userid;
    }

    @Override
    public void setClassName(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldClassName, (Object)this.className));
        }
    }

    @Override
    public void setConnectionString(String connection) {
        StringTokenizer tok = new StringTokenizer(connection, ",");
        if (tok.hasMoreTokens()) {
            this.setUrl(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            this.setClassName(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            this.setUserid(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            this.setPassword(tok.nextToken());
        }
    }

    @Override
    public void setPassword(String newPassword) {
        String oldPassword = this.password;
        this.password = newPassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPassword, (Object)this.password));
        }
    }

    @Override
    public void setUrl(String newUrl) {
        String oldUrl = this.url;
        this.url = newUrl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldUrl, (Object)this.url));
        }
    }

    @Override
    public void setUserid(String newUserid) {
        String oldUserid = this.userid;
        this.userid = newUserid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldUserid, (Object)this.userid));
        }
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (className: ");
        result.append(this.className);
        result.append(", password: ");
        result.append(this.password);
        result.append(", url: ");
        result.append(this.url);
        result.append(", userid: ");
        result.append(this.userid);
        result.append(')');
        return result.toString();
    }
}

