/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal;

import com.ibm.etools.sdo.jdbc.ui.internal.util.SingleTableColumnMaximizer;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class SimpleTableViewer
extends TableViewer {
    private Image[] fImages;
    private String[] fItems;
    private IBaseLabelProvider fLabelProvider;
    private IContentProvider fContentProvider;

    public SimpleTableViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private IContentProvider getAllColsContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    Object[] ret = new Object[]{};
                    if (SimpleTableViewer.this.fItems != null) {
                        ret = SimpleTableViewer.this.fItems;
                    }
                    return ret;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }
        return this.fContentProvider;
    }

    private IBaseLabelProvider getAllColsLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getImage(Object element) {
                    List<String> itemsList;
                    int index;
                    Image ret = null;
                    if (SimpleTableViewer.this.fItems != null && (index = (itemsList = Arrays.asList(SimpleTableViewer.this.fItems)).indexOf(element)) != -1 && SimpleTableViewer.this.fImages != null && index < SimpleTableViewer.this.fImages.length) {
                        ret = SimpleTableViewer.this.fImages[index];
                    }
                    return ret;
                }

                public String getText(Object element) {
                    return (String)element;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.fLabelProvider;
    }

    private void init() {
        new TableColumn(this.getTable(), 0);
        this.setColumnProperties(new String[]{"Available"});
        this.setContentProvider(this.getAllColsContentProvider());
        this.setLabelProvider(this.getAllColsLabelProvider());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 235, true));
        this.getTable().setLayout((Layout)tlayout);
        new SingleTableColumnMaximizer(this.getTable());
    }

    public void setItems(String[] items, Image[] images) {
        if (this.fItems != null) {
            this.remove(this.fItems);
        }
        this.fItems = items;
        this.fImages = images;
        this.setInput((Object)this);
    }
}

