/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal;

import com.ibm.etools.sdo.jdbc.ui.internal.ConnectionControl;
import com.ibm.etools.sdo.jdbc.ui.internal.IConnectionWizard;
import com.ibm.etools.sdo.jdbc.ui.internal.consts.IRdbTagConstants;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DataAccessHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.RSCSQLVendorType;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ResourceRefSelectionDialog;
import com.ibm.etools.sdo.jdbc.ui.internal.util.WebAppUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.WizardPageStatus;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class RuntimeConnectionPage
extends WizardPage
implements Listener,
IRdbTagConstants {
    private Button fDataSourceClassLocationSelectionButton;
    private Button fClassLocationSelectionButton;
    private Composite fDataSourceComposite;
    private Button fRequiresUseridCheckbox;
    private Composite fDriverManagerComposite;
    private StackLayout fStackLayout;
    private Composite fOptionsComposite;
    private Combo fDataSourceClassNameCombo;
    private Text fDataSourcePasswordText;
    private Text fDataSourceUserNameText;
    protected Button fUseDataSourceButton = null;
    protected String fUseDataSourceLabel = ResourceHandler.RuntimeConnectionPage_Use_data_source_connection_1;
    protected Button fUseDriverManagerButton = null;
    protected String fUseDriverManagerLabel = ResourceHandler.RuntimeConnectionPage_Use_driver_manager_connection_2;
    protected String fDataSourceNameLabel = ResourceHandler.RuntimeConnectionPage_Resource_reference_name__3;
    protected Text fResourceRefNameText = null;
    protected Button fResourceRefBrowseButton = null;
    protected String fDriverNameLabel = ResourceHandler.RuntimeConnectionPage_Driver_name__4;
    protected Text fDriverNameText = null;
    protected String fURLLabel = ResourceHandler.RuntimeConnectionPage_URL__5;
    protected Text fURLText = null;
    protected String fUserNameLabel = ResourceHandler.RuntimeConnectionPage_User_ID__6;
    protected Text fDriverUserNameText = null;
    protected String fPasswordLabel = ResourceHandler.RuntimeConnectionPage_Password__7;
    protected String fDataSourceClassNameLabel = ResourceHandler.RuntimeConnectionPage_DataSourceClassName;
    protected Text fDriverPasswordText = null;
    protected boolean wtPageSeen = false;
    public boolean wtUserNameModifed = false;
    protected boolean wtPasswordModifed;
    protected boolean wtDriverNameModifed = false;
    protected boolean wtDataSourceNameModifed = false;
    protected boolean wtURLModifed = false;
    private String USE_AUTO_DEPLOY_MSG = ResourceHandler.RuntimeConnectionPage_deploy_msg;
    private Button fDataSourceUseAutoDeployCheckboxButton;
    private final String SERVER_NAME_LABEL = ResourceHandler.RuntimeConnectionPage_Server_name__optional___10;
    private Text fServerNameText;
    private final String PORT_NUMBER_LABEL = ResourceHandler.RuntimeConnectionPage_Port_number__optional___11;
    private Text fPortNumber;
    private final String JNDI_NAME_LABLE = ResourceHandler.RuntimeConnectionPage_JNDI_name_12;
    private Text fDataSourceJNDIName;
    private final String SQL_VENDOR_NAME = ResourceHandler.RuntimeConnectionPage_DB_vendor_name__13;
    private Text fSQLVendorName;
    private final String DATA_BASE_NAME = ResourceHandler.RuntimeConnectionPage_Database_name__14;
    private Text fDatabaseName;
    private final String CLASS_LOCATION_LABEL = ResourceHandler.RuntimeConnectionPage_Class_Location__15;
    private Text fDriverManagerClassLocation;
    private final String DATA_BASE_LOCATION_LABEL = ResourceHandler.RuntimeConnectionPage_Database_location__optional___16;
    private Text fDatabaseLocation;
    private final String DATASOURCE_CLASS_LOCATION_LABEL = this.CLASS_LOCATION_LABEL;
    private Text fDataSourceClassLocationText;
    protected WizardPageStatus pageStatus = new WizardPageStatus();
    private Button fDriverManagerUseAutoDeployCheckboxButton;
    private String originalUserName = null;
    private String originalPassword = null;
    private String currentUserName = null;
    private String currentPassword = null;
    boolean areListenersAdded = false;
    private WebArtifactEdit fWebArtifactEdit;

    public RuntimeConnectionPage() {
        this(ResourceHandler.RuntimeConnectionWizard_runtime_connection);
    }

    public RuntimeConnectionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(ResourceHandler.RuntimeConnectionPage_enter_runtime_details);
    }

    public RuntimeConnectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(pageName);
    }

    protected void clearWizardPageStatusMessages() {
        this.pageStatus.clearAll();
    }

    private void createClassLocationControls() {
        this.fDriverManagerUseAutoDeployCheckboxButton = DialogUtil.createCheckBox(this.fDriverManagerComposite, this.USE_AUTO_DEPLOY_MSG);
        this.fDriverManagerUseAutoDeployCheckboxButton.setSelection(true);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = false;
        this.fDriverManagerUseAutoDeployCheckboxButton.setLayoutData((Object)data);
        this.fDriverManagerUseAutoDeployCheckboxButton.addListener(13, (Listener)this);
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, this.CLASS_LOCATION_LABEL);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        Composite classLocationComposite = DialogUtil.createComposite(this.fDriverManagerComposite, 2);
        data = new GridData(768);
        ((GridLayout)classLocationComposite.getLayout()).marginWidth = 0;
        ((GridLayout)classLocationComposite.getLayout()).marginHeight = 0;
        classLocationComposite.setLayoutData((Object)data);
        this.fDriverManagerClassLocation = DialogUtil.createTextField(classLocationComposite);
        this.fClassLocationSelectionButton = DialogUtil.createPushButton(classLocationComposite, "...");
        this.fDriverManagerClassLocation.addListener(24, (Listener)this);
        this.fClassLocationSelectionButton.addListener(13, (Listener)this);
    }

    private void createConnectionTypeChoices(Composite composite) {
        Label label = DialogUtil.createLabel(composite, ResourceHandler.RuntimeConnectionPage_runtime_of_two_types);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fUseDataSourceButton = DialogUtil.createRadioButton(composite, this.fUseDataSourceLabel);
        this.fUseDataSourceButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalSpan = 2;
        this.fUseDataSourceButton.setLayoutData((Object)data);
        this.fUseDriverManagerButton = DialogUtil.createRadioButton(composite, this.fUseDriverManagerLabel);
        this.fUseDriverManagerButton.addListener(13, (Listener)this);
        data = new GridData();
        data.horizontalSpan = 2;
        this.fUseDriverManagerButton.setLayoutData((Object)data);
    }

    public void createControl(Composite parent) {
        Composite composite = DialogUtil.createComposite(parent, 2);
        this.createConnectionTypeChoices(composite);
        this.fOptionsComposite = new Group(composite, 0);
        this.fStackLayout = new StackLayout();
        this.fOptionsComposite.setLayout((Layout)this.fStackLayout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 10;
        data.widthHint = 500;
        this.fOptionsComposite.setLayoutData((Object)data);
        this.fDataSourceComposite = DialogUtil.createComposite(this.fOptionsComposite, 2);
        this.fDriverManagerComposite = DialogUtil.createComposite(this.fOptionsComposite, 2);
        this.createDataSourceComposite();
        this.createDriverManagerComposite();
        this.fStackLayout.topControl = this.fDataSourceComposite;
        this.setControl((Control)composite);
        this.areListenersAdded = true;
    }

    private void createDataSourceComposite() {
        Label label = DialogUtil.createLabel(this.fDataSourceComposite, this.fDataSourceNameLabel);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        Composite nameComposite = DialogUtil.createComposite(this.fDataSourceComposite, 2);
        ((GridLayout)nameComposite.getLayout()).marginWidth = 0;
        ((GridLayout)nameComposite.getLayout()).marginHeight = 0;
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 0;
        nameComposite.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 0;
        this.fResourceRefNameText = DialogUtil.createText(nameComposite, 2060, data);
        this.fResourceRefBrowseButton = DialogUtil.createPushButton(nameComposite, "...");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        this.fResourceRefBrowseButton.setLayoutData((Object)data);
        data = new GridData();
        this.fResourceRefBrowseButton.setLayoutData((Object)data);
        this.fResourceRefBrowseButton.addListener(13, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.JNDI_NAME_LABLE);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 0;
        this.fDataSourceJNDIName = DialogUtil.createText(this.fDataSourceComposite, 2060, data);
        this.fRequiresUseridCheckbox = DialogUtil.createCheckBox(this.fDataSourceComposite, ResourceHandler.RuntimeConnectionPage_enter_datasource_details);
        ((GridData)this.fRequiresUseridCheckbox.getLayoutData()).horizontalSpan = 2;
        this.fRequiresUseridCheckbox.setSelection(true);
        this.fRequiresUseridCheckbox.addListener(13, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.fUserNameLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fDataSourceUserNameText = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fDataSourceUserNameText.addListener(24, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.fPasswordLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fDataSourcePasswordText = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fDataSourcePasswordText.setEchoChar('*');
        this.fDataSourcePasswordText.addListener(24, (Listener)this);
        this.fDataSourceUseAutoDeployCheckboxButton = DialogUtil.createCheckBox(this.fDataSourceComposite, this.USE_AUTO_DEPLOY_MSG);
        this.fDataSourceUseAutoDeployCheckboxButton.setSelection(true);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = false;
        this.fDataSourceUseAutoDeployCheckboxButton.setLayoutData((Object)data);
        this.fDataSourceUseAutoDeployCheckboxButton.addListener(13, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.SQL_VENDOR_NAME);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fSQLVendorName = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fSQLVendorName.setEditable(false);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.fDataSourceClassNameLabel);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fDataSourceClassNameCombo = DialogUtil.createCombo(this.fDataSourceComposite, 2048);
        this.fDataSourceClassNameCombo.setItems(IRdbTagConstants.KNOWN_DATA_SOURCES);
        this.fDataSourceClassNameCombo.addListener(24, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.DATA_BASE_NAME);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fDatabaseName = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fDatabaseName.addListener(24, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.DATASOURCE_CLASS_LOCATION_LABEL);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        Composite classLocationComposite = DialogUtil.createComposite(this.fDataSourceComposite, 2);
        data = new GridData(768);
        ((GridLayout)classLocationComposite.getLayout()).marginWidth = 0;
        ((GridLayout)classLocationComposite.getLayout()).marginHeight = 0;
        classLocationComposite.setLayoutData((Object)data);
        this.fDataSourceClassLocationText = DialogUtil.createTextField(classLocationComposite);
        this.fDataSourceClassLocationSelectionButton = DialogUtil.createPushButton(classLocationComposite, ResourceHandler.RuntimeConnectionPage_____20);
        this.fDataSourceClassLocationText.addListener(24, (Listener)this);
        this.fDataSourceClassLocationSelectionButton.addListener(13, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.DATA_BASE_LOCATION_LABEL);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fDatabaseLocation = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fDatabaseLocation.addListener(24, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.SERVER_NAME_LABEL);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fServerNameText = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fServerNameText.addListener(24, (Listener)this);
        label = DialogUtil.createLabel(this.fDataSourceComposite, this.PORT_NUMBER_LABEL);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalIndent = 20;
        label.setLayoutData((Object)data);
        this.fPortNumber = DialogUtil.createTextField(this.fDataSourceComposite);
        this.fPortNumber.addListener(24, (Listener)this);
    }

    private void createDriverManagerComposite() {
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, ResourceHandler.RuntimeConnectionPage_Driver_manager_connection_18);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createDriverNameControls();
        this.createURLControls();
        this.createUserNameControls();
        this.createPasswordControls();
        this.createClassLocationControls();
    }

    private void createDriverNameControls() {
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, this.fDriverNameLabel);
        ((GridData)label.getLayoutData()).horizontalIndent = 20;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fDriverNameText = DialogUtil.createTextField(this.fDriverManagerComposite);
        this.fDriverNameText.addListener(24, (Listener)this);
    }

    private void createPasswordControls() {
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, this.fPasswordLabel);
        ((GridData)label.getLayoutData()).horizontalIndent = 20;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fDriverPasswordText = DialogUtil.createTextField(this.fDriverManagerComposite);
        this.fDriverPasswordText.setEchoChar('*');
        this.fDriverPasswordText.addListener(24, (Listener)this);
    }

    private void createURLControls() {
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, this.fURLLabel);
        ((GridData)label.getLayoutData()).horizontalIndent = 20;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fURLText = DialogUtil.createTextField(this.fDriverManagerComposite);
        this.fURLText.addListener(24, (Listener)this);
    }

    private void createUserNameControls() {
        Label label = DialogUtil.createLabel(this.fDriverManagerComposite, this.fUserNameLabel);
        ((GridData)label.getLayoutData()).horizontalIndent = 20;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fDriverUserNameText = DialogUtil.createTextField(this.fDriverManagerComposite);
        this.fDriverUserNameText.addListener(24, (Listener)this);
    }

    protected void displayWizardPageStatusMessages() {
        if (this.pageStatus.isError()) {
            this.setMessage(this.pageStatus.getError().getMessage(), 3);
        } else if (this.pageStatus.isWarning()) {
            this.setMessage(this.pageStatus.getWarning().getMessage(), 2);
        } else if (this.pageStatus.getInformationList().size() > 0) {
            this.setMessage(this.pageStatus.getInformationList().get(0).toString(), 1);
        } else {
            this.setMessage(null);
        }
    }

    public void dispose() {
        if (this.fWebArtifactEdit != null) {
            this.fWebArtifactEdit.dispose();
        }
        super.dispose();
    }

    private void enableAutoDeployment(boolean checked) {
        this.fDatabaseLocation.setEnabled(checked);
        this.fDataSourceClassNameCombo.setEnabled(checked);
        this.fDatabaseName.setEnabled(checked);
        this.fDataSourceClassLocationText.setEnabled(checked);
        this.fDataSourceClassLocationSelectionButton.setEnabled(checked);
        this.fServerNameText.setEnabled(checked);
        this.fPortNumber.setEnabled(checked);
        this.fDriverManagerClassLocation.setEnabled(checked);
        this.fClassLocationSelectionButton.setEnabled(checked);
    }

    private void enableListeners(boolean enable) {
        if (this.fDriverNameText == null) {
            return;
        }
        if (!enable) {
            if (this.areListenersAdded) {
                this.fDriverNameText.removeListener(24, (Listener)this);
                this.fURLText.removeListener(24, (Listener)this);
                this.fDriverUserNameText.removeListener(24, (Listener)this);
                this.fDriverPasswordText.removeListener(24, (Listener)this);
                this.fDataSourceClassNameCombo.removeListener(24, (Listener)this);
                this.fDataSourcePasswordText.removeListener(24, (Listener)this);
                this.fDataSourceUserNameText.removeListener(24, (Listener)this);
                this.fServerNameText.removeListener(24, (Listener)this);
                this.fPortNumber.removeListener(24, (Listener)this);
                this.fDatabaseName.removeListener(24, (Listener)this);
                this.fDriverManagerClassLocation.removeListener(24, (Listener)this);
                this.fDataSourceClassLocationText.removeListener(24, (Listener)this);
                this.fDatabaseLocation.removeListener(24, (Listener)this);
                this.areListenersAdded = false;
            }
        } else if (!this.areListenersAdded) {
            this.fDriverNameText.addListener(24, (Listener)this);
            this.fURLText.addListener(24, (Listener)this);
            this.fDriverUserNameText.addListener(24, (Listener)this);
            this.fDriverPasswordText.addListener(24, (Listener)this);
            this.fDataSourceClassNameCombo.addListener(24, (Listener)this);
            this.fDataSourcePasswordText.addListener(24, (Listener)this);
            this.fDataSourceUserNameText.addListener(24, (Listener)this);
            this.fServerNameText.addListener(24, (Listener)this);
            this.fPortNumber.addListener(24, (Listener)this);
            this.fDatabaseName.addListener(24, (Listener)this);
            this.fDriverManagerClassLocation.addListener(24, (Listener)this);
            this.fDataSourceClassLocationText.addListener(24, (Listener)this);
            this.fDatabaseLocation.addListener(24, (Listener)this);
            this.areListenersAdded = true;
        }
    }

    public IConnectionData getConnectionData() {
        return ((IConnectionWizard)this.getWizard()).getConnectionData();
    }

    private String getCurrentPassword() {
        if (this.currentUserName == null) {
            this.currentUserName = this.originalUserName;
            this.currentPassword = this.originalPassword;
        }
        return this.currentPassword;
    }

    private String getCurrentUserName() {
        if (this.currentUserName == null) {
            this.currentUserName = this.originalUserName;
            this.currentPassword = this.originalPassword;
        }
        return this.currentUserName;
    }

    private IProject getProject() {
        return this.getConnectionData().getProject();
    }

    private void handleDataSourceJNDIName() {
        this.getConnectionData().setJNDIName(this.fDataSourceJNDIName.getText());
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this.fUseDataSourceButton || w == this.fUseDriverManagerButton) {
            this.handleRuntimeRadioButtonSelection();
        } else if (w == this.fResourceRefBrowseButton) {
            this.handleResourceRefButtonPressed();
        } else if (w == this.fRequiresUseridCheckbox) {
            this.handleRequiresUserIdPasswordCheckboxSelected();
        } else if (w == this.fDataSourceUseAutoDeployCheckboxButton || w == this.fDriverManagerUseAutoDeployCheckboxButton) {
            boolean checked;
            if (w == this.fDataSourceUseAutoDeployCheckboxButton) {
                checked = this.fDataSourceUseAutoDeployCheckboxButton.getSelection();
                this.fDriverManagerUseAutoDeployCheckboxButton.setSelection(checked);
            } else {
                checked = this.fDriverManagerUseAutoDeployCheckboxButton.getSelection();
                this.fDataSourceUseAutoDeployCheckboxButton.setSelection(checked);
            }
            if (!checked) {
                this.handleRemoveAutDeploy();
            }
            this.enableAutoDeployment(checked);
            this.getConnectionData().setAutoDeploy(checked);
        } else if (w == this.fClassLocationSelectionButton || w == this.fDataSourceClassLocationSelectionButton) {
            String result = "";
            FileDialog dialog = new FileDialog(this.getShell(), 2);
            dialog.setFilterExtensions(new String[]{"*.jar;*.zip", "*.*"});
            dialog.open();
            String path = dialog.getFilterPath();
            String[] files = dialog.getFileNames();
            if (files != null) {
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    result = String.valueOf(result) + (result.length() < 1 ? "" : ";") + path + File.separator + element;
                    ++n2;
                }
            }
            if (result != null && !result.equals("")) {
                this.fDriverManagerClassLocation.setText(result);
                this.fDataSourceClassLocationText.setText(result);
            }
        } else if (w instanceof Text) {
            this.textValueChanged((Text)w);
        } else if (w == this.fDataSourceClassNameCombo) {
            this.getConnectionData().setDataSourceClassName(this.fDataSourceClassNameCombo.getText());
        }
        this.setPageComplete(this.validatePage());
    }

    private void handleRemoveAutDeploy() {
        IConnectionData connectionData = this.getConnectionData();
        if (connectionData.isExistingConnection() && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ResourceHandler.RuntimeConnectionPage_0, (String)ResourceHandler.RuntimeConnectionPage_1)) {
            Connection connectionObject = connectionData.getConnectionObject();
            IProject proj = this.getProject();
            ConnectionControl.handleDelete(proj, connectionObject, false);
        }
    }

    private void handleRequiresUserIdPasswordCheckboxSelected() {
        boolean wereListenersAdded = this.areListenersAdded;
        if (wereListenersAdded) {
            this.enableListeners(false);
        }
        boolean checked = this.fRequiresUseridCheckbox.getSelection();
        this.fDataSourceUserNameText.setEnabled(checked);
        this.fDataSourcePasswordText.setEnabled(checked);
        if (checked) {
            if (this.getCurrentUserName() != null) {
                this.fDataSourceUserNameText.setText(this.getCurrentUserName());
            } else {
                this.fDataSourceUserNameText.setText("");
            }
            if (this.getCurrentPassword() != null) {
                this.fDataSourcePasswordText.setText(this.getCurrentPassword());
            } else {
                this.fDataSourcePasswordText.setText("");
            }
            this.getConnectionData().setUserName(this.getCurrentUserName());
            DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName(), this.getCurrentPassword());
        } else {
            this.fDataSourceUserNameText.setText("");
            this.fDataSourcePasswordText.setText("");
            this.getConnectionData().setUserName(null);
            this.getConnectionData().setPassword(null);
        }
        if (wereListenersAdded) {
            this.enableListeners(true);
        }
    }

    private void handleResourceRefButtonPressed() {
        ResourceRefSelectionDialog dialog = new ResourceRefSelectionDialog(this.getShell());
        ArrayList<String> filterTypes = new ArrayList<String>(1);
        filterTypes.add("javax.sql.DataSource");
        dialog.setTypeFilters(filterTypes);
        IProject currentProject = this.getProject();
        WebArtifactEdit nature = WebArtifactEdit.getWebArtifactEditForRead((IProject)currentProject);
        dialog.setWebArtifactEdit(nature);
        int result = dialog.open();
        ResourceRef ref = null;
        if (result != 0) {
            return;
        }
        ref = dialog.getResourceRef();
        boolean wereListenersAdded = this.areListenersAdded;
        if (wereListenersAdded) {
            this.enableListeners(false);
        }
        this.fResourceRefNameText.setText(ref != null ? ref.getName() : "");
        this.getConnectionData().setResourceRefName(this.fResourceRefNameText.getText());
        String defaultJNDIName = "";
        this.fDataSourceJNDIName.setText(defaultJNDIName);
        this.getConnectionData().setJNDIName(defaultJNDIName);
        this.handleResourceRefSelected(ref);
        if (wereListenersAdded) {
            this.enableListeners(true);
        }
    }

    private void handleResourceRefSelected(ResourceRef ref) {
    }

    private void handleResourceRefSelected(String resourceRefName) {
        ResourceRef ref = null;
        try {
            ref = WebAppUtil.findResourceRef(resourceRefName, this.getProject());
            if (ref != null) {
                this.handleResourceRefSelected(ref);
            } else {
                this.handleRequiresUserIdPasswordCheckboxSelected();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleRuntimeRadioButtonSelection() {
        this.fStackLayout.topControl = this.fUseDataSourceButton.getSelection() ? this.fDataSourceComposite : this.fDriverManagerComposite;
        this.fOptionsComposite.layout();
        boolean wereListenersAdded = this.areListenersAdded;
        if (wereListenersAdded) {
            this.enableListeners(false);
        }
        this.getConnectionData().setIsDriverManager(this.fUseDriverManagerButton.getSelection());
        if (this.fUseDriverManagerButton.getSelection()) {
            if (this.getCurrentUserName() != null) {
                this.fDriverUserNameText.setText(this.getCurrentUserName());
            } else {
                this.fDriverUserNameText.setText("");
            }
            if (this.getCurrentPassword() != null) {
                this.fDriverPasswordText.setText(this.getCurrentPassword());
            } else {
                this.fDriverPasswordText.setText("");
            }
            this.getConnectionData().setUserName(this.getCurrentUserName());
            DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName(), this.getCurrentPassword());
        } else if (this.fRequiresUseridCheckbox.getSelection()) {
            if (this.getCurrentUserName() != null) {
                this.fDataSourceUserNameText.setText(this.getCurrentUserName());
            } else {
                this.fDataSourceUserNameText.setText("");
            }
            if (this.getCurrentPassword() != null) {
                this.fDataSourcePasswordText.setText(this.getCurrentPassword());
            } else {
                this.fDataSourcePasswordText.setText("");
            }
            this.getConnectionData().setUserName(this.getCurrentUserName());
            DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName(), this.getCurrentPassword());
        } else {
            this.fDataSourceUserNameText.setText("");
            this.fDataSourcePasswordText.setText("");
            this.getConnectionData().setUserName(null);
            this.getConnectionData().setPassword(null);
        }
        if (wereListenersAdded) {
            this.enableListeners(true);
        }
    }

    public boolean isDataSourceNameModifed() {
        return this.wtDataSourceNameModifed;
    }

    public boolean isDriverNameModifed() {
        return this.wtDriverNameModifed;
    }

    public boolean isPageModified() {
        return this.wtPageSeen;
    }

    public boolean isPasswordModifed() {
        return this.wtPasswordModifed;
    }

    public boolean isURLModifed() {
        return this.wtURLModifed;
    }

    public boolean isUserNameModifed() {
        return this.wtUserNameModifed;
    }

    private void loadOriginalUserNamePassword() {
        String userName = this.getConnectionData().getUserName();
        String password = null;
        if (userName == null || userName.equals("")) {
            ConnectionInfo conInfo;
            if (this.getConnectionData().getRDBDatabase() != null && (conInfo = RSCConnectionsHelper.getConnectionInfoFromDatabase(this.getConnectionData().getRDBDatabase())) != null) {
                userName = conInfo.getUserName();
                password = conInfo.getPassword();
            }
        } else {
            password = DataAccessHelper.recvData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName());
        }
        this.originalUserName = userName;
        this.originalPassword = password;
    }

    public void populateConnectionInfo() {
        String driverName = "";
        String url = "";
        String userName = "";
        boolean wereListenersAdded = this.areListenersAdded;
        if (wereListenersAdded) {
            this.enableListeners(false);
        }
        if (this.getConnectionData().isDataSource()) {
            this.fUseDataSourceButton.setSelection(true);
        } else {
            this.fUseDriverManagerButton.setSelection(true);
        }
        driverName = this.getConnectionData().getDriver();
        userName = this.getConnectionData().getUserName();
        url = this.getConnectionData().getURL();
        this.loadOriginalUserNamePassword();
        if (!this.isDriverNameModifed() && this.fDriverNameText != null && driverName != null) {
            this.fDriverNameText.setText(driverName);
        }
        if (!this.isUserNameModifed() && !this.isPasswordModifed()) {
            boolean checked = userName != null && userName.length() > 0;
            this.fRequiresUseridCheckbox.setSelection(checked);
            this.fDataSourceUserNameText.setEnabled(checked);
            this.fDataSourcePasswordText.setEnabled(checked);
            this.handleRequiresUserIdPasswordCheckboxSelected();
        }
        if (!this.isURLModifed() && this.fURLText != null && url != null) {
            this.fURLText.setText(url);
        }
        if (!this.isDataSourceNameModifed() && this.fResourceRefNameText != null && this.getConnectionData().getResourceRefName() != null) {
            this.fResourceRefNameText.setText(this.getConnectionData().getResourceRefName());
            this.handleResourceRefSelected(this.getConnectionData().getResourceRefName());
        }
        if (this.fDataSourceUseAutoDeployCheckboxButton != null) {
            this.fDataSourceUseAutoDeployCheckboxButton.setSelection(this.getConnectionData().isAutoDeploy());
            this.fDriverManagerUseAutoDeployCheckboxButton.setSelection(this.fDataSourceUseAutoDeployCheckboxButton.getSelection());
            this.enableAutoDeployment(this.fDataSourceUseAutoDeployCheckboxButton.getSelection());
        }
        this.fDatabaseName.setText(this.getConnectionData().getDatabaseName());
        if (this.getConnectionData().getServerName() != null) {
            this.fServerNameText.setText(this.getConnectionData().getServerName());
        }
        if (this.getConnectionData().getPortNumber() > 0) {
            this.fPortNumber.setText("" + this.getConnectionData().getPortNumber());
        } else {
            this.fPortNumber.setText("");
        }
        if (this.getConnectionData().getSQLVendorType() != null) {
            int intType = this.getConnectionData().getSQLVendorType().getValue();
            RSCSQLVendorType type = RSCSQLVendorType.get(intType);
            this.fSQLVendorName.setText(type.getProductName());
        }
        if (this.getConnectionData().getJNDIName() != null) {
            this.fDataSourceJNDIName.setText(this.getConnectionData().getJNDIName());
        }
        if (this.getConnectionData().getDatabaseLocation() != null) {
            this.fDatabaseLocation.setText(this.getConnectionData().getDatabaseLocation());
        }
        if (this.getConnectionData().getClassLocation() != null) {
            this.fDataSourceClassLocationText.setText(this.getConnectionData().getClassLocation());
        }
        if (this.getConnectionData().getClassLocation() != null) {
            this.fDriverManagerClassLocation.setText(this.getConnectionData().getClassLocation());
        }
        if (this.getConnectionData().getDataSourceClassName() != null) {
            this.fDataSourceClassNameCombo.setText(this.getConnectionData().getDataSourceClassName());
        }
        if (!(WebAppUtil.isWebProject(this.getConnectionData().getProject()) || WebAppUtil.isEJBProject(this.getConnectionData().getProject()) || WebAppUtil.isUtilityProject(this.getConnectionData().getProject()))) {
            this.fResourceRefBrowseButton.setEnabled(false);
        }
        this.handleRuntimeRadioButtonSelection();
        if (wereListenersAdded) {
            this.enableListeners(true);
        }
    }

    private void setCurrentPassword(String password) {
        this.currentPassword = password;
    }

    private void setCurrentUserName(String string) {
        this.currentUserName = string;
    }

    public void setPageModified(boolean newPageSeen) {
        this.wtPageSeen = newPageSeen;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.populateConnectionInfo();
        }
    }

    public void textValueChanged(Text source) {
        boolean wereListenersAdded = this.areListenersAdded;
        if (wereListenersAdded) {
            this.enableListeners(false);
        }
        if (source == this.fResourceRefNameText) {
            if (!this.fResourceRefNameText.getText().equals(this.getConnectionData().getResourceRefName())) {
                this.getConnectionData().setResourceRefName(this.fResourceRefNameText.getText());
                this.getConnectionData().setConnectionId(this.fResourceRefNameText.getText());
                this.handleResourceRefSelected(this.getConnectionData().getResourceRefName());
                this.wtDataSourceNameModifed = true;
            }
        } else if (source == this.fDriverNameText) {
            this.getConnectionData().setDriver(this.fDriverNameText.getText());
            this.wtDriverNameModifed = true;
        } else if (source == this.fURLText) {
            this.getConnectionData().setURL(this.fURLText.getText());
            this.wtURLModifed = true;
        } else if (source == this.fDriverUserNameText) {
            this.getConnectionData().setUserName(this.fDriverUserNameText.getText());
            this.setCurrentUserName(this.fDriverUserNameText.getText());
            this.wtUserNameModifed = true;
        } else if (source == this.fDriverPasswordText) {
            String password = this.fDriverPasswordText.getText();
            DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName(), password);
            this.setCurrentPassword(password);
            this.wtPasswordModifed = true;
        } else if (source == this.fDriverManagerClassLocation) {
            this.getConnectionData().setClassLocation(this.fDriverManagerClassLocation.getText());
        } else if (source == this.fDatabaseName) {
            this.getConnectionData().setDatabaseName(this.fDatabaseName.getText());
        } else if (source == this.fDataSourceJNDIName) {
            this.handleDataSourceJNDIName();
        } else {
            if (this.fRequiresUseridCheckbox.getSelection()) {
                if (source == this.fDataSourceUserNameText) {
                    this.getConnectionData().setUserName(this.fDataSourceUserNameText.getText());
                    this.setCurrentUserName(this.fDataSourceUserNameText.getText());
                    this.wtUserNameModifed = true;
                } else if (source == this.fDataSourcePasswordText) {
                    String password = this.fDataSourcePasswordText.getText();
                    DataAccessHelper.sendData(RSCConnectionsHelper.getRealm(this.getConnectionData()), this.getConnectionData().getUserName(), password);
                    this.setCurrentPassword(password);
                    this.wtPasswordModifed = true;
                }
            }
            if (this.fDataSourceUseAutoDeployCheckboxButton.getSelection()) {
                if (source == this.fDatabaseLocation) {
                    this.getConnectionData().setDatabaseLocation(this.fDatabaseLocation.getText());
                } else if (source == this.fPortNumber) {
                    try {
                        int portNum = Integer.parseInt(this.fPortNumber.getText());
                        if (portNum <= 0) {
                            throw new NumberFormatException();
                        }
                        this.getConnectionData().setPortNumber(portNum);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.getConnectionData().setPortNumber(-1);
                    }
                } else if (source == this.fServerNameText) {
                    this.getConnectionData().setServerName(this.fServerNameText.getText());
                } else if (source != this.fSQLVendorName && source == this.fDataSourceClassLocationText) {
                    this.getConnectionData().setClassLocation(this.fDataSourceClassLocationText.getText());
                }
            }
        }
        if (wereListenersAdded) {
            this.enableListeners(true);
        }
    }

    protected boolean validatePage() {
        this.clearWizardPageStatusMessages();
        boolean ret = this.whyIsPageNotComplete();
        this.displayWizardPageStatusMessages();
        return ret;
    }

    public boolean whyIsPageNotComplete() {
        boolean ret = true;
        this.pageStatus.clearAll();
        if (this.fDriverPasswordText == null) {
            ret = false;
        } else if (this.fUseDriverManagerButton.getSelection()) {
            if (this.fURLText.getText() == "") {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.URL_can_not_be_null_16);
            }
            if (this.fDriverNameText.getText() == "") {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.Driver_name_can_not_be_null_17);
            } else if (this.fDriverManagerClassLocation.getText() == "") {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.RuntimeConnectionPage_Database_driver_not_be_null_12);
            }
        } else if (this.fUseDataSourceButton.getSelection()) {
            if (this.fResourceRefNameText.getText() == "") {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.Data_Source_name_can_not_be_null_18);
            } else if (this.fDataSourceClassNameCombo.getText() == null || this.fDataSourceClassNameCombo.getText().trim().length() == 0) {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.RuntimeConnectionPage_Data_Source_not_be_null_13);
            } else if (this.fDatabaseName.getText() == null || this.fDatabaseName.getText().trim().length() == 0) {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.RuntimeConnectionPage_Database_name_not_be_null_14);
            } else if (this.fDataSourceClassLocationText.getText() == null || this.fDataSourceClassLocationText.getText().trim().length() == 0) {
                ret = false;
                this.pageStatus.addErrorMessage(ResourceHandler.RuntimeConnectionPage_Database_driver_location_not_be_null_15);
            } else if (this.fPortNumber.isEnabled() && this.fPortNumber.getText() != null && !this.fPortNumber.getText().equals("")) {
                try {
                    int portNum = Integer.parseInt(this.fPortNumber.getText());
                    if (portNum <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.pageStatus.addErrorMessage(ResourceHandler.RuntimeConnectionPage_Port_Invalid);
                }
            }
        }
        if (RSCConnectionsHelper.needsJ2CCJar(this.getConnectionData()) && !RSCConnectionsHelper.hasJ2CCJar(this.getConnectionData())) {
            ret = false;
            this.pageStatus.addErrorMessage(ResourceHandler.ConnectionPage_db2jcc_error);
        }
        if (ret) {
            this.setErrorMessage(null);
        }
        return ret;
    }
}

