/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sdo.jdbc.ui.internal;

import com.ibm.etools.sdo.jdbc.ui.internal.RuntimeConnectionWizard;
import com.ibm.etools.sdo.jdbc.ui.internal.actions.ConnectionOperation;
import com.ibm.etools.sdo.jdbc.ui.internal.data.ConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionData;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IConnectionHandler;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionObserverConstants;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsHelper;
import com.ibm.etools.sdo.jdbc.ui.internal.util.ConnectionsUIUtil;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.jdbc.ui.provisional.connections.Connection;
import com.ibm.etools.webtools.deploy.jdbc.internal.DeployJDBCPlugin;
import com.ibm.etools.webtools.deploy.jdbc.internal.nls.ResourceHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ConnectionControl
implements Listener,
ConnectionObserverConstants {
    private boolean fIncludeRuntimeConnectionPage = true;
    private Listener fListener;
    private MyObservable fMyObservable = new MyObservable();
    private IProject fProject;
    private IConnectionData fConnectionData;
    public Button fNewConnButton;
    public Button fDeleteButton;
    private boolean fShowDelete = false;
    private Hyperlink fConfigureConnections;
    private boolean fShowConfigureConnections = true;
    public Combo fConnIdCombo;
    private IProgressMonitor fMonitor;
    private boolean fAutoConnect = true;

    public static void handleDelete(IProject project, Connection connection, boolean removeWebDeploymentReferences) {
        String name = DeployJDBCPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(name, "ConnectionHandler");
        IConfigurationElement[] configElements = extPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configEl = configElements[i];
            Object obj = null;
            try {
                obj = configEl.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (obj instanceof IConnectionHandler) {
                ((IConnectionHandler)obj).handleDelete(project, connection, removeWebDeploymentReferences);
            }
            ++i;
        }
    }

    public void addObserver(Observer observer) {
        this.getObservable().addObserver(observer);
    }

    private void createConnSelectionComposite(Composite parent) {
        this.createConnSelectionComposite(parent, true);
    }

    private void createConnSelectionComposite(Composite parent, boolean createParent) {
        Composite connComposite = null;
        GridData data = null;
        if (createParent) {
            connComposite = DialogUtil.createComposite(parent, 3);
            ((GridLayout)connComposite.getLayout()).marginWidth = 0;
            data = new GridData(768);
            connComposite.setLayoutData((Object)data);
        } else {
            connComposite = parent;
        }
        Label lb1 = DialogUtil.createLabel(connComposite, ResourceHandler.ConnectionControl_Connection_name___1);
        data = new GridData(4);
        lb1.setLayoutData((Object)data);
        this.fConnIdCombo = DialogUtil.createCombo(connComposite, 2056);
        data = new GridData(772);
        this.fConnIdCombo.setLayoutData((Object)data);
        Composite buttonComposite = DialogUtil.createComposite(connComposite, 1);
        ((GridLayout)buttonComposite.getLayout()).marginWidth = 0;
        data = new GridData(132);
        buttonComposite.setLayoutData((Object)data);
        this.fNewConnButton = DialogUtil.createPushButton(buttonComposite, ResourceHandler.ConnectionControl_New____2);
        data = new GridData(768);
        this.fNewConnButton.setLayoutData((Object)data);
        if (this.isShowDelete()) {
            this.fDeleteButton = DialogUtil.createPushButton(buttonComposite, ResourceHandler.ConnectionControl_0);
            data = new GridData(768);
            this.fNewConnButton.setLayoutData((Object)data);
            this.fDeleteButton.addListener(13, this.getListener());
            this.fDeleteButton.setEnabled(false);
        }
        if (this.isShowConfigureConnections()) {
            Composite prefComposite = DialogUtil.createComposite(connComposite, 1);
            ((GridLayout)prefComposite.getLayout()).marginWidth = 0;
            ((GridLayout)prefComposite.getLayout()).marginHeight = 0;
            ((GridData)prefComposite.getLayoutData()).horizontalSpan = 3;
            this.fConfigureConnections = DialogUtil.createHyperLink(prefComposite, ResourceHandler.ConnectionControl_1);
            this.fConfigureConnections.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    PreferenceDialog pd = PreferencesUtil.createPropertyDialogOn((Shell)ConnectionControl.this.fConfigureConnections.getShell(), (IAdaptable)ConnectionControl.this.getProject(), (String)"com.ibm.etools.sdo.jdbc.ui.propertypages.JDBCConnectionsPropertyPage", (String[])new String[0], (Object)ConnectionControl.this.getConnectionData());
                    pd.open();
                    ConnectionControl.this.updateConnectionIdCombo();
                    ConnectionControl.this.notifyObservers("handleConnIdComboSelection");
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
            this.fConfigureConnections.setEnabled(true);
        }
        this.fConnIdCombo.addListener(13, this.getListener());
        this.fNewConnButton.addListener(13, this.getListener());
    }

    public void createControl(Composite parent) {
        this.createConnSelectionComposite(parent);
    }

    public IConnectionData getConnectionData() {
        if (this.fConnectionData == null) {
            this.fConnectionData = new ConnectionData();
            this.fConnectionData.setProject(this.getProject());
        }
        return this.fConnectionData;
    }

    private Listener getListener() {
        if (this.fListener == null) {
            return this;
        }
        return this.fListener;
    }

    private MyObservable getObservable() {
        return this.fMyObservable;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void handleChangeDevConn() {
        if (this.getConnectionData() == null) {
            return;
        }
        Shell shell = this.fNewConnButton.getShell();
        ConnectionsUIUtil.updateConnection(this.getProject(), shell, this.getConnectionData());
    }

    public void handleChangeRuntimeConn() {
        RuntimeConnectionWizard wiz = new RuntimeConnectionWizard();
        ConnectionData clonedConnectionData = (ConnectionData)this.getConnectionData().clone();
        wiz.setConnectionData(clonedConnectionData);
        Shell shell = this.fNewConnButton.getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wiz);
        dialog.create();
        if (dialog.open() == 0) {
            shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
            Connection connection = wiz.getConnectionData().getConnectionObject();
            ConnectionOperation op = new ConnectionOperation(wiz.getConnectionData().getProject(), connection, shell);
            int op_code = 1;
            if (!this.getConnectionData().getConnectionId().equals(clonedConnectionData.getConnectionId())) {
                try {
                    if (!ConnectionsHelper.isConnectionExist(this.getProject(), clonedConnectionData.getConnectionId())) {
                        op_code = 0;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            op.setOperationCode(op_code);
            try {
                try {
                    op.run((IProgressMonitor)new NullProgressMonitor());
                    this.setConnectionData(wiz.getConnectionData());
                    this.notifyObservers("handleChangeRuntimeConn");
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
                }
            }
            finally {
                shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
            }
        }
    }

    public void handleConnIdComboSelection() {
        int selIndex = this.fConnIdCombo.getSelectionIndex();
        if (selIndex != -1) {
            String connId = this.fConnIdCombo.getItem(selIndex);
            this.setDeleteButtonEnable(true);
            try {
                Connection connection = ConnectionsHelper.getConnection(this.getProject(), connId);
                this.getConnectionData().setConnectionObject(connection);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.notifyObservers("handleConnIdComboSelection");
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.fNewConnButton) {
            this.handleNewConnection();
        } else if (widget == this.fConnIdCombo) {
            this.handleConnIdComboSelection();
        } else if (this.isShowDelete() && widget == this.fDeleteButton && this.fConnIdCombo.getText() != null) {
            String id = this.fConnIdCombo.getText();
            try {
                IProject proj = this.getProject();
                Connection connection = ConnectionsHelper.getConnection(proj, id);
                if (connection != null) {
                    Shell shell = null;
                    if (this.fNewConnButton != null) {
                        shell = this.fNewConnButton.getShell();
                    }
                    ConnectionControl.handleDelete(proj, connection, true);
                    ConnectionsHelper.removeConnection(proj, connection, shell);
                    this.getConnectionData().setConnectionId(null);
                    this.updateConnectionIdCombo();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.notifyObservers("handleConnIdRemoved");
        }
    }

    public void handleNewConnection() {
        Shell shell = this.fNewConnButton.getShell();
        IConnectionData connectionData = ConnectionsUIUtil.createNewConnection(this.getProject(), shell);
        if (connectionData != null) {
            this.setConnectionData(connectionData);
            this.updateConnectionIdCombo();
            this.notifyObservers("handleNewConnection");
        }
    }

    public boolean isAutoConnect() {
        return this.fAutoConnect;
    }

    public boolean isIncludeRuntimeConnectionPage() {
        return this.fIncludeRuntimeConnectionPage;
    }

    private final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    protected boolean isShowConfigureConnections() {
        return this.fShowConfigureConnections;
    }

    protected boolean isShowDelete() {
        return this.fShowDelete;
    }

    public void notifyObservers(Object arg) {
        this.getObservable().dirty();
        this.getObservable().notifyObservers(arg);
    }

    public void setAutoConnect(boolean autoConnect) {
        this.fAutoConnect = autoConnect;
    }

    public void setConnectionData(IConnectionData connectionData) {
        this.fConnectionData = connectionData;
    }

    public void setDeleteButtonEnable(boolean enabled) {
        if (this.isShowDelete() && this.isOkToUse((Control)this.fDeleteButton)) {
            this.fDeleteButton.setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.isOkToUse((Control)this.fNewConnButton)) {
            this.fNewConnButton.setEnabled(enabled);
        }
        if (this.isOkToUse((Control)this.fDeleteButton)) {
            this.fDeleteButton.setEnabled(enabled);
        }
        if (this.isOkToUse((Control)this.fConfigureConnections)) {
            this.fConfigureConnections.setEnabled(enabled);
        }
        if (this.isOkToUse((Control)this.fConnIdCombo)) {
            this.fConnIdCombo.setEnabled(enabled);
        }
    }

    public void setIncludeRuntimeConnectionPage(boolean b) {
        this.fIncludeRuntimeConnectionPage = b;
    }

    public void setListener(Listener listener) {
        this.fListener = listener;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fMonitor = progressMonitor;
    }

    public void setProject(IProject project) {
        this.fProject = project;
        this.getConnectionData().setProject(this.fProject);
    }

    public void setShowConfigureConnections(boolean showConfigureConnections) {
        this.fShowConfigureConnections = showConfigureConnections;
    }

    public void setShowDelete(boolean showDelete) {
        this.fShowDelete = showDelete;
    }

    public void updateConnectionIdCombo() {
        this.fConnIdCombo.removeAll();
        int i = 0;
        int selIndex = -1;
        String connId = this.getConnectionData().getConnectionId();
        this.setDeleteButtonEnable(false);
        this.getConnectionData().setReconnect(false);
        for (Connection connection : ConnectionData.getConnections(this.getProject())) {
            if (connection.getId() != null) {
                this.fConnIdCombo.add(connection.getId());
                if (connection.getId().equals(connId)) {
                    selIndex = i;
                }
            }
            ++i;
        }
        if (selIndex != -1) {
            this.fConnIdCombo.select(selIndex);
            this.setDeleteButtonEnable(true);
            this.notifyObservers("updateConnectionIdCombo");
            this.handleConnIdComboSelection();
        } else if (this.isAutoConnect()) {
            if (this.fConnIdCombo.getItemCount() > 0) {
                int connCount = this.fConnIdCombo.getItemCount();
                do {
                    this.fConnIdCombo.select(--connCount);
                    this.handleConnIdComboSelection();
                } while (connCount > 0 && this.getConnectionData().getRDBDatabase(false) == null);
                if (this.getConnectionData().getRDBDatabase(false) != null) {
                    this.setDeleteButtonEnable(true);
                }
            } else {
                this.notifyObservers("updateConnectionIdCombo");
            }
        } else if (this.fConnIdCombo.getItemCount() > 0) {
            boolean found = false;
            int connCount = this.fConnIdCombo.getItemCount();
            int j = connCount - 1;
            while (j >= 0) {
                this.fConnIdCombo.select(j);
                this.handleConnIdComboSelection();
                if (this.getConnectionData().getConnectionProfile() != null && this.getConnectionData().getConnectionProfile().getConnectionState() == 1) {
                    this.setDeleteButtonEnable(true);
                    found = true;
                    break;
                }
                --j;
            }
            if (!found) {
                this.fConnIdCombo.select(connCount - 1);
                this.handleConnIdComboSelection();
                this.setDeleteButtonEnable(true);
            }
        }
        this.getConnectionData().setReconnect(true);
    }

    public void updateConnectionIdDisplay() {
        String connId = this.getConnectionData().getConnectionId();
        if (connId != null && !connId.equals(this.fConnIdCombo.getText())) {
            if (this.fConnIdCombo.indexOf(connId) == -1) {
                this.fConnIdCombo.add(connId);
            }
            if (this.isAutoConnect()) {
                this.fConnIdCombo.setText(connId);
            }
        }
    }

    private class MyObservable
    extends Observable {
        private MyObservable() {
        }

        public void dirty() {
            this.setChanged();
        }
    }
}

