/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data.nodes;

import com.ibm.etools.webtools.codebehind.pdm.data.CBPageDataNodeFactory;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBActionPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBMethodPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.util.DocletParser;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CBMethodNodePopulateTask
extends AbstractJavaModelTask {
    private IPageDataModel pdModel;
    private IMethod cbMethod;
    private CBMethodPageDataNode pdNode;

    public CBMethodNodePopulateTask(IPageDataModel model, IMethod cbMethod, CBMethodPageDataNode pdNode) {
        this.pdModel = model;
        this.cbMethod = cbMethod;
        this.pdNode = pdNode;
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        String paramBeanId = (String)this.pdNode.getInfoMap().get("paramBean");
        String resultBeanId = (String)this.pdNode.getInfoMap().get("resultBean");
        String actionId = (String)this.pdNode.getInfoMap().get("action");
        IType type = (IType)this.cbMethod.getParent();
        boolean createdParamNode = false;
        boolean createdResultNode = false;
        boolean createdActionNode = false;
        int i = 0;
        while (i < type.getMethods().length) {
            Object idTag;
            Map parsedValues;
            DocletParser dparser;
            IMethod method = type.getMethods()[i];
            ReadMethodCommand readCmd = new ReadMethodCommand();
            readCmd.setIdentifier(method.getElementName());
            readCmd.setParameterNames(method.getParameterNames());
            readCmd.setParameters(method.getParameterTypes());
            readCmd.execute(model, monitor);
            JavaDocInfo jdInfo = readCmd.getJavadoc();
            if (jdInfo.getCommentForTag("paramBean") != null) {
                dparser = new DocletParser(jdInfo.getCommentForTag("paramBean"));
                parsedValues = dparser.parse();
                idTag = parsedValues.get("id");
                if (idTag != null && idTag.equals(paramBeanId)) {
                    CBPageDataNodeFactory.getInstance().getCreateAndAddNodeCommand(this.pdModel, method, this.pdNode).execute(model, monitor);
                    createdParamNode = true;
                }
            } else if (jdInfo.getCommentForTag("resultBean") != null) {
                dparser = new DocletParser(jdInfo.getCommentForTag("resultBean"));
                parsedValues = dparser.parse();
                idTag = parsedValues.get("id");
                if (idTag != null && idTag.equals(resultBeanId)) {
                    CBPageDataNodeFactory.getInstance().getCreateAndAddNodeCommand(this.pdModel, method, this.pdNode).execute(model, monitor);
                    createdResultNode = true;
                }
            } else if (jdInfo.getCommentForTag("action") != null && (idTag = (parsedValues = (dparser = new DocletParser(jdInfo.getCommentForTag("action"))).parse()).get("id")) != null && idTag.equals(actionId)) {
                this.pdNode.addChildWithoutNotification(new CBActionPageDataNode(this.pdModel, this.pdNode, method, this.pdNode.getCodeBehindName()));
                createdActionNode = true;
            }
            if (createdActionNode && createdParamNode && createdResultNode) break;
            ++i;
        }
    }

    public String getDisplayName() {
        return "CBMethodNodePopulateTask";
    }
}

