/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.pdm.data.CBPageDataNodeFactory;
import com.ibm.etools.webtools.codebehind.pdm.data.CBtoDataSynchronizer;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNode;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class SyncPageCodeMethodsToPageDataTask
extends AbstractJavaModelTask {
    private IPageDataModel fPdModel;
    private List fMethodDeltas;

    public SyncPageCodeMethodsToPageDataTask(IPageDataModel pdModel, List methodDeltas) {
        this.fPdModel = pdModel;
        this.setMethodDeltas(methodDeltas);
    }

    private boolean containsOpposite(List methodDeltas, CBtoDataSynchronizer.MethodDelta methoddelta) {
        for (CBtoDataSynchronizer.MethodDelta mDelta : methodDeltas) {
            if (!mDelta.method.getElementName().equals(methoddelta.method.getElementName())) continue;
            if (methoddelta.kind == 1 && mDelta.kind == 2) {
                return true;
            }
            if (methoddelta.kind != 2 || mDelta.kind != 1) continue;
            return true;
        }
        return false;
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        CBPageDataNodeFactory factory = CBPageDataNodeFactory.getInstance();
        List methodDeltas = this.getMethodDeltas();
        monitor.beginTask(null, methodDeltas.size());
        JavaCodeUtil.clearResolvedTypesCache();
        FacesConfigArtifactEdit edit = null;
        try {
            if (JsfProjectUtil.isJsfProject((IProject)model.getProject())) {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)model.getProject(), (String)"WEB-INF/faces-config.xml");
            }
            for (CBtoDataSynchronizer.MethodDelta methoddelta : methodDeltas) {
                if (methoddelta.kind == 1) {
                    if (!this.containsOpposite(methodDeltas, methoddelta)) {
                        monitor.subTask(Messages.SyncPageCodeMethodsToPageDataTask_0);
                        JavaCommand cmd = factory.getCreateAndAddNodeCommand(this.fPdModel, methoddelta.method, this.fPdModel.getRoot());
                        cmd.execute(model, monitor);
                    } else {
                        monitor.subTask(Messages.SyncPageCodeMethodsToPageDataTask_1);
                        this.refreshPDNForMethod(methoddelta.method, this.fPdModel);
                    }
                } else if (methoddelta.kind == 2) {
                    if (!this.containsOpposite(methodDeltas, methoddelta)) {
                        monitor.subTask(Messages.SyncPageCodeMethodsToPageDataTask_2);
                        this.removedMethod(this.fPdModel, (IJavaElement)methoddelta.method);
                    } else {
                        monitor.subTask(Messages.SyncPageCodeMethodsToPageDataTask_3);
                        this.refreshPDNForMethod(methoddelta.method, this.fPdModel);
                    }
                }
                monitor.worked(1);
            }
        }
        finally {
            JavaCodeUtil.clearResolvedTypesCache();
            if (edit != null) {
                edit.dispose();
            }
        }
        monitor.done();
    }

    public Object getAdapter(Class adapter) {
        Object o = super.getAdapter(adapter);
        if (o == null && adapter == SyncPageCodeMethodsToPageDataTask.class) {
            o = this;
        }
        return o;
    }

    public String getDisplayName() {
        return Messages.CBtoDataSynchronizer_0;
    }

    public List getMethodDeltas() {
        return this.fMethodDeltas;
    }

    public IPageDataModel getPageDataModel() {
        return this.fPdModel;
    }

    public boolean isSystem() {
        return false;
    }

    private void refreshPDNForMethod(IMethod method, IPageDataModel pdModel) {
        EList childNodes = pdModel.getRoot().getChildren();
        for (IPageDataNode pdNode : childNodes) {
            ICBDataNode cbNode;
            if (!(pdNode instanceof ICBDataNode) || (cbNode = (ICBDataNode)pdNode).getCodeBehindMethod() != method) continue;
            cbNode.refresh(method);
        }
    }

    private void removedMethod(IPageDataModel pdModel, IJavaElement element) {
        IMethod removedMethod = (IMethod)element;
        EList rootChildren = pdModel.getRoot().getChildren();
        ArrayList<ICBDataNode> toBeRemoved = new ArrayList<ICBDataNode>();
        for (IPageDataNode iPageDataNode : rootChildren) {
            ICBDataNode cbJbNode;
            IMethod codeBehindMethod;
            if (!(iPageDataNode instanceof ICBDataNode) || (codeBehindMethod = (cbJbNode = (ICBDataNode)iPageDataNode).getCodeBehindMethod()) == null || !codeBehindMethod.getElementName().equals(removedMethod.getElementName())) continue;
            if (!codeBehindMethod.exists()) {
                toBeRemoved.add(cbJbNode);
                continue;
            }
            boolean isPublic = true;
            boolean isvoid = false;
            try {
                isPublic = Flags.isPublic((int)codeBehindMethod.getFlags());
                String returnType = JavaCodeUtil.getResolvedReturnType((IMethod)removedMethod);
                if (returnType != null) {
                    isvoid = returnType.equals("void");
                }
            }
            catch (Exception exception) {}
            if (isPublic && !isvoid) continue;
            toBeRemoved.add(cbJbNode);
        }
        for (IPageDataNode iPageDataNode : toBeRemoved) {
            pdModel.getRoot().removeChild(iPageDataNode);
        }
    }

    public void setMethodDeltas(List methodDeltas) {
        this.fMethodDeltas = methodDeltas;
    }

    public void setPageDataModel(IPageDataModel pdModel) {
        this.fPdModel = pdModel;
    }
}

