/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ILanguageChangeListener;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.SyncAllPageCodeMethodsToPageDataTask;
import com.ibm.etools.webtools.codebehind.pdm.data.SyncPageCodeMethodsToPageDataTask;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBJavaBeanPageDataNode;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class CBtoDataSynchronizer
implements IElementChangedListener,
ILanguageChangeListener {
    private boolean listenerActive = false;
    private List notifyList;

    public synchronized void connect(IPageDataModel notifiee) {
        IDOMDocument doc;
        ICBLanguage cbLanguage;
        if (notifiee == null) {
            return;
        }
        if (!this.listenerActive) {
            this.makeActive();
        }
        if (this.notifyList == null) {
            this.notifyList = new ArrayList(1);
        }
        this.notifyList.add(notifiee);
        IDOMModel domModel = ((PageDataModel)notifiee).getIDOMModel();
        if (domModel != null && (cbLanguage = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)(doc = domModel.getDocument()))) != null) {
            cbLanguage.addLanguageChangeListener((ILanguageChangeListener)this);
        }
    }

    protected Job createElementChangedJob(final ElementChangedEvent event) {
        Job elementChangedJob = new Job("CBtoDataSynchronizer.handleElementChangedJob"){

            public IStatus run(IProgressMonitor monitor) {
                CBtoDataSynchronizer.this.handleElementChanged(event);
                return Status.OK_STATUS;
            }
        };
        return elementChangedJob;
    }

    public synchronized void disconnect(IPageDataModel notifiee) {
        Job[] canceableJobs;
        if (notifiee == null) {
            return;
        }
        Job[] jobArray = canceableJobs = Job.getJobManager().find(CodeBehindCoreUtil.CODE_BEHIND_CANCELEABLE_JOB_FAMILY);
        int n = canceableJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            SyncPageCodeMethodsToPageDataTask task = (SyncPageCodeMethodsToPageDataTask)((Object)job.getAdapter(SyncPageCodeMethodsToPageDataTask.class));
            if (task != null && notifiee == task.getPageDataModel()) {
                job.cancel();
            }
            ++n2;
        }
        if (this.notifyList != null) {
            this.notifyList.remove(notifiee);
            IDOMModel domModel = ((PageDataModel)notifiee).getIDOMModel();
            if (domModel != null) {
                IDOMDocument doc = domModel.getDocument();
                ICBLanguage cbLanguage = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)doc);
                if (cbLanguage != null) {
                    cbLanguage.removeLanguageChangeListener((ILanguageChangeListener)this);
                }
                if (this.notifyList.isEmpty()) {
                    this.notifyList = null;
                    this.makeInactive();
                }
            }
        }
    }

    protected boolean doTypesMatch(ICompilationUnit cu, IPath cbLocation) {
        IPath path = cu.getPath();
        path = path.removeFirstSegments(1).makeAbsolute();
        return cbLocation.equals((Object)path);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!PageDataModelAdapter.isSyncInitialization()) {
            Job elementChangedJob = this.createElementChangedJob(event);
            elementChangedJob.setSystem(true);
            elementChangedJob.schedule();
        } else {
            this.handleElementChanged(event);
        }
    }

    public synchronized void handleElementChanged(ElementChangedEvent event) {
        IJavaElementDelta jDelta = event.getDelta();
        if (jDelta == null) {
            return;
        }
        if (this.notifyList == null) {
            return;
        }
        Iterator beanItr = this.notifyList.iterator();
        while (beanItr.hasNext()) {
            PageDataModel pdModel = (PageDataModel)beanItr.next();
            IDOMDocument xmlDoc = pdModel.getIDOMModel().getDocument();
            if (xmlDoc != null && pdModel.getResource() != null) {
                if (!JsfComponentUtil.isJsfPage((Document)xmlDoc)) continue;
                ICBLanguage cbLanguage = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
                CBLanguageInfo cbInfo = cbLanguage.getCBInfo();
                if (!cbInfo.language.equalsIgnoreCase("java")) continue;
                this.visit((IPageDataModel)pdModel, jDelta, cbInfo);
                continue;
            }
            beanItr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void languageChanged(IDOMDocument document, int type, String newLanguage, IPath newLocation) {
        block9: {
            IFile file;
            ArrayList localNotifyList;
            block8: {
                localNotifyList = new ArrayList();
                CBtoDataSynchronizer cBtoDataSynchronizer = this;
                synchronized (cBtoDataSynchronizer) {
                    localNotifyList.addAll(this.notifyList);
                }
                if (newLanguage.equalsIgnoreCase("java")) break block8;
                file = CodeBehindUtil.getFileForPage((IDOMDocument)document);
                if (file == null) break block9;
                for (IPageDataModel pdModel : localNotifyList) {
                    IFile pdFile = pdModel.getResource();
                    if (!file.equals((Object)pdFile)) continue;
                    ArrayList<IPageDataNode> toBeRemoved = new ArrayList<IPageDataNode>();
                    IPageDataNode root = pdModel.getRoot();
                    for (IPageDataNode iPageDataNode : root.getChildren()) {
                        if (!(iPageDataNode instanceof ICBDataNode)) continue;
                        toBeRemoved.add(iPageDataNode);
                    }
                    for (ICBDataNode iCBDataNode : toBeRemoved) {
                        pdModel.getRoot().removeChild((IPageDataNode)iCBDataNode);
                    }
                }
                break block9;
            }
            if (newLanguage.equalsIgnoreCase("java")) {
                file = CodeBehindUtil.getFileForPage((IDOMDocument)document);
                for (IPageDataModel pdModel : localNotifyList) {
                    IFile pdFile = pdModel.getResource();
                    if (!file.equals((Object)pdFile)) continue;
                    this.syncOrRefresh(pdModel, file.getProject(), newLocation);
                }
            }
        }
    }

    private void makeActive() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)5);
        this.listenerActive = true;
    }

    private void makeInactive() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.listenerActive = false;
    }

    private boolean processCompilationUnit(IPageDataModel pdModel, ICompilationUnit cu, CBLanguageInfo cbInfo) {
        boolean ret = false;
        if (cu.isWorkingCopy()) {
            try {
                IResource res = cu.getUnderlyingResource();
                if (res != null && res.getType() == 1) {
                    IPath path = ((IFile)res).getProjectRelativePath().makeAbsolute();
                    ret = path.equals((Object)cbInfo.location);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret;
    }

    public void processMethodDelta(List methodDeltas, IPageDataModel pdModel, IFile cbFile, boolean runAsync, IProgressMonitor monitor) {
        if (methodDeltas.size() > 0) {
            SyncPageCodeMethodsToPageDataTask syncTask = new SyncPageCodeMethodsToPageDataTask(pdModel, methodDeltas);
            IPath path = cbFile.getFullPath().removeFirstSegments(1).makeAbsolute();
            if (runAsync) {
                this.runTaskThatUpdatesPDV(pdModel, cbFile.getProject(), path, syncTask);
            } else {
                JavaModel model = JavaModelManager.getInstance().getModel("codebehind", cbFile.getProject(), path);
                try {
                    model.runJavaTask(8, (AbstractJavaModelTask)syncTask, null, null, null);
                }
                finally {
                    model.release();
                }
            }
        }
    }

    protected void runTaskThatUpdatesPDV(IPageDataModel pdModel, IProject project, IPath location, AbstractJavaModelTask task) {
        IWorkbenchPartSite site = null;
        int style = 8;
        if (!PageDataModelAdapter.isSyncInitialization()) {
            style = 16;
            PageDataView pdv = PageDataView.getViewInstance();
            if (pdv != null) {
                site = pdv.getSite();
            }
        } else {
            PageDataModelAdapter.setSyncInitialization((boolean)false);
        }
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", project, location);
        try {
            model.runJavaTask(style, task, null, site, null);
        }
        finally {
            model.release();
        }
    }

    public void syncOrRefresh(IPageDataModel pdModel, IProject project, IPath location) {
        SyncAllPageCodeMethodsToPageDataTask syncTask = new SyncAllPageCodeMethodsToPageDataTask(pdModel);
        this.runTaskThatUpdatesPDV(pdModel, project, location, syncTask);
    }

    private void visit(IPageDataModel pdModel, IJavaElementDelta delta, CBLanguageInfo cbInfo) {
        ArrayList<IJavaElementDelta> queue = new ArrayList<IJavaElementDelta>(1);
        queue.add(delta);
        ArrayList<MethodDelta> methodsDeltas = new ArrayList<MethodDelta>();
        while (!queue.isEmpty()) {
            IJavaElement jE;
            IMethod method;
            IType methodType;
            String returnType;
            ICBDataNode cbNode;
            IJavaElementDelta d = (IJavaElementDelta)queue.remove(0);
            IJavaElement element = d.getElement();
            if (element.getElementType() == 4) {
                IJavaElementDelta[] affectedChildren;
                IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren = d.getAffectedChildren();
                int n = affectedChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu;
                    IJavaElementDelta child = iJavaElementDeltaArray[n2];
                    IJavaElement jElem = child.getElement();
                    if (jElem.getElementType() == 5 && (cu = (ICompilationUnit)jElem).isWorkingCopy() && child.getKind() != 2) {
                        child.getFlags();
                    }
                    ++n2;
                }
            } else if (element.getElementType() == 5) {
                boolean shouldContinue = this.processCompilationUnit(pdModel, (ICompilationUnit)element, cbInfo);
                if (!shouldContinue) {
                    continue;
                }
            } else if (element.getElementType() == 7) {
                IType deltaIType = (IType)element;
                boolean doBreak = false;
                JavaModel model = JavaModelManager.getInstance().getModel("codebehind", pdModel.getResource().getProject(), cbInfo.location);
                try {
                    IType type = model.getType();
                    if (!deltaIType.equals(type)) {
                        if (d.getKind() == 1 || d.getKind() == 2) {
                            EList pdNodes = pdModel.getRoot().getChildren();
                            for (IPageDataNode pdNode : pdNodes) {
                                if (!(pdNode instanceof CBJavaBeanPageDataNode)) continue;
                                CBJavaBeanPageDataNode cbNode2 = (CBJavaBeanPageDataNode)pdNode;
                                cbNode2.refresh(cbNode2.getCodeBehindMethod());
                            }
                        } else if (d.getKind() == 4) {
                            String deltaType = deltaIType.getFullyQualifiedName();
                            EList pdNodes = pdModel.getRoot().getChildren();
                            for (IPageDataNode pdNode : pdNodes) {
                                IMethod cbMethod;
                                if (!(pdNode instanceof ICBDataNode) || (cbMethod = (cbNode = (ICBDataNode)pdNode).getCodeBehindMethod()) == null || !cbMethod.exists() || (returnType = JavaCodeUtil.getResolvedReturnType((IMethod)cbMethod)) == null) continue;
                                if (returnType.endsWith("[]")) {
                                    returnType = returnType.substring(0, returnType.length() - 2);
                                }
                                if (!deltaType.equals(returnType)) continue;
                                cbNode.refresh(cbNode.getCodeBehindMethod());
                            }
                        }
                    }
                }
                finally {
                    model.release();
                }
                if (doBreak) {
                    continue;
                }
            } else if (element.getElementType() == 12) {
                if (d.getKind() == 2) {
                    EList pdNodes = pdModel.getRoot().getChildren();
                    for (IPageDataNode pdNode : pdNodes) {
                        ICBDataNode cbNode3;
                        IMethod cbMethod;
                        if (!(pdNode instanceof ICBDataNode) || (cbMethod = (cbNode3 = (ICBDataNode)pdNode).getCodeBehindMethod()) == null || !cbMethod.exists()) continue;
                        cbNode3.refresh(cbNode3.getCodeBehindMethod());
                    }
                }
                if (d.getKind() == 1) {
                    EList pdNodes = pdModel.getRoot().getChildren();
                    ArrayList<ICBDataNode> nodesToRefresh = new ArrayList<ICBDataNode>();
                    for (IPageDataNode pdNode : pdNodes) {
                        IMethod cbMethod;
                        ICBDataNode cbNode4;
                        if (!(pdNode instanceof ICBDataNode) || (cbNode4 = (ICBDataNode)pdNode).isResolvable() || (cbMethod = cbNode4.getCodeBehindMethod()) == null || !cbMethod.exists()) continue;
                        nodesToRefresh.add(cbNode4);
                    }
                    for (ICBDataNode node : nodesToRefresh) {
                        node.refresh(node.getCodeBehindMethod());
                    }
                }
            } else if (element.getElementType() == 13) {
                IMethod cbMethod;
                ICBDataNode cbNode5;
                IImportDeclaration theimport = (IImportDeclaration)element;
                if (d.getKind() == 2) {
                    EList origChildren = pdModel.getRoot().getChildren();
                    List<IPageDataNode> copyChildren = Arrays.asList(origChildren.toArray(new IPageDataNode[origChildren.size()]));
                    for (IPageDataNode pdNode : copyChildren) {
                        if (!(pdNode instanceof ICBDataNode)) continue;
                        cbNode5 = (ICBDataNode)pdNode;
                        if (!theimport.getElementName().equals(Signature.getTypeErasure((String)cbNode5.getClassName())) || (cbMethod = cbNode5.getCodeBehindMethod()) == null || !cbMethod.exists()) continue;
                        cbNode5.refresh(cbNode5.getCodeBehindMethod());
                    }
                } else if (d.getKind() == 1) {
                    EList origChildren = pdModel.getRoot().getChildren();
                    List<IPageDataNode> copyChildren = Arrays.asList(origChildren.toArray(new IPageDataNode[origChildren.size()]));
                    for (IPageDataNode pdNode : copyChildren) {
                        if (!(pdNode instanceof ICBDataNode) || (cbNode5 = (ICBDataNode)pdNode).isResolvable() || (cbMethod = cbNode5.getCodeBehindMethod()) == null || !cbMethod.exists()) continue;
                        cbNode5.refresh(cbNode5.getCodeBehindMethod());
                    }
                }
            } else if (element.getElementType() == 9 && (methodType = (IType)(method = (IMethod)element).getParent()) != null && (jE = methodType.getParent()).getElementType() != 7) {
                if (d.getKind() == 4) {
                    EList rootChildren = pdModel.getRoot().getChildren();
                    boolean refreshed = false;
                    ArrayList<ICBDataNode> nodesToRefresh = new ArrayList<ICBDataNode>();
                    for (IPageDataNode pdNode : rootChildren) {
                        boolean isvoid;
                        if (!(pdNode instanceof ICBDataNode) || !(cbNode = (ICBDataNode)pdNode).getCodeBehindMethod().equals(method)) continue;
                        boolean ispublic = false;
                        try {
                            ispublic = Flags.isPublic((int)method.getFlags());
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                        returnType = JavaCodeUtil.getResolvedReturnType((IMethod)method);
                        boolean bl = isvoid = returnType != null && returnType.equals("void");
                        if (!ispublic || isvoid) {
                            MethodDelta methoddelta = new MethodDelta();
                            methoddelta.kind = 2;
                            methoddelta.method = method;
                            methodsDeltas.add(methoddelta);
                        } else {
                            nodesToRefresh.add(cbNode);
                        }
                        refreshed = true;
                    }
                    for (ICBDataNode node : nodesToRefresh) {
                        node.refresh(node.getCodeBehindMethod());
                    }
                    if (!refreshed) {
                        MethodDelta methoddelta = new MethodDelta();
                        methoddelta.kind = 1;
                        methoddelta.method = method;
                        methodsDeltas.add(methoddelta);
                    }
                } else if (d.getKind() == 2) {
                    MethodDelta methoddelta = new MethodDelta();
                    methoddelta.kind = 2;
                    methoddelta.method = method;
                    methodsDeltas.add(methoddelta);
                } else if (d.getKind() == 1) {
                    MethodDelta methoddelta = new MethodDelta();
                    methoddelta.kind = 1;
                    methoddelta.method = method;
                    methodsDeltas.add(methoddelta);
                } else if (d.getKind() == 2) {
                    EList rootChildren = pdModel.getRoot().getChildren();
                    for (IPageDataNode pdNode : rootChildren) {
                        ICBDataNode cbNode6;
                        if (!(pdNode instanceof ICBDataNode) || (cbNode6 = (ICBDataNode)pdNode).getCodeBehindMethod() != method) continue;
                        cbNode6.refresh(method);
                    }
                }
            }
            IJavaElementDelta[] childrenArray = d.getAffectedChildren();
            int i = 0;
            while (i < childrenArray.length) {
                queue.add(childrenArray[i]);
                ++i;
            }
        }
        IFile cbFile = pdModel.getResource().getProject().getFile(cbInfo.location);
        if (methodsDeltas.size() > 0) {
            this.processMethodDelta(methodsDeltas, pdModel, cbFile, true, null);
        }
    }

    static class MethodDelta {
        int kind;
        IMethod method;

        MethodDelta() {
        }
    }
}

