/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data;

import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBActionPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBParamBeanPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBResultBeanPageDataNode;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.DeleteFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.UpdateMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CBActionDelegateDeleteTask
extends AbstractJavaModelTask {
    IMethod method;
    IFile file;
    PageDataNode node;
    List additionalMethodsToDelete;
    List additionalFieldsToDelete;

    public CBActionDelegateDeleteTask(IMethod method, IPageDataNode node, IFile file) {
        this.method = method;
        this.file = file;
        this.node = (PageDataNode)node;
    }

    public void addFieldToDelete(String field) {
        if (this.additionalFieldsToDelete == null) {
            this.additionalFieldsToDelete = new ArrayList();
        }
        this.additionalFieldsToDelete.add(field);
    }

    public void addMethodToDelete(String method, String[] parameters, boolean[] areResolved) {
        MethodData data = new MethodData();
        data.name = method;
        data.setParameters(parameters, areResolved);
        if (this.additionalMethodsToDelete == null) {
            this.additionalMethodsToDelete = new ArrayList();
        }
        this.additionalMethodsToDelete.add(data);
    }

    private void cleanupMethodArtifacts(IJavaBeanMethodPDN methodNode, JavaModel model, IProgressMonitor monitor) {
        try {
            CBResultBeanPageDataNode resultBean;
            CBParamBeanPageDataNode paramBean = (CBParamBeanPageDataNode)methodNode.getParamBean();
            if (paramBean != null) {
                String paramBeanGetterName = paramBean.getCodeBehindMethod().getElementName();
                DeleteMethodCommand delParamBeanMethodCmd = new DeleteMethodCommand();
                delParamBeanMethodCmd.setIdentifier(paramBeanGetterName);
                delParamBeanMethodCmd.execute(model, monitor);
                monitor.worked(1);
                String paramPropName = JavaTypeUtil.getPropertyName((String)paramBeanGetterName);
                paramPropName = JavaTypeUtil.decapitalizePropertyName((String)paramPropName);
                DeleteFieldCommand deleteFieldCmd = new DeleteFieldCommand();
                deleteFieldCmd.setIdentifier(paramPropName);
                deleteFieldCmd.execute(model, monitor);
                monitor.worked(1);
            }
            if ((resultBean = (CBResultBeanPageDataNode)methodNode.getResultBean()) != null) {
                String resultBeanGetterName = resultBean.getCodeBehindMethod().getElementName();
                DeleteMethodCommand delResultBeanMethodCmd = new DeleteMethodCommand();
                delResultBeanMethodCmd.setIdentifier(resultBeanGetterName);
                delResultBeanMethodCmd.execute(model, monitor);
                monitor.worked(1);
                String resultPropName = JavaTypeUtil.getPropertyName((String)resultBeanGetterName);
                resultPropName = JavaTypeUtil.decapitalizePropertyName((String)resultPropName);
                DeleteFieldCommand deleteFieldCmd = new DeleteFieldCommand();
                deleteFieldCmd.setIdentifier(resultPropName);
                deleteFieldCmd.execute(model, monitor);
                monitor.worked(1);
            }
            CBActionPageDataNode action = (CBActionPageDataNode)methodNode.getActionNode();
            String actionName = action.getCodeBehindMethod().getElementName();
            DeleteMethodCommand delParamBeanMethodCmd = new DeleteMethodCommand();
            delParamBeanMethodCmd.setIdentifier(actionName);
            delParamBeanMethodCmd.execute(model, monitor);
            monitor.worked(1);
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        int totalWork = 3 + (this.additionalFieldsToDelete != null ? this.additionalFieldsToDelete.size() : 0) + (this.additionalMethodsToDelete != null ? this.additionalMethodsToDelete.size() : 0);
        monitor.beginTask(Messages.DeletingReferences_0, totalWork);
        if (this.node instanceof IJavaBeanMethodPDN) {
            this.cleanupMethodArtifacts((IJavaBeanMethodPDN)this.node, model, monitor);
            this.removeMethodDoclet(model, monitor);
        } else {
            String methodName = this.method.getElementName();
            if (methodName.startsWith("get")) {
                ReadMethodCommand readCmd = new ReadMethodCommand();
                readCmd.setIdentifier(methodName);
                readCmd.setParameterNames(this.method.getParameterNames());
                readCmd.setParameters(this.method.getParameterTypes());
                readCmd.execute(model, monitor);
                boolean bAutoGen = false;
                String identifier = null;
                String beanSignature = null;
                JavaDocInfo jDocInfo = readCmd.getJavadoc();
                if (jDocInfo != null && jDocInfo.getDocletList() != null) {
                    identifier = JavaCodeUtil.lowercaseFirst((String)methodName.substring(3, methodName.length()));
                    String beanClass = ((IBindingAttribute)this.node.getAdapter(IBindingAttribute.class)).getRuntimeType((IPageDataNode)this.node);
                    beanClass = beanClass.replace('$', '.');
                    beanSignature = Signature.createTypeSignature((String)Signature.getSimpleName((String)beanClass), (boolean)false);
                    if (identifier != null && beanSignature != null) {
                        bAutoGen = true;
                        if (jDocInfo.getCommentForTag("managed-bean") != null && jDocInfo.getCommentForTag("managed-bean").equals("true")) {
                            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConfirmRemovalOfFacesConfigEntryDialog(methodName));
                        }
                    }
                }
                if (bAutoGen) {
                    DeleteMethodCommand delMethodCmd = new DeleteMethodCommand();
                    delMethodCmd.setIdentifier("set" + JavaCodeUtil.capitalizeFirst((String)identifier));
                    delMethodCmd.setParameters(new String[]{beanSignature});
                    delMethodCmd.setParameterNames(new String[]{identifier});
                    delMethodCmd.execute(model, monitor);
                    monitor.worked(1);
                }
            }
            if (this.node instanceof JavaBeanPageDataNode) {
                List methodChildren;
                JavaBeanPageDataNode jbNode = (JavaBeanPageDataNode)this.node;
                if (monitor != null) {
                    monitor.subTask("");
                }
                if ((methodChildren = jbNode.getMethodChildren()) != null && !methodChildren.isEmpty()) {
                    int i = 0;
                    while (i < methodChildren.size()) {
                        IJavaBeanMethodPDN methodNode = (IJavaBeanMethodPDN)methodChildren.get(i);
                        this.cleanupMethodArtifacts(methodNode, model, monitor);
                        ++i;
                    }
                }
            }
            DeleteMethodCommand delMethodCmd = new DeleteMethodCommand();
            delMethodCmd.setIdentifier(methodName);
            delMethodCmd.execute(model, monitor);
            monitor.worked(1);
            String propName = JavaTypeUtil.getPropertyName((String)this.method.getElementName());
            propName = JavaTypeUtil.decapitalizePropertyName((String)propName);
            DeleteFieldCommand deleteFieldCmd = new DeleteFieldCommand();
            deleteFieldCmd.setIdentifier(propName);
            deleteFieldCmd.execute(model, monitor);
            monitor.worked(1);
            if (this.additionalFieldsToDelete != null) {
                for (String field : this.additionalFieldsToDelete) {
                    deleteFieldCmd = new DeleteFieldCommand();
                    deleteFieldCmd.setIdentifier(field);
                    deleteFieldCmd.execute(model, monitor);
                    monitor.worked(1);
                }
            }
            if (this.additionalMethodsToDelete != null) {
                for (MethodData data : this.additionalMethodsToDelete) {
                    delMethodCmd = new DeleteMethodCommand();
                    delMethodCmd.setIdentifier(data.name);
                    delMethodCmd.setParameters(data.paramSignatures);
                    delMethodCmd.execute(model, monitor);
                    monitor.worked(1);
                }
            }
            if (this.node.getPageDataModel() instanceof PageDataModel) {
                ((PageDataModel)this.node.getPageDataModel()).getIDOMModel().setDirtyState(true);
            }
            monitor.done();
        }
    }

    public String getDisplayName() {
        return Messages.CBActionDelegateDeleteTask_0;
    }

    public ISchedulingRule getSchedulingRule() {
        MultiRule rule = new MultiRule(new ISchedulingRule[]{this.node.getChildrenRule(), super.getSchedulingRule()});
        return rule;
    }

    private void removeMethodDoclet(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        String beanGetterName = this.method.getElementName();
        String beanGetterReturnType = this.method.getReturnType();
        String methodToBeDeletedSignature = ((IJavaBeanMethodPDN)this.node).getMethodSignature();
        ReadMethodCommand readCmd = new ReadMethodCommand();
        readCmd.setIdentifier(beanGetterName);
        readCmd.setParameterNames(this.method.getParameterNames());
        readCmd.setParameters(this.method.getParameterTypes());
        readCmd.execute(model, monitor);
        JavaDocInfo jDocInfo = readCmd.getJavadoc();
        if (jDocInfo != null && jDocInfo.getDocletList() != null) {
            List methodDocletList = jDocInfo.getCommentsForTag("methodEntry");
            int i = 0;
            while (i < methodDocletList.size()) {
                String tag = (String)methodDocletList.get(i);
                if (tag.indexOf(methodToBeDeletedSignature) != -1) {
                    jDocInfo.removeJavaDocElement("methodEntry", tag);
                }
                ++i;
            }
        }
        String contents = readCmd.getContents();
        UpdateMethodCommand updateMethod = new UpdateMethodCommand();
        updateMethod.setIdentifier(beanGetterName);
        updateMethod.setModifier("public");
        updateMethod.setParameters(new String[0]);
        updateMethod.setParameterNames(new String[0]);
        updateMethod.setReturnType(Signature.toString((String)beanGetterReturnType));
        updateMethod.setForce(true);
        updateMethod.setJavadoc(jDocInfo);
        updateMethod.setContents(contents);
        updateMethod.execute(model, monitor);
    }

    private class ConfirmRemovalOfFacesConfigEntryDialog
    implements Runnable {
        private String methodName;

        public ConfirmRemovalOfFacesConfigEntryDialog(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void run() {
            if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConfirmRemovalOfManagedBean_0, (String)Messages.ConfirmRemovalOfManagedBean_1) && JsfProjectUtil.isJsfProject((IProject)CBActionDelegateDeleteTask.this.file.getProject())) {
                FacesConfigArtifactEdit edit = null;
                try {
                    edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)CBActionDelegateDeleteTask.this.file);
                    if (edit != null && edit.getFacesConfig() != null) {
                        EList managedBeans = edit.getFacesConfig().getManagedBean();
                        int i = 0;
                        while (i < managedBeans.size()) {
                            String sName;
                            ManagedBeanType managedBean = (ManagedBeanType)managedBeans.get(i);
                            String string = sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                            if (this.methodName.equals("get" + JavaCodeUtil.capitalizeFirst((String)sName))) {
                                managedBeans.remove((Object)managedBean);
                            }
                            ++i;
                        }
                        edit.save((IProgressMonitor)new NullProgressMonitor());
                    }
                    edit.save(null);
                }
                finally {
                    if (edit != null) {
                        edit.dispose();
                    }
                }
            }
        }
    }

    static class MethodData {
        String name = null;
        String[] paramSignatures = null;

        MethodData() {
        }

        void setParameters(String[] parameters, boolean[] areResolved) {
            if (parameters != null && areResolved != null && parameters.length == areResolved.length) {
                this.paramSignatures = new String[parameters.length];
                int i = 0;
                while (i < parameters.length) {
                    this.paramSignatures[i] = Signature.createTypeSignature((String)Signature.getSimpleName((String)parameters[i]), (boolean)areResolved[i]);
                    ++i;
                }
            }
        }
    }
}

