/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JSFJavaBeanDataModel;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.PublicMonitorWizardDialog;
import com.ibm.etools.webtools.codebehind.jsf.wizards.internal.JSFPageCodeBeanWizard;
import com.ibm.etools.webtools.codebehind.pdm.data.CBActionDelegateDeleteTask;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBActionPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBParamBeanPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBResultBeanPageDataNode;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodMarkerCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.util.ModelUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JBActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.SelectMethodDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class CBActionDelegateAdapter
extends JBActionDelegateAdapter {
    private JavaModel model = null;
    private IMethod method = null;
    private IFile file = null;

    public boolean canHandleAction(IPageDataNode node, int actionType) {
        if (node instanceof CBParamBeanPageDataNode || node instanceof CBResultBeanPageDataNode) {
            return false;
        }
        if (actionType == 0 || actionType == ACTION_ADD_METHOD) {
            return PageDataModelUtil.isComponentNode((IPageDataNode)node) || node instanceof IJavaBeanMethodPDN;
        }
        if (actionType == 1) {
            if (node instanceof CBActionPageDataNode) {
                return true;
            }
            return PageDataModelUtil.isComponentNode((IPageDataNode)node);
        }
        return false;
    }

    protected CBActionDelegateDeleteTask getDeleteTask(IMethod method, IPageDataNode node, IFile file) {
        return new CBActionDelegateDeleteTask(method, node, file);
    }

    public boolean handleAction(IPageDataNode node, int actionType) {
        boolean executed = false;
        if (node instanceof ICBDataNode) {
            SelectMethodDialog methodDialog;
            if (actionType == 0) {
                executed = true;
                this.performInit(node);
                CBActionDelegateDeleteTask deleteTask = this.getDeleteTask(this.method, node, this.file);
                try {
                    this.model.runBlockingUIJavaTaskWithBusyCursorThenDialog((AbstractJavaModelTask)deleteTask);
                }
                finally {
                    if (this.model != null) {
                        this.model.release();
                    }
                }
            }
            if (actionType == 1) {
                executed = true;
                this.performInit(node);
                IMarker marker = this.performConfigure(node);
                if (marker != null) {
                    try {
                        IWorkbenchWindow window = JsfPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)this.file, (boolean)true);
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
                if (this.model != null) {
                    this.model.release();
                }
            } else if (actionType == ACTION_ADD_METHOD && (methodDialog = new SelectMethodDialog(PageDataViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IJavaBeanPageDataNode)((JavaBeanPageDataNode)node), false)).open() == 0) {
                executed = true;
                Method method1 = methodDialog.getSelectedMethod();
                ((JavaBeanPageDataNode)node).addJavaBeanMethod(method1);
            }
        }
        return executed;
    }

    private IMarker performConfigure(IPageDataNode nodeToConfigure) {
        IMarker marker = null;
        JSFJavaBeanDataModel dataModel = null;
        try {
            if (this.method.getElementName().startsWith("get")) {
                ReadMethodCommand readCmd = new ReadMethodCommand();
                readCmd.setIdentifier(this.method.getElementName());
                readCmd.setParameterNames(this.method.getParameterNames());
                readCmd.setParameters(this.method.getParameterTypes());
                readCmd.execute(this.model, null);
                HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
                IFile file = nodeToConfigure.getPageDataModel().getResource();
                JSP jsp = null;
                try {
                    WebModel webModel = ModelUtil.getModel((IResource)file);
                    jsp = webModel.getJSP(file);
                }
                catch (WebModelCreationException e) {
                    e.printStackTrace();
                }
                dataModel = new JSFJavaBeanDataModel(jsp);
                dataModel.setJDocInfo(readCmd.getJavadoc());
                JSFPageCodeBeanWizard wizard = new JSFPageCodeBeanWizard(false, dataModel);
                wizard.getDataModel().getData().setPageDataNode((IJavaBeanPageDataNode)((JavaBeanPageDataNode)nodeToConfigure));
                PublicMonitorWizardDialog dialog = new PublicMonitorWizardDialog(domain.getDialogParent(), (IWizard)wizard);
                String trimmedGetterContents = this.removeWhitespaceFromGetter(wizard.internalGetCommand().getGetterContents());
                String trimmedReadCmdContents = this.removeWhitespaceFromGetter(readCmd.getContents());
                if (trimmedGetterContents.equals(trimmedReadCmdContents)) {
                    dialog.create();
                    dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), dialog.getShell().getSize().y);
                    dialog.open();
                    return null;
                }
            }
            try {
                CreateMethodMarkerCommand createCmd = new CreateMethodMarkerCommand();
                createCmd.setIdentifier(this.method.getElementName());
                createCmd.setParameterNames(this.method.getParameterTypes());
                createCmd.setParameters(this.method.getParameterNames());
                createCmd.setReturnType(this.method.getReturnType());
                createCmd.execute(this.model, null);
                marker = createCmd.getMethodMarker();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (dataModel != null) {
                dataModel.dispose();
            }
        }
        return marker;
    }

    private void performInit(IPageDataNode node) {
        this.method = ((ICBDataNode)node).getCodeBehindMethod();
        if (this.method != null) {
            ICompilationUnit cu = this.method.getCompilationUnit();
            this.file = null;
            try {
                this.file = cu.isWorkingCopy() ? (IFile)this.method.getCompilationUnit().getOriginalElement().getUnderlyingResource() : (IFile)this.method.getCompilationUnit().getUnderlyingResource();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (this.file != null) {
                this.model = null;
                this.model = JavaModelManager.getInstance().getModel("codebehind", this.file.getProject(), this.file.getProjectRelativePath().makeAbsolute());
            }
        }
    }

    private String removeWhitespaceFromGetter(String getterContents) {
        if (getterContents == null || getterContents.equals("")) {
            return "";
        }
        char[] getterContentsChars = getterContents.toCharArray();
        StringBuffer getterContentsWithNoWhitespace = new StringBuffer();
        int i = 0;
        while (i < getterContentsChars.length) {
            char character = getterContentsChars[i];
            if (!Character.isWhitespace(character)) {
                getterContentsWithNoWhitespace.append(character);
            }
            ++i;
        }
        return getterContentsWithNoWhitespace.toString();
    }
}

