/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.pdm.data;

import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.ICBDataNodeProvider;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBActionPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBJavaBeanPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBUnresolvablePageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.registry.CodebehindJavaRegistryReader;
import com.ibm.etools.webtools.codebehind.pdm.data.registry.ICBNodeProviderDefinition;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataView;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class AddDataNodeFromJavaModelCommand
extends JavaCommand {
    private IPageDataModel fPdModel;
    private IMethod fCbMethod;
    private IPageDataNode parentNode;

    public AddDataNodeFromJavaModelCommand(IPageDataModel model, IMethod cbMethod, IPageDataNode parentNode) {
        this.fPdModel = model;
        this.fCbMethod = cbMethod;
        this.parentNode = parentNode;
    }

    protected ICBDataNode createJavaBeanNode(IPageDataModel pdModel, IMethod cbMethod, String codeBehindBeanName) {
        CBJavaBeanPageDataNode javaBeanNode = new CBJavaBeanPageDataNode(cbMethod, pdModel, codeBehindBeanName);
        return javaBeanNode;
    }

    public void execute(JavaModel context, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCbMethod == null || this.fPdModel == null || !Flags.isPublic((int)this.fCbMethod.getFlags())) {
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        IDOMDocument xmlDoc = ((PageDataModel)this.fPdModel).getIDOMModel().getDocument();
        ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
        String codeBehindBeanName = JavaCodeBehindPlugin.getCodeBehindBeanName(xmlDoc);
        ICBDataNode cbDataNode = null;
        if (!JavaCodeUtil.isReturnTypeResolvable((IMethod)this.fCbMethod)) {
            cbDataNode = new CBUnresolvablePageDataNode(this.fPdModel, this.parentNode, this.fCbMethod, codeBehindBeanName, language.getCBInfo().location);
        }
        if (cbDataNode == null) {
            List list = CodebehindJavaRegistryReader.getRegistry().getNodeProviders();
            for (ICBNodeProviderDefinition definition : list) {
                ICBDataNodeProvider provider = definition.getProvider();
                if (provider == null) continue;
                try {
                    ICBDataNode extensionCBDataNode = provider.createPageDataNode(this.fPdModel, this.fCbMethod, this.parentNode);
                    if (extensionCBDataNode == null) continue;
                    cbDataNode = extensionCBDataNode;
                    break;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        if (cbDataNode == null) {
            ReadMethodCommand readCmd;
            block24: {
                JavaModel model = JavaModelManager.getInstance().getModel("codebehind", context.getProject(), language.getCBInfo().location);
                readCmd = new ReadMethodCommand();
                try {
                    try {
                        readCmd.setIdentifier(this.fCbMethod.getElementName());
                        readCmd.setParameterNames(this.fCbMethod.getParameterNames());
                        readCmd.setParameters(this.fCbMethod.getParameterTypes());
                        readCmd.execute(context, monitor);
                    }
                    catch (JavaModelException e2) {
                        e2.printStackTrace();
                        model.release();
                        break block24;
                    }
                }
                catch (Throwable provider) {
                    model.release();
                    throw provider;
                }
                model.release();
            }
            JavaDocInfo jDocInfo = readCmd.getJavadoc();
            String typeName = null;
            if (this.fCbMethod.getParameterTypes().length == 0 && (typeName = JavaCodeUtil.getResolvedReturnType((IMethod)this.fCbMethod)) != null) {
                if (typeName.endsWith("[]")) {
                    typeName = typeName.substring(0, typeName.indexOf("[]"));
                }
                if (typeName.equals("java.lang.String") && !this.fCbMethod.getElementName().startsWith("get")) {
                    cbDataNode = new CBActionPageDataNode(this.fPdModel, this.fCbMethod, codeBehindBeanName);
                    if (jDocInfo != null && jDocInfo.getCommentForTag("action") != null) {
                        ((CBActionPageDataNode)cbDataNode).setSolitary(false);
                    }
                }
            }
            if (this.fCbMethod.getElementName().startsWith("get") || this.isBooleanJavaBean(this.fCbMethod, typeName)) {
                if (jDocInfo == null) {
                    cbDataNode = this.createJavaBeanNode(this.fPdModel, this.fCbMethod, codeBehindBeanName);
                } else if (jDocInfo.getCommentForTag("generated") == null && jDocInfo.getCommentForTag("paramBean") == null && jDocInfo.getCommentForTag("resultBean") == null) {
                    cbDataNode = this.createJavaBeanNode(this.fPdModel, this.fCbMethod, codeBehindBeanName);
                }
            }
        }
        if (cbDataNode != null) {
            IBindingAttribute bAttr;
            this.parentNode.addChild(cbDataNode);
            if (PlatformUI.isWorkbenchRunning() && (bAttr = (IBindingAttribute)cbDataNode.getAdapter(IBindingAttribute.ADAPTER_KEY)) != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageDataView.bringToTop(null);
                    }
                });
            }
        }
    }

    private boolean isBooleanJavaBean(IMethod method, String returnType) {
        if (returnType == null) {
            returnType = JavaCodeUtil.getResolvedReturnType((IMethod)this.fCbMethod);
        }
        return method.getElementName().startsWith("is") && (returnType != null && returnType.equals("boolean") || returnType.equals("java.lang.Boolean"));
    }
}

