/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.support.dialogs;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageContainerFillLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int minimumWidth = 0;
    public int minimumHeight = 0;

    public PageContainerFillLayout(int mw, int mh, int minW, int minH) {
        this.marginWidth = mw;
        this.marginHeight = mh;
        this.minimumWidth = minW;
        this.minimumHeight = minH;
    }

    public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point result = null;
        Control[] children = composite.getChildren();
        if (children.length > 0) {
            result = new Point(0, 0);
            int i = 0;
            while (i < children.length) {
                Point cp = children[i].computeSize(wHint, hHint, force);
                result.x = Math.max(result.x, cp.x);
                result.y = Math.max(result.y, cp.y);
                ++i;
            }
            result.x += 2 * this.marginWidth;
            result.y += 2 * this.marginHeight;
        } else {
            Rectangle rect = composite.getClientArea();
            result = new Point(rect.width, rect.height);
        }
        result.x = Math.max(result.x, this.minimumWidth);
        result.y = Math.max(result.y, this.minimumHeight);
        if (wHint != -1) {
            result.x = wHint;
        }
        if (hHint != -1) {
            result.y = hHint;
        }
        return result;
    }

    @Deprecated
    public Rectangle getClientArea(Composite c) {
        Rectangle rect = c.getClientArea();
        rect.x += this.marginWidth;
        rect.y += this.marginHeight;
        rect.width -= 2 * this.marginWidth;
        rect.height -= 2 * this.marginHeight;
        return rect;
    }

    public void layout(Composite composite, boolean force) {
        Rectangle rect = this.getClientArea(composite);
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(rect);
            ++i;
        }
    }

    @Deprecated
    public void layoutPage(Control w) {
        w.setBounds(this.getClientArea(w.getParent()));
    }

    @Deprecated
    public void setPageLocation(Control w) {
        w.setLocation(this.marginWidth, this.marginHeight);
    }
}

