/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.support.dialogs;

import com.ibm.etools.jsf.databind.dnd.JSFDropActionMediator;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.jsf.support.CBJavaBeanUtil;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.AddJavaBean2PageCodeTask;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JBDataUtil;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.MethodInvokingJBData;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.PublicMonitorWizardDialog;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.TaskIncrementingSubProgressMonitor;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.CBJavaBeanPageDataNode;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public abstract class MethodInvokingJBController {
    protected MethodInvokingJBData fData;

    public MethodInvokingJBController(MethodInvokingJBData data) {
        this.fData = data;
    }

    public void createCodeGenModel() {
        if (this.fData.isGenerateUI()) {
            HTMLEditDomain editDomain = this.getEditDomain();
            ICodeGenModel cgModel = null;
            if (editDomain != null && this.fData.getSelectedMethod() != null) {
                try {
                    IDOMDocument doc = editDomain.getActiveModel().getDocument();
                    IPageDataModel pdModel = this.getPDModel(doc);
                    CBJavaBeanPageDataNode jbPDN = this.createJBPDNode(pdModel);
                    jbPDN.setCodeBehindName(JavaCodeBehindPlugin.getCodeBehindBeanName(doc));
                    IJavaBeanMethodPDN methodPdn = JBDataUtil.createJavaBeanMethodNode((IJavaBeanPageDataNode)jbPDN, this.fData.getSelectedMethod());
                    this.fData.setMethodToInvokePDN(methodPdn);
                    cgModel = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])new IPageDataNode[]{jbPDN}, null, (IFile)pdModel.getResource(), (String)"JSF", (boolean)true);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (UserCancelledException userCancelledException) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (WebModelCreationException e) {
                    e.printStackTrace();
                }
            }
            if (cgModel != null) {
                cgModel.setCreateSubmitButton(true);
            }
            this.fData.setCgModel(cgModel);
        }
    }

    public abstract CBJavaBeanPageDataNode createJBPDNode(IPageDataModel var1);

    public void generateCodeBehindCode(IRunnableContext context) {
        JavaModel model = null;
        SubProgressMonitor subMonitor = null;
        try {
            HTMLEditDomain editDomain = this.getEditDomain();
            if (editDomain != null) {
                IDOMDocument doc = editDomain.getActiveModel().getDocument();
                model = CBJavaBeanUtil.getCBModel(doc);
                AddJavaBean2PageCodeTask task = this.getPCTask(model);
                if (context instanceof PublicMonitorWizardDialog && this.fData.isGenerateUI()) {
                    PublicMonitorWizardDialog pmDialog = (PublicMonitorWizardDialog)context;
                    IProgressMonitor monitor = pmDialog.getProgressMonitor();
                    subMonitor = new SubProgressMonitor(pmDialog.getProgressMonitor(), 50);
                    task.setProgressMonitor((IProgressMonitor)subMonitor);
                    pmDialog.setProgressMonitor((IProgressMonitor)subMonitor);
                    monitor.beginTask(Messages.JSFJavaBeanWizard_insert_data, 100);
                }
                model.runBlockingUIJavaTaskWithContext((AbstractJavaModelTask)task, context);
            }
        }
        finally {
            if (model != null) {
                model.release();
            }
            if (subMonitor != null) {
                subMonitor.done();
            }
        }
    }

    public void generateJSFCode(IRunnableContext context) {
        try {
            IProgressMonitor mon = null;
            Object subMonitor = null;
            if (context instanceof PublicMonitorWizardDialog) {
                PublicMonitorWizardDialog pmDialog = (PublicMonitorWizardDialog)context;
                pmDialog.setProgressMonitor(null);
                mon = pmDialog.getProgressMonitor();
                subMonitor = new TaskIncrementingSubProgressMonitor(mon, 50);
                pmDialog.setProgressMonitor((IProgressMonitor)subMonitor);
            } else {
                subMonitor = new NullProgressMonitor();
            }
            subMonitor.beginTask(Messages.JSFJavaBeanWizard_generate, 50);
            subMonitor.worked(2);
            HTMLEditDomain htmlEditDomain = this.getEditDomain();
            Node target = null;
            if (htmlEditDomain != null) {
                target = JsfCommandUtil.getTargetNode((Range)htmlEditDomain.getSelectionMediator().getRange());
            }
            subMonitor.worked(2);
            JSFDropActionMediator mediator = new JSFDropActionMediator();
            mediator.handlePaletteDrop(this.fData.getCgModel(), target);
            subMonitor.worked(4);
            subMonitor.done();
            if (mon != null) {
                mon.done();
            }
        }
        catch (Throwable ce) {
            ce.printStackTrace();
        }
    }

    public List<String> getClassFiles(IContainer container) throws Exception {
        ArrayList<String> proxyList = new ArrayList<String>();
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() == 1) {
                    String name = resources[i].getProjectRelativePath().toString();
                    if (name.endsWith("Proxy.class")) {
                        name = name.substring(1, name.lastIndexOf(".class"));
                        name = name.replaceAll("/", ".");
                        proxyList.add(name);
                    }
                } else if (resources[i].getType() == 2) {
                    proxyList.addAll(this.getClassFiles((IContainer)((IFolder)resources[i])));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return proxyList;
    }

    protected HTMLEditDomain getEditDomain() {
        HTMLEditDomain domain = this.fData.getEditDomain();
        if (domain == null && !this.fData.allowProjectSelection()) {
            domain = ActionUtil.getActiveHTMLEditDomain();
        }
        return domain;
    }

    protected AddJavaBean2PageCodeTask getPCTask(JavaModel model) {
        return new AddJavaBean2PageCodeTask(this.fData);
    }

    IPageDataModel getPDModel(IDOMDocument doc) {
        PageDataModelAdapter.setSyncInitialization((boolean)true);
        PageDataModelAdapter adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (adapter == null) {
            EditorModelUtil.addFactoriesTo((IStructuredModel)doc.getModel());
            adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        }
        return adapter.getPageDataModel();
    }

    public void performCancel() {
        this.fData.dispose();
    }

    public boolean performFinish(IRunnableContext context) {
        if (this.getEditDomain() != null) {
            try {
                this.generateCodeBehindCode(context);
                if (this.fData.isGenerateUI()) {
                    this.generateJSFCode(context);
                } else {
                    this.getEditDomain().getActiveModel().setDirtyState(true);
                }
            }
            finally {
                this.fData.dispose();
            }
        }
        return true;
    }

    public void setSelectedMethod(Method method) {
        this.fData.setSelectedMethod(method);
        this.createCodeGenModel();
    }
}

