/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.support.dialogs;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.bean.BeanInformationImpl;
import com.ibm.etools.webedit.bean.BeanProperty;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.dialogs.insert.InsertElementImpl;
import com.ibm.etools.webedit.utils.IInsertElement;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindLanguageRegistry;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ICBLanguageFactory;
import com.ibm.etools.webtools.codebehind.api.ILocationGenerator;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.internal.ui.PageCodeConfirmation;
import com.ibm.etools.webtools.codebehind.java.CBModelUtil;
import com.ibm.etools.webtools.codebehind.java.extensions.MockJavaCBModel;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.AddJavaBeanUITask;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JBDataUtil;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JSFJavaBeanData;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JSFJavaBeanDataModel;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocElement;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.pagedatamodel.util.JavaGenericsUtil;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyType;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class AddJSFJavaBeanCommand
extends AbstractCommand {
    JSFJavaBeanDataModel fDataModel;
    IRunnableContext fContext;
    private String[] fInstanceProperties = null;
    private String[] fInstancePropertyTypes = null;

    public AddJSFJavaBeanCommand(String label, JSFJavaBeanDataModel dataModel, IRunnableContext context) {
        super(label);
        this.fDataModel = dataModel;
        this.fContext = context != null ? context : PlatformUI.getWorkbench().getProgressService();
    }

    public static JavaModel getCBModel(IDOMDocument xmlDoc) {
        MockJavaCBModel model = null;
        ICBLanguage cbAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
        CBLanguageInfo cbInfo = cbAdapter.getCBInfo();
        if (cbInfo.language.equals("java")) {
            IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), cbInfo.location);
        } else {
            model = new MockJavaCBModel(null, null);
        }
        return model;
    }

    private void addCodeBehindCode(String beanName, String beanClass, boolean isManagedBean) {
        boolean generatePageCode;
        HTMLEditDomain actionTarget;
        block14: {
            actionTarget = this.fDataModel.getHtmlEditDomain();
            IDOMDocument xmlDoc = actionTarget.getActiveModel().getDocument();
            JavaModel model = AddJSFJavaBeanCommand.getCBModel(xmlDoc);
            if (!this.fDataModel.isEdit()) {
                beanName = JBDataUtil.getFieldName(beanName, model);
            }
            Iterator propertiesIterator = null;
            if (this.fDataModel.getManagedPropertiesList() != null) {
                propertiesIterator = this.fDataModel.getManagedPropertiesList().iterator();
            }
            String getter = this.generateGetterContents(beanName, beanClass, isManagedBean, propertiesIterator, true);
            List docletList = this.fDataModel.getDocletList();
            String[] propertyImports = this.getPropertyImports();
            Method methodToInvoke = this.fDataModel.getData().getMethodToInvoke();
            JSFJavaBeanData data = this.fDataModel.getData();
            AddJavaBeanUITask task = new AddJavaBeanUITask(beanName, beanClass, isManagedBean, this.fDataModel.isEdit(), this.fDataModel.getOldManagedBeanName(), this.fDataModel.getOldManagedBeanClass(), getter, docletList, propertyImports, methodToInvoke, (JavaBeanPageDataNode)data.getPageDataNode(), data.getMethodToInvokePDN(), data.getCgModel(), null, null, true);
            task.setTypeData(this.fDataModel.getTypeData());
            if (this.fDataModel.isManagedBean() && !this.fDataModel.isEdit()) {
                task.setModifier("protected");
            }
            generatePageCode = true;
            try {
                try {
                    if (this.fDataModel.isEdit() && this.fDataModel.isManagedBean()) {
                        generatePageCode = false;
                        IMethod[] methods = model.getType().getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            String methodName = methods[i].getElementName();
                            if (methodName.equals("get" + JavaCodeUtil.capitalizeFirst((String)this.fDataModel.getOldManagedBeanName()))) {
                                generatePageCode = true;
                                if (Flags.isProtected((int)methods[i].getFlags())) {
                                    task.setModifier("protected");
                                }
                            }
                            ++i;
                        }
                    }
                    if (generatePageCode) {
                        model.runBlockingUIJavaTaskWithContext((AbstractJavaModelTask)task, this.fContext);
                    }
                }
                catch (JavaModelException jme) {
                    jme.printStackTrace();
                    model.release();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                model.release();
                throw throwable;
            }
            model.release();
        }
        if (generatePageCode) {
            actionTarget.getActiveModel().setDirtyState(true);
        }
    }

    private boolean addDetails(ManagedBeanType newManagedBean, ManagedBeanType oldManagedBean) {
        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
        String value = this.fDataModel.getNewManagedBeanName();
        if (value == null || value.length() <= 0) {
            return false;
        }
        ManagedBeanNameType managedBeanName = facesConfigFactory.createManagedBeanNameType();
        managedBeanName.setTextContent(value);
        newManagedBean.setManagedBeanName(managedBeanName);
        value = this.fDataModel.getNewManagedBeanClass();
        if (value == null || value.length() <= 0) {
            return false;
        }
        value = value.replace('$', '.');
        ManagedBeanClassType managedBeanClass = facesConfigFactory.createManagedBeanClassType();
        managedBeanClass.setTextContent(value);
        newManagedBean.setManagedBeanClass(managedBeanClass);
        value = this.fDataModel.getNewManagedBeanScope();
        if (value == null || value.length() <= 0) {
            return false;
        }
        ManagedBeanScopeType managedBeanScope = facesConfigFactory.createManagedBeanScopeType();
        managedBeanScope.setTextContent(value);
        newManagedBean.setManagedBeanScope(managedBeanScope);
        value = this.fDataModel.getNewManagedBeanDescription();
        if (value != null && value.length() > 0) {
            DescriptionType description = facesConfigFactory.createDescriptionType();
            description.setTextContent(value);
            newManagedBean.getDescription().add((Object)description);
        }
        Iterator propIterator = null;
        if (this.fDataModel.getManagedPropertiesList() != null) {
            propIterator = this.fDataModel.getManagedPropertiesList().iterator();
        }
        while (propIterator != null && propIterator.hasNext()) {
            Vector v;
            ValueType value2;
            PropertyClassType propertyClass;
            ValueType value22;
            IInsertElement element = (IInsertElement)propIterator.next();
            String sName = element.getAttribute("property");
            if (sName == null || sName.length() == 0) continue;
            ManagedPropertyType newManagedProperty = facesConfigFactory.createManagedPropertyType();
            PropertyNameType propertyName = facesConfigFactory.createPropertyNameType();
            propertyName.setTextContent(sName);
            newManagedProperty.setPropertyName(propertyName);
            String sValue = element.getAttribute("value");
            String sType = element.getAttribute("type");
            if (sType == null) {
                this.retrieveInstanceProperties(this.fDataModel.getClassName());
                sType = this.getType(sName);
                if (sType != null && sType.equals("java.lang.String")) {
                    sType = null;
                }
            }
            if (sType == null) {
                value22 = facesConfigFactory.createValueType();
                value22.setTextContent(sValue);
                newManagedProperty.setValue(value22);
            } else if (sType.equals("float")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Float");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("double")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Double");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("long")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Long");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("int")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Integer");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("boolean")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Boolean");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("short")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Short");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("byte")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Byte");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("char")) {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent("java.lang.Character");
                newManagedProperty.setPropertyClass(propertyClass);
                value2 = facesConfigFactory.createValueType();
                value2.setTextContent(sValue);
                newManagedProperty.setValue(value2);
            } else if (sType.equals("java.lang.String")) {
                value22 = facesConfigFactory.createValueType();
                value22.setTextContent(sValue);
                newManagedProperty.setValue(value22);
            } else if (this.isType(sType, "java.util.List") || this.isArray(sType)) {
                v = (Vector)element.getData();
                if (sValue != null && (v == null || v.isEmpty())) {
                    value2 = facesConfigFactory.createValueType();
                    value2.setTextContent(sValue);
                    newManagedProperty.setValue(value2);
                } else if (v != null && !v.isEmpty()) {
                    ListEntriesType listEntries = facesConfigFactory.createListEntriesType();
                    String sValueClass = element.getAttribute("valueClass");
                    if (sValueClass != null && sValueClass.length() != 0) {
                        ValueClassType valueClass = facesConfigFactory.createValueClassType();
                        valueClass.setTextContent(sValueClass);
                        listEntries.setValueClass(valueClass);
                    }
                    int i = 0;
                    while (v != null && i < v.size()) {
                        ValueType newValue;
                        String str = (String)v.get(i);
                        if (str == null || str.equals("Null")) {
                            newValue = facesConfigFactory.createValueType();
                            newValue.setTextContent("");
                            listEntries.getNullValue().add((Object)newValue);
                        } else {
                            newValue = facesConfigFactory.createValueType();
                            newValue.setTextContent(str);
                            listEntries.getValue().add((Object)newValue);
                        }
                        ++i;
                    }
                    newManagedProperty.setListEntries(listEntries);
                }
            } else if (this.isType(sType, "java.util.Map")) {
                v = (Vector)element.getData();
                if (sValue != null && (v == null || v.isEmpty())) {
                    ValueType value3 = facesConfigFactory.createValueType();
                    value3.setTextContent(sValue);
                    newManagedProperty.setValue(value3);
                } else {
                    String sValueClass;
                    MapEntriesType mapEntries = facesConfigFactory.createMapEntriesType();
                    String sKeyClass = element.getAttribute("keyClass");
                    if (sKeyClass != null && sKeyClass.length() != 0) {
                        KeyClassType keyClass = facesConfigFactory.createKeyClassType();
                        keyClass.setTextContent(sKeyClass);
                        mapEntries.setKeyClass(keyClass);
                    }
                    if ((sValueClass = element.getAttribute("valueClass")) != null && sValueClass.length() != 0) {
                        ValueClassType valueClass = facesConfigFactory.createValueClassType();
                        valueClass.setTextContent(sValueClass);
                        mapEntries.setValueClass(valueClass);
                    }
                    int i = 0;
                    while (v != null && i < v.size()) {
                        String sMapEntryKey = (String)v.get(i);
                        String sMapEntryValue = (String)v.get(++i);
                        MapEntryType mapEntry = facesConfigFactory.createMapEntryType();
                        KeyType key = facesConfigFactory.createKeyType();
                        key.setTextContent(sMapEntryKey);
                        mapEntry.setKey(key);
                        if (sMapEntryValue != null && !sMapEntryValue.equals("Null")) {
                            ValueType value23 = facesConfigFactory.createValueType();
                            value23.setTextContent(sMapEntryValue);
                            mapEntry.setValue(value23);
                        }
                        mapEntries.getMapEntry().add((Object)mapEntry);
                        ++i;
                    }
                    newManagedProperty.setMapEntries(mapEntries);
                }
            } else {
                propertyClass = facesConfigFactory.createPropertyClassType();
                propertyClass.setTextContent(sType);
                newManagedProperty.setPropertyClass(propertyClass);
                if (sValue == null || sValue.equals("Null")) {
                    NullValueType nullValue = facesConfigFactory.createNullValueType();
                    newManagedProperty.setNullValue(nullValue);
                } else {
                    value2 = facesConfigFactory.createValueType();
                    value2.setTextContent(sValue);
                    newManagedProperty.setValue(value2);
                }
            }
            newManagedBean.getManagedProperty().add((Object)newManagedProperty);
        }
        return true;
    }

    private void createNewManagedBean() {
        IProject project = this.fDataModel.getJsp().getWebModel().getComponent().getProject();
        if (project == null) {
            return;
        }
        if (JsfProjectUtil.isJsfProject((IProject)project)) {
            IResource sourceResource = this.getCurrentResource();
            if (sourceResource == null) {
                sourceResource = project;
            }
            FacesConfigArtifactEdit edit = null;
            try {
                IFile file;
                edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)sourceResource);
                if (edit != null && (file = edit.getFile()) != null) {
                    FacesConfigType facesConfig;
                    IStatus status = null;
                    Display display = Display.getCurrent();
                    if (display == null && PlatformUI.isWorkbenchRunning()) {
                        final IStatus[] statArray = new IStatus[1];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                statArray[0] = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)Display.getCurrent().getActiveShell());
                            }
                        });
                        status = statArray[0];
                    }
                    if (status == null) {
                        Shell shell = display == null ? null : (PlatformUI.isWorkbenchRunning() ? display.getActiveShell() : null);
                        status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
                    }
                    if (status.isOK() && (facesConfig = edit.getFacesConfig()) != null) {
                        EList managedBeans = facesConfig.getManagedBean();
                        FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
                        FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
                        ManagedBeanType newManagedBean = facesConfigFactory.createManagedBeanType();
                        if (this.addDetails(newManagedBean, null)) {
                            managedBeans.add((Object)newManagedBean);
                            edit.save((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private void deleteManagedBean(String sBeanName) {
        if (sBeanName == null || sBeanName.equals("")) {
            return;
        }
        IProject project = this.fDataModel.getJsp().getWebModel().getComponent().getProject();
        if (project == null) {
            return;
        }
        if (JsfProjectUtil.isJsfProject((IProject)project)) {
            IResource sourceResource = this.getCurrentResource();
            if (sourceResource == null) {
                sourceResource = project;
            }
            FacesConfigArtifactEdit edit = null;
            try {
                FacesConfigType facesConfig;
                edit = FacesConfigSchemeUtil.getFacesConfigArtifactEditManagedBeanForWrite((IResource)sourceResource);
                if (edit != null && (facesConfig = edit.getFacesConfig()) != null) {
                    EList managedBeans = facesConfig.getManagedBean();
                    int i = 0;
                    while (i < managedBeans.size()) {
                        String sName;
                        ManagedBeanType managedBean = (ManagedBeanType)managedBeans.get(i);
                        String string = sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                        if (sName != null && sName.equals(sBeanName)) {
                            managedBeans.remove((Object)managedBean);
                        }
                        ++i;
                    }
                    edit.save((IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
        IProgressMonitor mon = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        mon.beginTask(Messages.JSFJavaBeanWizard_insert_data, 50);
        this.fDataModel.getJsp().getData();
        if (this.fDataModel.isNewBean()) {
            IDOMDocument doc;
            if (!this.fDataModel.isEdit()) {
                if (this.fDataModel.isManagedBean()) {
                    this.createNewManagedBean();
                    mon.worked(7);
                }
            } else if (this.fDataModel.isOldIsManagedBean() && this.fDataModel.isManagedBean()) {
                this.updateManagedBean(this.fDataModel.getOldManagedBeanName());
                mon.worked(8);
            } else if (this.fDataModel.isOldIsManagedBean() && !this.fDataModel.isManagedBean()) {
                this.deleteManagedBean(this.fDataModel.getOldManagedBeanName());
                mon.worked(8);
            } else if (!this.fDataModel.isOldIsManagedBean() && this.fDataModel.isManagedBean()) {
                this.createNewManagedBean();
                mon.worked(10);
            }
            if (!PageCodeConfirmation.isSuppressionActive((IDOMDocument)(doc = this.fDataModel.getHtmlEditDomain().getActiveModel().getDocument()))) {
                if (PageCodeConfirmation.getLanguage((IDOMDocument)doc).equalsIgnoreCase("none")) {
                    mon.worked(3);
                    HTMLEditDomain actionTarget = this.fDataModel.getHtmlEditDomain();
                    IDOMDocument xmlDoc = actionTarget.getActiveModel().getDocument();
                    ICBLanguageFactory javaFactory = CodeBehindLanguageRegistry.getRegistry().getCodeBehindLanguageFactory("java");
                    ILocationGenerator locGen = javaFactory.getLocationGenerator();
                    IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
                    IPath newPath = locGen.getLocationForJSP(jspFile);
                    ICBLanguage cbAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
                    cbAdapter.switchLanguage("java", newPath, false);
                    mon.worked(6);
                }
                this.addCodeBehindCode(this.fDataModel.getNewManagedBeanName(), this.fDataModel.getNewManagedBeanClass().replace('$', '.'), this.fDataModel.isManagedBean());
                mon.worked(9);
            }
        } else {
            String[] beans = this.fDataModel.getExistingManagedBeans();
            mon.worked(4);
            if (beans != null && beans.length > 0) {
                int i = 0;
                while (i < beans.length) {
                    this.fDataModel.setNewManagedBeanName(beans[i]);
                    this.addCodeBehindCode(beans[i], beans[i + 1], true);
                    mon.worked(8);
                    i += 2;
                }
            }
        }
        mon.worked(6);
        mon.done();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public String generateGetterContents(String sBeanName, String sBeanClass, boolean bIsManagedBean, Iterator sProperties, boolean bDocletTags) {
        this.fDataModel.getPropertyImports().clear();
        JavaGenericsUtil.TypeData typeData = this.fDataModel.getTypeData();
        String identifier = sBeanName;
        String simpleType = null;
        if (typeData != null) {
            if (typeData.isArray()) {
                simpleType = typeData.getSimpleName();
            } else if (!typeData.isGeneric()) {
                simpleType = typeData.getSimpleName();
            } else {
                simpleType = typeData.getSimpleSignature();
                while (simpleType.endsWith("[]")) {
                    simpleType = simpleType.substring(0, simpleType.length() - 2);
                }
            }
        }
        if (simpleType == null || "".equals(simpleType)) {
            simpleType = Signature.getSimpleName((String)sBeanClass);
        }
        StringBuffer javaCodeBuf = new StringBuffer();
        if (bDocletTags) {
            this.fDataModel.setDocletList(new ArrayList(1));
        }
        javaCodeBuf.append("if (" + identifier + " == null) {");
        if (bIsManagedBean) {
            IProject project = this.fDataModel.getJsp().getWebModel().getComponent().getProject();
            if (project != null) {
                CBModelUtil.addGetManagedBeanMethodToPageCodeBase(project, (IProgressMonitor)new NullProgressMonitor());
            }
            javaCodeBuf.append(String.valueOf(identifier) + " = (" + simpleType + ")getManagedBean(\"" + (this.fDataModel.getBeanName() != null ? this.fDataModel.getBeanName() : identifier) + "\");");
            if (bDocletTags) {
                this.fDataModel.getDocletList().add(new JavaDocElement("managed-bean", "true"));
            }
        } else {
            boolean isArray;
            boolean throwsExceptions = this.getterThrowsExceptions(sBeanClass);
            if (throwsExceptions) {
                javaCodeBuf.append("try {");
            }
            boolean bl = isArray = typeData != null ? typeData.isArray() : simpleType.endsWith("[]");
            if (isArray) {
                String trimmedSimpleType = simpleType;
                if (typeData != null) {
                    int i = 0;
                    while (i < typeData.getDimensions()) {
                        trimmedSimpleType = String.valueOf(trimmedSimpleType) + "[5]";
                        ++i;
                    }
                } else {
                    int depth = 0;
                    while (trimmedSimpleType.endsWith("[]")) {
                        trimmedSimpleType = trimmedSimpleType.substring(0, trimmedSimpleType.length() - 2);
                        ++depth;
                    }
                    int i = 0;
                    while (i < depth) {
                        trimmedSimpleType = String.valueOf(trimmedSimpleType) + "[5]";
                        ++i;
                    }
                }
                javaCodeBuf.append("    " + identifier + " = new " + trimmedSimpleType + ";");
            } else {
                try {
                    IType type = null;
                    if (typeData != null) {
                        type = typeData.getType();
                    }
                    if (type == null) {
                        String erasureSig = Signature.createTypeSignature((String)sBeanClass, (boolean)true);
                        String erasureType = Signature.toString((String)Signature.getTypeErasure((String)erasureSig));
                        type = JavaModelUtil.findType((IJavaProject)JavaCore.create((IProject)this.fDataModel.getJsp().getWebModel().getComponent().getProject()).getJavaProject(), (String)erasureType);
                    }
                    if (type != null && type.isMember()) {
                        IType parent = type;
                        ArrayList<IType> parents = new ArrayList<IType>();
                        while ((parent = parent.getDeclaringType()) != null) {
                            parents.add(0, parent);
                        }
                        StringBuffer prefix = new StringBuffer();
                        int i = 0;
                        while (i < parents.size()) {
                            prefix.append(String.valueOf(((IType)parents.get(i)).getElementName()) + "().new ");
                            ++i;
                        }
                        this.fDataModel.getPropertyImports().add(((IType)parents.get(0)).getFullyQualifiedName());
                        simpleType = prefix + simpleType;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                javaCodeBuf.append("    " + identifier + " = new " + simpleType + "();");
            }
            if (throwsExceptions) {
                javaCodeBuf.append("} catch(Exception e) { e.printStackTrace(); }");
            }
            int i = 0;
            while (sProperties != null && sProperties.hasNext()) {
                IInsertElement element = (IInsertElement)sProperties.next();
                String sPropertyName = element.getAttribute("property");
                String sPropertyValue = element.getAttribute("value");
                String sPropertyType = element.getAttribute("type");
                if (sPropertyName == null || sPropertyName.length() == 0) continue;
                StringBuffer javaDocBuf = new StringBuffer();
                if (this.isType(sPropertyType, "java.util.List")) {
                    String sValueClass = element.getAttribute("valueClass");
                    if (sValueClass == null) {
                        sValueClass = "";
                    }
                    javaDocBuf.append("<" + sValueClass + ">");
                    if (sValueClass != null && !sValueClass.equals("") && !sValueClass.startsWith("java.lang")) {
                        this.fDataModel.getPropertyImports().add(sValueClass);
                    }
                    String sListType = sPropertyType.equals("java.util.List") ? "java.util.Vector" : sPropertyType;
                    this.fDataModel.getPropertyImports().add(sListType);
                    javaCodeBuf.append("    " + Signature.getSimpleName((String)sListType) + " " + sPropertyName + "_list = new " + Signature.getSimpleName((String)sListType) + "();");
                    Vector v = (Vector)element.getData();
                    int j = 0;
                    while (v != null && j < v.size()) {
                        String str = (String)v.get(j);
                        javaDocBuf.append("," + str);
                        javaCodeBuf.append("    " + sPropertyName + "_list.add(");
                        if (sValueClass.equals("") || sValueClass.equals("java.lang.String")) {
                            if (BindingUtil.isVblExpression((String)str)) {
                                javaCodeBuf.append("resolveExpression(\"" + str + "\")");
                            } else {
                                javaCodeBuf.append("\"" + str + "\"");
                            }
                        } else if (BindingUtil.isVblExpression((String)str)) {
                            javaCodeBuf.append("(" + Signature.getSimpleName((String)sValueClass) + ")resolveExpression(\"" + str + "\")");
                        } else {
                            javaCodeBuf.append("new " + Signature.getSimpleName((String)sValueClass) + "(" + str + ")");
                        }
                        javaCodeBuf.append(");");
                        ++j;
                    }
                    sPropertyValue = javaDocBuf.toString();
                    javaCodeBuf.append("    " + identifier + ".set" + JavaCodeUtil.capitalizeFirst((String)sPropertyName) + "(" + sPropertyName + "_list);");
                } else if (this.isType(sPropertyType, "java.util.Map")) {
                    String sKeyClass = element.getAttribute("keyClass");
                    if (sKeyClass == null) {
                        sKeyClass = "";
                    }
                    javaDocBuf.append("[<" + sKeyClass + ">");
                    String sValueClass = element.getAttribute("valueClass");
                    if (sValueClass == null) {
                        sValueClass = "";
                    }
                    javaDocBuf.append(",<" + sValueClass + ">]");
                    if (sKeyClass != null && !sKeyClass.equals("")) {
                        this.fDataModel.getPropertyImports().add(sKeyClass);
                    }
                    if (sValueClass != null && !sValueClass.equals("")) {
                        this.fDataModel.getPropertyImports().add(sValueClass);
                    }
                    String sMapType = sPropertyType.equals("java.util.Map") ? "java.util.HashMap" : sPropertyType;
                    this.fDataModel.getPropertyImports().add(sMapType);
                    javaCodeBuf.append("    " + Signature.getSimpleName((String)sMapType) + " " + sPropertyName + "_map = new " + Signature.getSimpleName((String)sMapType) + "();");
                    Vector v = (Vector)element.getData();
                    int j = 0;
                    while (v != null && j < v.size()) {
                        String str_k = (String)v.get(j);
                        String str_v = (String)v.get(++j);
                        javaDocBuf.append(",[" + str_k + "," + str_v + "]");
                        javaCodeBuf.append("    " + sPropertyName + "_map.put(");
                        if (sKeyClass.equals("") || sKeyClass.equals("java.lang.String")) {
                            if (BindingUtil.isVblExpression((String)str_k)) {
                                javaCodeBuf.append("resolveExpression(\"" + str_k + "\")");
                            } else {
                                javaCodeBuf.append("\"" + str_k + "\"");
                            }
                        } else if (BindingUtil.isVblExpression((String)str_k)) {
                            javaCodeBuf.append("(" + Signature.getSimpleName((String)sKeyClass) + ")resolveExpression(\"" + str_k + "\")");
                        } else {
                            javaCodeBuf.append("new " + Signature.getSimpleName((String)sKeyClass) + "(" + str_k + ")");
                        }
                        javaCodeBuf.append(",");
                        if (sValueClass.equals("") || sValueClass.equals("java.lang.String")) {
                            if (BindingUtil.isVblExpression((String)str_v)) {
                                javaCodeBuf.append("resolveExpression(\"" + str_v + "\")");
                            } else {
                                javaCodeBuf.append("\"" + str_v + "\"");
                            }
                        } else if (BindingUtil.isVblExpression((String)str_v)) {
                            javaCodeBuf.append("(" + Signature.getSimpleName((String)sValueClass) + ")resolveExpression(\"" + str_v + "\")");
                        } else {
                            javaCodeBuf.append("new " + Signature.getSimpleName((String)sValueClass) + "(" + str_v + ")");
                        }
                        javaCodeBuf.append(");");
                        ++j;
                    }
                    sPropertyValue = javaDocBuf.toString();
                    javaCodeBuf.append("    " + identifier + ".set" + JavaCodeUtil.capitalizeFirst((String)sPropertyName) + "(" + sPropertyName + "_map);");
                } else {
                    if (sPropertyValue == null) {
                        sPropertyValue = "";
                    }
                    javaCodeBuf.append("    " + identifier + ".set" + JavaCodeUtil.capitalizeFirst((String)sPropertyName) + "(");
                    if (sPropertyValue.equals("Null")) {
                        sPropertyValue = "null";
                    }
                    if (sPropertyType == null || sPropertyType.equals("")) {
                        if (BindingUtil.isVblExpression((String)sPropertyValue)) {
                            javaCodeBuf.append("resolveExpression(\"" + sPropertyValue + "\")");
                        } else {
                            javaCodeBuf.append("\"" + sPropertyValue + "\"");
                        }
                    } else if (this.isPrimitiveType(sPropertyType)) {
                        if (BindingUtil.isVblExpression((String)sPropertyValue)) {
                            javaCodeBuf.append("(" + sPropertyType + ")resolveExpression(\"" + sPropertyValue + "\")");
                        } else if (sPropertyType.equals("char")) {
                            if (sPropertyValue.length() > 0) {
                                javaCodeBuf.append("'" + sPropertyValue.charAt(0) + "'");
                            } else {
                                javaCodeBuf.append("' '");
                            }
                        } else if (sPropertyType.equals("byte")) {
                            if (sPropertyValue.length() > 0) {
                                javaCodeBuf.append("\"" + sPropertyValue + "\".getBytes()[0]");
                            } else {
                                javaCodeBuf.append("(byte)' '");
                            }
                        } else if (sPropertyType.equals("short") || sPropertyType.equals("float")) {
                            javaCodeBuf.append("(" + sPropertyType + ")" + sPropertyValue);
                        } else {
                            javaCodeBuf.append(sPropertyValue);
                        }
                    } else {
                        if (BindingUtil.isVblExpression((String)sPropertyValue)) {
                            javaCodeBuf.append("(" + Signature.getSimpleName((String)sPropertyType) + ")resolveExpression(\"" + sPropertyValue + "\")");
                        } else {
                            if (sPropertyType.equals("java.lang.String") && (sPropertyValue.charAt(0) != '\"' || sPropertyValue.charAt(sPropertyValue.length() - 1) != '\"')) {
                                sPropertyValue = "\"" + sPropertyValue + "\"";
                            }
                            javaCodeBuf.append("new " + Signature.getSimpleName((String)sPropertyType) + "(" + sPropertyValue + ")");
                        }
                        this.fDataModel.getPropertyImports().add(sPropertyType);
                    }
                    javaCodeBuf.append(");");
                }
                if (bDocletTags) {
                    this.fDataModel.getDocletList().add(new JavaDocElement("property" + i, String.valueOf(sPropertyName) + "=" + sPropertyValue));
                }
                ++i;
            }
        }
        javaCodeBuf.append("}");
        javaCodeBuf.append("return " + identifier + ";");
        return javaCodeBuf.toString();
    }

    private IResource getCurrentResource() {
        HTMLEditDomain actionTarget = this.fDataModel.getHtmlEditDomain();
        IDOMDocument xmlDoc = actionTarget.getActiveModel().getDocument();
        if (xmlDoc != null) {
            return CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
        }
        return null;
    }

    public String getGetterContents() {
        boolean bIsManagedBean;
        String beanName = this.fDataModel.getData().getPageDataNode().getInstanceID();
        String beanClass = this.fDataModel.getData().getPageDataNode().getClassName();
        if (beanClass != null) {
            beanClass = beanClass.replace('$', '.');
        }
        boolean bl = bIsManagedBean = this.fDataModel.getJDocInfo().getCommentForTag("managed-bean") != null;
        if (!bIsManagedBean) {
            String sProperty;
            this.retrieveInstanceProperties(beanClass);
            int i = 0;
            Vector<InsertElementImpl> workList = new Vector<InsertElementImpl>();
            while ((sProperty = this.fDataModel.getJDocInfo().getCommentForTag("property" + i)) != null) {
                String propertyName = sProperty.substring(0, sProperty.indexOf("="));
                String sValue = sProperty.substring(sProperty.indexOf("=") + 1);
                InsertElementImpl ieNew = new InsertElementImpl("jsp:setProperty");
                ieNew.pushAttribute("property", propertyName);
                if (sValue.length() > 0) {
                    ieNew.pushAttribute("value", sValue);
                }
                String propertyType = this.getType(propertyName);
                ieNew.pushAttribute("type", propertyType);
                if (this.isType(propertyType, "java.util.List")) {
                    String sValueClass = "";
                    StringTokenizer tokenizer = new StringTokenizer(sValue, ",");
                    boolean bFirst = true;
                    Vector<String> v = new Vector<String>();
                    while (tokenizer.hasMoreTokens()) {
                        String val = tokenizer.nextToken().trim();
                        if (bFirst) {
                            if (val.length() > 2 && val.charAt(0) == '<' && val.charAt(val.length() - 1) == '>') {
                                sValueClass = val.substring(1, val.length() - 1);
                            }
                            bFirst = false;
                            continue;
                        }
                        v.add(val);
                    }
                    ieNew.pushAttribute("valueClass", sValueClass);
                    ieNew.setData(v);
                } else if (this.isType(propertyType, "java.util.Map")) {
                    String sKeyClass = "";
                    String sValueClass = "";
                    StringTokenizer tokenizer = new StringTokenizer(sValue, "]");
                    boolean bFirst = true;
                    Vector<String> v = new Vector<String>();
                    while (tokenizer.hasMoreTokens()) {
                        String val = tokenizer.nextToken().trim();
                        if (val.startsWith(",")) {
                            val = val.substring(1);
                        }
                        int index = val.indexOf(",");
                        if (bFirst) {
                            if (val.length() > 3 && val.charAt(0) == '[' && val.charAt(1) == '<' && val.charAt(val.length() - 1) == '>') {
                                sKeyClass = val.substring(2, index - 1).trim();
                                sValueClass = val.substring(index + 2, val.length() - 1);
                            }
                            bFirst = false;
                            continue;
                        }
                        String val1 = val.substring(1, index).trim();
                        String val2 = val.substring(index + 1).trim();
                        v.add(val1);
                        v.add(val2);
                    }
                    ieNew.pushAttribute("keyClass", sKeyClass);
                    ieNew.pushAttribute("valueClass", sValueClass);
                    ieNew.setData(v);
                }
                workList.add(ieNew);
                ++i;
            }
            Iterator fPropertiesList = workList.iterator();
            return this.generateGetterContents(beanName, beanClass, bIsManagedBean, fPropertiesList, false);
        }
        return this.generateGetterContents(beanName, beanClass, bIsManagedBean, null, false);
    }

    private JavaClass getJavaClass(String className) {
        IProject project = this.fDataModel.getJsp().getWebModel().getComponent().getProject();
        if (project == null) {
            return null;
        }
        BeaninfoNature nature = null;
        try {
            nature = BeaninfoNature.getRuntime((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (nature == null) {
            return null;
        }
        ResourceSet rset = nature.getResourceSet();
        if (rset == null) {
            return null;
        }
        return Utilities.getJavaClass((String)className, (ResourceSet)rset);
    }

    public String[] getPropertyImports() {
        return this.fDataModel.getPropertyImports().toArray(new String[this.fDataModel.getPropertyImports().size()]);
    }

    private boolean getterThrowsExceptions(String className) {
        boolean throwsExceptions;
        block6: {
            throwsExceptions = false;
            try {
                IMethod[] methods;
                String trimmedSimpleType = className;
                if (className.endsWith("[]")) {
                    while (trimmedSimpleType.endsWith("[]")) {
                        trimmedSimpleType = trimmedSimpleType.substring(0, trimmedSimpleType.length() - 2);
                    }
                }
                String trimmedSimpleTypeSig = Signature.createTypeSignature((String)trimmedSimpleType, (boolean)true);
                trimmedSimpleType = Signature.toString((String)Signature.getTypeErasure((String)trimmedSimpleTypeSig));
                IType type = JavaModelUtil.findType((IJavaProject)JavaCore.create((IProject)this.fDataModel.getJsp().getWebModel().getComponent().getProject()).getJavaProject(), (String)trimmedSimpleType);
                if (type == null || (methods = type.getMethods()) == null || methods.length <= 0) break block6;
                int i = 0;
                while (i < methods.length) {
                    IMethod method = methods[i];
                    if (method.isConstructor() && method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags()) && method.getExceptionTypes().length > 0) {
                        throwsExceptions = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return throwsExceptions;
    }

    private String getType(String sName) {
        int i = 0;
        while (this.fInstanceProperties != null && i < this.fInstanceProperties.length) {
            if (this.fInstanceProperties[i].equals(sName)) {
                return this.fInstancePropertyTypes[i];
            }
            ++i;
        }
        return "";
    }

    private boolean isArray(String sType) {
        boolean isArray = false;
        if (sType.endsWith("[]")) {
            isArray = true;
        }
        return isArray;
    }

    private boolean isPrimitiveType(String sType) {
        return sType.equals("float") || sType.equals("double") || sType.equals("long") || sType.equals("int") || sType.equals("short") || sType.equals("boolean") || sType.equals("byte") || sType.equals("char");
    }

    private boolean isType(String sType, String superclassName) {
        if (sType == null || sType.equals("")) {
            return false;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> possibleSuper = null;
        Class<?> typeClass = null;
        try {
            possibleSuper = loader.loadClass(superclassName);
            typeClass = loader.loadClass(sType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (possibleSuper == null || typeClass == null) {
            return false;
        }
        return possibleSuper.isAssignableFrom(typeClass);
    }

    public void retrieveInstanceProperties(String className) {
        this.fInstanceProperties = new String[0];
        this.fInstancePropertyTypes = new String[0];
        if (className == null) {
            return;
        }
        JavaClass javaClass = this.getJavaClass(className);
        if (javaClass == null) {
            return;
        }
        if (javaClass instanceof ArrayType && (javaClass = (JavaClass)((ArrayType)javaClass).getComponentTypeAsHelper()) == null) {
            return;
        }
        BeanInformationImpl beanInfo = null;
        try {
            BeanDecorator beanDecorator = Utilities.getBeanDecorator((EModelElement)javaClass);
            if (beanDecorator == null) {
                return;
            }
            beanInfo = new BeanInformationImpl(javaClass, beanDecorator);
        }
        catch (Throwable throwable) {
            beanInfo = null;
        }
        Vector<BeanProperty> v = new Vector<BeanProperty>();
        if (beanInfo != null) {
            int propSize = beanInfo.getPropertySize();
            int i = 0;
            while (i < propSize) {
                v.add(beanInfo.getProperty(i));
                ++i;
            }
        }
        if (v.size() == 0) {
            return;
        }
        this.fInstanceProperties = new String[v.size()];
        this.fInstancePropertyTypes = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            this.fInstanceProperties[i] = ((BeanProperty)v.get(i)).getName();
            this.fInstancePropertyTypes[i] = ((BeanProperty)v.get(i)).getPropertyType();
            ++i;
        }
    }

    private void updateManagedBean(String sBeanName) {
        this.deleteManagedBean(sBeanName);
        this.createNewManagedBean();
    }
}

