/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.support;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.java.Method;

public class ResultBeanGenInfo {
    private String instanceName;
    private String instanceClass;
    private String requiredImport;
    private boolean isResultBeanRequired = true;

    public ResultBeanGenInfo(String beanInstanceName, Method method, JavaModel context) {
        this.instanceName = ResultBeanGenInfo.generateResultBeanInstanceID(beanInstanceName, method, context);
        if (method.isVoid()) {
            this.isResultBeanRequired = false;
        } else {
            String resultBeanFullyQualifiedType = method.getReturnType().getJavaName();
            int dotIndex = resultBeanFullyQualifiedType.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex + 1 < resultBeanFullyQualifiedType.length()) {
                this.instanceClass = resultBeanFullyQualifiedType.substring(dotIndex + 1, resultBeanFullyQualifiedType.length());
                this.requiredImport = resultBeanFullyQualifiedType;
                while (this.requiredImport.endsWith("[]")) {
                    this.requiredImport = this.requiredImport.substring(0, this.requiredImport.length() - 2);
                }
            } else {
                this.instanceClass = resultBeanFullyQualifiedType;
            }
        }
    }

    public static String generateResultBeanInstanceID(String rootBeanName, IMethod method, JavaModel context) {
        IType type;
        String resultBeanInstanceID = String.valueOf(rootBeanName) + JavaCodeUtil.capitalizeFirst((String)method.getElementName()) + "ResultBean";
        if (context != null && (type = context.getType()) != null) {
            IField field = type.getField(resultBeanInstanceID);
            int i = 1;
            while (field.exists()) {
                resultBeanInstanceID = String.valueOf(resultBeanInstanceID) + i++;
                field = type.getField(resultBeanInstanceID);
            }
        }
        return resultBeanInstanceID;
    }

    public static String generateResultBeanInstanceID(String rootBeanName, Method method, JavaModel context) {
        IType type;
        String resultBeanInstanceID = String.valueOf(rootBeanName) + JavaCodeUtil.capitalizeFirst((String)method.getName()) + "ResultBean";
        if (context != null && (type = context.getType()) != null) {
            IField field = type.getField(resultBeanInstanceID);
            int i = 1;
            while (field.exists()) {
                resultBeanInstanceID = String.valueOf(resultBeanInstanceID) + i++;
                field = type.getField(resultBeanInstanceID);
            }
        }
        return resultBeanInstanceID;
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getRequiredImport() {
        return this.requiredImport;
    }

    public boolean isRequired() {
        return this.isResultBeanRequired;
    }
}

